/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to get an origin access identity's information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetCloudFrontOriginAccessIdentityRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetCloudFrontOriginAccessIdentityRequest.Builder, GetCloudFrontOriginAccessIdentityRequest> {
    private final String id;

    private GetCloudFrontOriginAccessIdentityRequest(BuilderImpl builder) {
        this.id = builder.id;
    }

    /**
     * <p>
     * The identity's ID.
     * </p>
     * 
     * @return The identity's ID.
     */
    public String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCloudFrontOriginAccessIdentityRequest)) {
            return false;
        }
        GetCloudFrontOriginAccessIdentityRequest other = (GetCloudFrontOriginAccessIdentityRequest) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetCloudFrontOriginAccessIdentityRequest> {
        /**
         * <p>
         * The identity's ID.
         * </p>
         * 
         * @param id
         *        The identity's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCloudFrontOriginAccessIdentityRequest model) {
            id(model.id);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public GetCloudFrontOriginAccessIdentityRequest build() {
            return new GetCloudFrontOriginAccessIdentityRequest(this);
        }
    }
}
