/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A distribution Configuration and a list of tags to be associated with the distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DistributionConfigWithTags implements
        ToCopyableBuilder<DistributionConfigWithTags.Builder, DistributionConfigWithTags> {
    private final DistributionConfig distributionConfig;

    private final Tags tags;

    private DistributionConfigWithTags(BuilderImpl builder) {
        this.distributionConfig = builder.distributionConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A distribution configuration.
     * </p>
     * 
     * @return A distribution configuration.
     */
    public DistributionConfig distributionConfig() {
        return distributionConfig;
    }

    /**
     * <p>
     * A complex type that contains zero or more <code>Tag</code> elements.
     * </p>
     * 
     * @return A complex type that contains zero or more <code>Tag</code> elements.
     */
    public Tags tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((distributionConfig() == null) ? 0 : distributionConfig().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionConfigWithTags)) {
            return false;
        }
        DistributionConfigWithTags other = (DistributionConfigWithTags) obj;
        if (other.distributionConfig() == null ^ this.distributionConfig() == null) {
            return false;
        }
        if (other.distributionConfig() != null && !other.distributionConfig().equals(this.distributionConfig())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (distributionConfig() != null) {
            sb.append("DistributionConfig: ").append(distributionConfig()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionConfig":
            return Optional.of(clazz.cast(distributionConfig()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DistributionConfigWithTags> {
        /**
         * <p>
         * A distribution configuration.
         * </p>
         * 
         * @param distributionConfig
         *        A distribution configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfig(DistributionConfig distributionConfig);

        /**
         * <p>
         * A complex type that contains zero or more <code>Tag</code> elements.
         * </p>
         * 
         * @param tags
         *        A complex type that contains zero or more <code>Tag</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tags tags);
    }

    static final class BuilderImpl implements Builder {
        private DistributionConfig distributionConfig;

        private Tags tags;

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionConfigWithTags model) {
            distributionConfig(model.distributionConfig);
            tags(model.tags);
        }

        public final DistributionConfig.Builder getDistributionConfig() {
            return distributionConfig != null ? distributionConfig.toBuilder() : null;
        }

        @Override
        public final Builder distributionConfig(DistributionConfig distributionConfig) {
            this.distributionConfig = distributionConfig;
            return this;
        }

        public final void setDistributionConfig(DistributionConfig.BuilderImpl distributionConfig) {
            this.distributionConfig = distributionConfig != null ? distributionConfig.build() : null;
        }

        public final Tags.Builder getTags() {
            return tags != null ? tags.toBuilder() : null;
        }

        @Override
        public final Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        public final void setTags(Tags.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public DistributionConfigWithTags build() {
            return new DistributionConfigWithTags(this);
        }
    }
}
