/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A customer origin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CustomOriginConfig implements ToCopyableBuilder<CustomOriginConfig.Builder, CustomOriginConfig> {
    private final Integer httpPort;

    private final Integer httpsPort;

    private final String originProtocolPolicy;

    private final OriginSslProtocols originSslProtocols;

    private final Integer originReadTimeout;

    private final Integer originKeepaliveTimeout;

    private CustomOriginConfig(BuilderImpl builder) {
        this.httpPort = builder.httpPort;
        this.httpsPort = builder.httpsPort;
        this.originProtocolPolicy = builder.originProtocolPolicy;
        this.originSslProtocols = builder.originSslProtocols;
        this.originReadTimeout = builder.originReadTimeout;
        this.originKeepaliveTimeout = builder.originKeepaliveTimeout;
    }

    /**
     * <p>
     * The HTTP port the custom origin listens on.
     * </p>
     * 
     * @return The HTTP port the custom origin listens on.
     */
    public Integer httpPort() {
        return httpPort;
    }

    /**
     * <p>
     * The HTTPS port the custom origin listens on.
     * </p>
     * 
     * @return The HTTPS port the custom origin listens on.
     */
    public Integer httpsPort() {
        return httpsPort;
    }

    /**
     * <p>
     * The origin protocol policy to apply to your origin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originProtocolPolicy} will return {@link OriginProtocolPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #originProtocolPolicyString}.
     * </p>
     * 
     * @return The origin protocol policy to apply to your origin.
     * @see OriginProtocolPolicy
     */
    public OriginProtocolPolicy originProtocolPolicy() {
        return OriginProtocolPolicy.fromValue(originProtocolPolicy);
    }

    /**
     * <p>
     * The origin protocol policy to apply to your origin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originProtocolPolicy} will return {@link OriginProtocolPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #originProtocolPolicyString}.
     * </p>
     * 
     * @return The origin protocol policy to apply to your origin.
     * @see OriginProtocolPolicy
     */
    public String originProtocolPolicyString() {
        return originProtocolPolicy;
    }

    /**
     * <p>
     * The SSL/TLS protocols that you want CloudFront to use when communicating with your origin over HTTPS.
     * </p>
     * 
     * @return The SSL/TLS protocols that you want CloudFront to use when communicating with your origin over HTTPS.
     */
    public OriginSslProtocols originSslProtocols() {
        return originSslProtocols;
    }

    /**
     * <p>
     * You can create a custom origin read timeout. All timeout units are in seconds. The default origin read timeout is
     * 30 seconds, but you can configure custom timeout lengths using the CloudFront API. The minimum timeout length is
     * 4 seconds; the maximum is 60 seconds.
     * </p>
     * <p>
     * If you need to increase the maximum time limit, contact the <a
     * href="https://console.aws.amazon.com/support/home#/">AWS Support Center</a>.
     * </p>
     * 
     * @return You can create a custom origin read timeout. All timeout units are in seconds. The default origin read
     *         timeout is 30 seconds, but you can configure custom timeout lengths using the CloudFront API. The minimum
     *         timeout length is 4 seconds; the maximum is 60 seconds.</p>
     *         <p>
     *         If you need to increase the maximum time limit, contact the <a
     *         href="https://console.aws.amazon.com/support/home#/">AWS Support Center</a>.
     */
    public Integer originReadTimeout() {
        return originReadTimeout;
    }

    /**
     * <p>
     * You can create a custom keep-alive timeout. All timeout units are in seconds. The default keep-alive timeout is 5
     * seconds, but you can configure custom timeout lengths using the CloudFront API. The minimum timeout length is 1
     * second; the maximum is 60 seconds.
     * </p>
     * <p>
     * If you need to increase the maximum time limit, contact the <a
     * href="https://console.aws.amazon.com/support/home#/">AWS Support Center</a>.
     * </p>
     * 
     * @return You can create a custom keep-alive timeout. All timeout units are in seconds. The default keep-alive
     *         timeout is 5 seconds, but you can configure custom timeout lengths using the CloudFront API. The minimum
     *         timeout length is 1 second; the maximum is 60 seconds.</p>
     *         <p>
     *         If you need to increase the maximum time limit, contact the <a
     *         href="https://console.aws.amazon.com/support/home#/">AWS Support Center</a>.
     */
    public Integer originKeepaliveTimeout() {
        return originKeepaliveTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((httpPort() == null) ? 0 : httpPort().hashCode());
        hashCode = 31 * hashCode + ((httpsPort() == null) ? 0 : httpsPort().hashCode());
        hashCode = 31 * hashCode + ((originProtocolPolicyString() == null) ? 0 : originProtocolPolicyString().hashCode());
        hashCode = 31 * hashCode + ((originSslProtocols() == null) ? 0 : originSslProtocols().hashCode());
        hashCode = 31 * hashCode + ((originReadTimeout() == null) ? 0 : originReadTimeout().hashCode());
        hashCode = 31 * hashCode + ((originKeepaliveTimeout() == null) ? 0 : originKeepaliveTimeout().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomOriginConfig)) {
            return false;
        }
        CustomOriginConfig other = (CustomOriginConfig) obj;
        if (other.httpPort() == null ^ this.httpPort() == null) {
            return false;
        }
        if (other.httpPort() != null && !other.httpPort().equals(this.httpPort())) {
            return false;
        }
        if (other.httpsPort() == null ^ this.httpsPort() == null) {
            return false;
        }
        if (other.httpsPort() != null && !other.httpsPort().equals(this.httpsPort())) {
            return false;
        }
        if (other.originProtocolPolicyString() == null ^ this.originProtocolPolicyString() == null) {
            return false;
        }
        if (other.originProtocolPolicyString() != null
                && !other.originProtocolPolicyString().equals(this.originProtocolPolicyString())) {
            return false;
        }
        if (other.originSslProtocols() == null ^ this.originSslProtocols() == null) {
            return false;
        }
        if (other.originSslProtocols() != null && !other.originSslProtocols().equals(this.originSslProtocols())) {
            return false;
        }
        if (other.originReadTimeout() == null ^ this.originReadTimeout() == null) {
            return false;
        }
        if (other.originReadTimeout() != null && !other.originReadTimeout().equals(this.originReadTimeout())) {
            return false;
        }
        if (other.originKeepaliveTimeout() == null ^ this.originKeepaliveTimeout() == null) {
            return false;
        }
        if (other.originKeepaliveTimeout() != null && !other.originKeepaliveTimeout().equals(this.originKeepaliveTimeout())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (httpPort() != null) {
            sb.append("HTTPPort: ").append(httpPort()).append(",");
        }
        if (httpsPort() != null) {
            sb.append("HTTPSPort: ").append(httpsPort()).append(",");
        }
        if (originProtocolPolicyString() != null) {
            sb.append("OriginProtocolPolicy: ").append(originProtocolPolicyString()).append(",");
        }
        if (originSslProtocols() != null) {
            sb.append("OriginSslProtocols: ").append(originSslProtocols()).append(",");
        }
        if (originReadTimeout() != null) {
            sb.append("OriginReadTimeout: ").append(originReadTimeout()).append(",");
        }
        if (originKeepaliveTimeout() != null) {
            sb.append("OriginKeepaliveTimeout: ").append(originKeepaliveTimeout()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HTTPPort":
            return Optional.of(clazz.cast(httpPort()));
        case "HTTPSPort":
            return Optional.of(clazz.cast(httpsPort()));
        case "OriginProtocolPolicy":
            return Optional.of(clazz.cast(originProtocolPolicyString()));
        case "OriginSslProtocols":
            return Optional.of(clazz.cast(originSslProtocols()));
        case "OriginReadTimeout":
            return Optional.of(clazz.cast(originReadTimeout()));
        case "OriginKeepaliveTimeout":
            return Optional.of(clazz.cast(originKeepaliveTimeout()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CustomOriginConfig> {
        /**
         * <p>
         * The HTTP port the custom origin listens on.
         * </p>
         * 
         * @param httpPort
         *        The HTTP port the custom origin listens on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpPort(Integer httpPort);

        /**
         * <p>
         * The HTTPS port the custom origin listens on.
         * </p>
         * 
         * @param httpsPort
         *        The HTTPS port the custom origin listens on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpsPort(Integer httpsPort);

        /**
         * <p>
         * The origin protocol policy to apply to your origin.
         * </p>
         * 
         * @param originProtocolPolicy
         *        The origin protocol policy to apply to your origin.
         * @see OriginProtocolPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginProtocolPolicy
         */
        Builder originProtocolPolicy(String originProtocolPolicy);

        /**
         * <p>
         * The origin protocol policy to apply to your origin.
         * </p>
         * 
         * @param originProtocolPolicy
         *        The origin protocol policy to apply to your origin.
         * @see OriginProtocolPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginProtocolPolicy
         */
        Builder originProtocolPolicy(OriginProtocolPolicy originProtocolPolicy);

        /**
         * <p>
         * The SSL/TLS protocols that you want CloudFront to use when communicating with your origin over HTTPS.
         * </p>
         * 
         * @param originSslProtocols
         *        The SSL/TLS protocols that you want CloudFront to use when communicating with your origin over HTTPS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originSslProtocols(OriginSslProtocols originSslProtocols);

        /**
         * <p>
         * You can create a custom origin read timeout. All timeout units are in seconds. The default origin read
         * timeout is 30 seconds, but you can configure custom timeout lengths using the CloudFront API. The minimum
         * timeout length is 4 seconds; the maximum is 60 seconds.
         * </p>
         * <p>
         * If you need to increase the maximum time limit, contact the <a
         * href="https://console.aws.amazon.com/support/home#/">AWS Support Center</a>.
         * </p>
         * 
         * @param originReadTimeout
         *        You can create a custom origin read timeout. All timeout units are in seconds. The default origin read
         *        timeout is 30 seconds, but you can configure custom timeout lengths using the CloudFront API. The
         *        minimum timeout length is 4 seconds; the maximum is 60 seconds.</p>
         *        <p>
         *        If you need to increase the maximum time limit, contact the <a
         *        href="https://console.aws.amazon.com/support/home#/">AWS Support Center</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originReadTimeout(Integer originReadTimeout);

        /**
         * <p>
         * You can create a custom keep-alive timeout. All timeout units are in seconds. The default keep-alive timeout
         * is 5 seconds, but you can configure custom timeout lengths using the CloudFront API. The minimum timeout
         * length is 1 second; the maximum is 60 seconds.
         * </p>
         * <p>
         * If you need to increase the maximum time limit, contact the <a
         * href="https://console.aws.amazon.com/support/home#/">AWS Support Center</a>.
         * </p>
         * 
         * @param originKeepaliveTimeout
         *        You can create a custom keep-alive timeout. All timeout units are in seconds. The default keep-alive
         *        timeout is 5 seconds, but you can configure custom timeout lengths using the CloudFront API. The
         *        minimum timeout length is 1 second; the maximum is 60 seconds.</p>
         *        <p>
         *        If you need to increase the maximum time limit, contact the <a
         *        href="https://console.aws.amazon.com/support/home#/">AWS Support Center</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originKeepaliveTimeout(Integer originKeepaliveTimeout);
    }

    static final class BuilderImpl implements Builder {
        private Integer httpPort;

        private Integer httpsPort;

        private String originProtocolPolicy;

        private OriginSslProtocols originSslProtocols;

        private Integer originReadTimeout;

        private Integer originKeepaliveTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomOriginConfig model) {
            httpPort(model.httpPort);
            httpsPort(model.httpsPort);
            originProtocolPolicy(model.originProtocolPolicy);
            originSslProtocols(model.originSslProtocols);
            originReadTimeout(model.originReadTimeout);
            originKeepaliveTimeout(model.originKeepaliveTimeout);
        }

        public final Integer getHTTPPort() {
            return httpPort;
        }

        @Override
        public final Builder httpPort(Integer httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        public final void setHTTPPort(Integer httpPort) {
            this.httpPort = httpPort;
        }

        public final Integer getHTTPSPort() {
            return httpsPort;
        }

        @Override
        public final Builder httpsPort(Integer httpsPort) {
            this.httpsPort = httpsPort;
            return this;
        }

        public final void setHTTPSPort(Integer httpsPort) {
            this.httpsPort = httpsPort;
        }

        public final String getOriginProtocolPolicy() {
            return originProtocolPolicy;
        }

        @Override
        public final Builder originProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = originProtocolPolicy;
            return this;
        }

        @Override
        public final Builder originProtocolPolicy(OriginProtocolPolicy originProtocolPolicy) {
            this.originProtocolPolicy(originProtocolPolicy.toString());
            return this;
        }

        public final void setOriginProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = originProtocolPolicy;
        }

        public final OriginSslProtocols.Builder getOriginSslProtocols() {
            return originSslProtocols != null ? originSslProtocols.toBuilder() : null;
        }

        @Override
        public final Builder originSslProtocols(OriginSslProtocols originSslProtocols) {
            this.originSslProtocols = originSslProtocols;
            return this;
        }

        public final void setOriginSslProtocols(OriginSslProtocols.BuilderImpl originSslProtocols) {
            this.originSslProtocols = originSslProtocols != null ? originSslProtocols.build() : null;
        }

        public final Integer getOriginReadTimeout() {
            return originReadTimeout;
        }

        @Override
        public final Builder originReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
            return this;
        }

        public final void setOriginReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
        }

        public final Integer getOriginKeepaliveTimeout() {
            return originKeepaliveTimeout;
        }

        @Override
        public final Builder originKeepaliveTimeout(Integer originKeepaliveTimeout) {
            this.originKeepaliveTimeout = originKeepaliveTimeout;
            return this;
        }

        public final void setOriginKeepaliveTimeout(Integer originKeepaliveTimeout) {
            this.originKeepaliveTimeout = originKeepaliveTimeout;
        }

        @Override
        public CustomOriginConfig build() {
            return new CustomOriginConfig(this);
        }
    }
}
