/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to create a new distribution with tags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDistributionWithTagsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateDistributionWithTagsRequest.Builder, CreateDistributionWithTagsRequest> {
    private final DistributionConfigWithTags distributionConfigWithTags;

    private CreateDistributionWithTagsRequest(BuilderImpl builder) {
        this.distributionConfigWithTags = builder.distributionConfigWithTags;
    }

    /**
     * <p>
     * The distribution's configuration information.
     * </p>
     * 
     * @return The distribution's configuration information.
     */
    public DistributionConfigWithTags distributionConfigWithTags() {
        return distributionConfigWithTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((distributionConfigWithTags() == null) ? 0 : distributionConfigWithTags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDistributionWithTagsRequest)) {
            return false;
        }
        CreateDistributionWithTagsRequest other = (CreateDistributionWithTagsRequest) obj;
        if (other.distributionConfigWithTags() == null ^ this.distributionConfigWithTags() == null) {
            return false;
        }
        if (other.distributionConfigWithTags() != null
                && !other.distributionConfigWithTags().equals(this.distributionConfigWithTags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (distributionConfigWithTags() != null) {
            sb.append("DistributionConfigWithTags: ").append(distributionConfigWithTags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionConfigWithTags":
            return Optional.of(clazz.cast(distributionConfigWithTags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDistributionWithTagsRequest> {
        /**
         * <p>
         * The distribution's configuration information.
         * </p>
         * 
         * @param distributionConfigWithTags
         *        The distribution's configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfigWithTags(DistributionConfigWithTags distributionConfigWithTags);
    }

    static final class BuilderImpl implements Builder {
        private DistributionConfigWithTags distributionConfigWithTags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDistributionWithTagsRequest model) {
            distributionConfigWithTags(model.distributionConfigWithTags);
        }

        public final DistributionConfigWithTags.Builder getDistributionConfigWithTags() {
            return distributionConfigWithTags != null ? distributionConfigWithTags.toBuilder() : null;
        }

        @Override
        public final Builder distributionConfigWithTags(DistributionConfigWithTags distributionConfigWithTags) {
            this.distributionConfigWithTags = distributionConfigWithTags;
            return this;
        }

        public final void setDistributionConfigWithTags(DistributionConfigWithTags.BuilderImpl distributionConfigWithTags) {
            this.distributionConfigWithTags = distributionConfigWithTags != null ? distributionConfigWithTags.build() : null;
        }

        @Override
        public CreateDistributionWithTagsRequest build() {
            return new CreateDistributionWithTagsRequest(this);
        }
    }
}
