/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateCloudFrontOriginAccessIdentityResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateCloudFrontOriginAccessIdentityResponse.Builder, CreateCloudFrontOriginAccessIdentityResponse> {
    private final CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity;

    private final String location;

    private final String eTag;

    private CreateCloudFrontOriginAccessIdentityResponse(BuilderImpl builder) {
        this.cloudFrontOriginAccessIdentity = builder.cloudFrontOriginAccessIdentity;
        this.location = builder.location;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The origin access identity's information.
     * </p>
     * 
     * @return The origin access identity's information.
     */
    public CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity() {
        return cloudFrontOriginAccessIdentity;
    }

    /**
     * <p>
     * The fully qualified URI of the new origin access identity just created. For example:
     * <code>https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront/E74FTE3AJFJ256A</code>.
     * </p>
     * 
     * @return The fully qualified URI of the new origin access identity just created. For example:
     *         <code>https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront/E74FTE3AJFJ256A</code>
     *         .
     */
    public String location() {
        return location;
    }

    /**
     * <p>
     * The current version of the origin access identity created.
     * </p>
     * 
     * @return The current version of the origin access identity created.
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((cloudFrontOriginAccessIdentity() == null) ? 0 : cloudFrontOriginAccessIdentity().hashCode());
        hashCode = 31 * hashCode + ((location() == null) ? 0 : location().hashCode());
        hashCode = 31 * hashCode + ((eTag() == null) ? 0 : eTag().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudFrontOriginAccessIdentityResponse)) {
            return false;
        }
        CreateCloudFrontOriginAccessIdentityResponse other = (CreateCloudFrontOriginAccessIdentityResponse) obj;
        if (other.cloudFrontOriginAccessIdentity() == null ^ this.cloudFrontOriginAccessIdentity() == null) {
            return false;
        }
        if (other.cloudFrontOriginAccessIdentity() != null
                && !other.cloudFrontOriginAccessIdentity().equals(this.cloudFrontOriginAccessIdentity())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.eTag() == null ^ this.eTag() == null) {
            return false;
        }
        if (other.eTag() != null && !other.eTag().equals(this.eTag())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (cloudFrontOriginAccessIdentity() != null) {
            sb.append("CloudFrontOriginAccessIdentity: ").append(cloudFrontOriginAccessIdentity()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        if (eTag() != null) {
            sb.append("ETag: ").append(eTag()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudFrontOriginAccessIdentity":
            return Optional.of(clazz.cast(cloudFrontOriginAccessIdentity()));
        case "Location":
            return Optional.of(clazz.cast(location()));
        case "ETag":
            return Optional.of(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateCloudFrontOriginAccessIdentityResponse> {
        /**
         * <p>
         * The origin access identity's information.
         * </p>
         * 
         * @param cloudFrontOriginAccessIdentity
         *        The origin access identity's information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontOriginAccessIdentity(CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity);

        /**
         * <p>
         * The fully qualified URI of the new origin access identity just created. For example:
         * <code>https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront/E74FTE3AJFJ256A</code>.
         * </p>
         * 
         * @param location
         *        The fully qualified URI of the new origin access identity just created. For example:
         *        <code>https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront/E74FTE3AJFJ256A</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The current version of the origin access identity created.
         * </p>
         * 
         * @param eTag
         *        The current version of the origin access identity created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl implements Builder {
        private CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity;

        private String location;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudFrontOriginAccessIdentityResponse model) {
            cloudFrontOriginAccessIdentity(model.cloudFrontOriginAccessIdentity);
            location(model.location);
            eTag(model.eTag);
        }

        public final CloudFrontOriginAccessIdentity.Builder getCloudFrontOriginAccessIdentity() {
            return cloudFrontOriginAccessIdentity != null ? cloudFrontOriginAccessIdentity.toBuilder() : null;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentity(CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity) {
            this.cloudFrontOriginAccessIdentity = cloudFrontOriginAccessIdentity;
            return this;
        }

        public final void setCloudFrontOriginAccessIdentity(
                CloudFrontOriginAccessIdentity.BuilderImpl cloudFrontOriginAccessIdentity) {
            this.cloudFrontOriginAccessIdentity = cloudFrontOriginAccessIdentity != null ? cloudFrontOriginAccessIdentity.build()
                    : null;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public CreateCloudFrontOriginAccessIdentityResponse build() {
            return new CreateCloudFrontOriginAccessIdentityResponse(this);
        }
    }
}
