/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to create a new origin access identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateCloudFrontOriginAccessIdentityRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateCloudFrontOriginAccessIdentityRequest.Builder, CreateCloudFrontOriginAccessIdentityRequest> {
    private final CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

    private CreateCloudFrontOriginAccessIdentityRequest(BuilderImpl builder) {
        this.cloudFrontOriginAccessIdentityConfig = builder.cloudFrontOriginAccessIdentityConfig;
    }

    /**
     * <p>
     * The current configuration information for the identity.
     * </p>
     * 
     * @return The current configuration information for the identity.
     */
    public CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig() {
        return cloudFrontOriginAccessIdentityConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + ((cloudFrontOriginAccessIdentityConfig() == null) ? 0 : cloudFrontOriginAccessIdentityConfig().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudFrontOriginAccessIdentityRequest)) {
            return false;
        }
        CreateCloudFrontOriginAccessIdentityRequest other = (CreateCloudFrontOriginAccessIdentityRequest) obj;
        if (other.cloudFrontOriginAccessIdentityConfig() == null ^ this.cloudFrontOriginAccessIdentityConfig() == null) {
            return false;
        }
        if (other.cloudFrontOriginAccessIdentityConfig() != null
                && !other.cloudFrontOriginAccessIdentityConfig().equals(this.cloudFrontOriginAccessIdentityConfig())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (cloudFrontOriginAccessIdentityConfig() != null) {
            sb.append("CloudFrontOriginAccessIdentityConfig: ").append(cloudFrontOriginAccessIdentityConfig()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudFrontOriginAccessIdentityConfig":
            return Optional.of(clazz.cast(cloudFrontOriginAccessIdentityConfig()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateCloudFrontOriginAccessIdentityRequest> {
        /**
         * <p>
         * The current configuration information for the identity.
         * </p>
         * 
         * @param cloudFrontOriginAccessIdentityConfig
         *        The current configuration information for the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig);
    }

    static final class BuilderImpl implements Builder {
        private CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudFrontOriginAccessIdentityRequest model) {
            cloudFrontOriginAccessIdentityConfig(model.cloudFrontOriginAccessIdentityConfig);
        }

        public final CloudFrontOriginAccessIdentityConfig.Builder getCloudFrontOriginAccessIdentityConfig() {
            return cloudFrontOriginAccessIdentityConfig != null ? cloudFrontOriginAccessIdentityConfig.toBuilder() : null;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentityConfig(
                CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
            return this;
        }

        public final void setCloudFrontOriginAccessIdentityConfig(
                CloudFrontOriginAccessIdentityConfig.BuilderImpl cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig != null ? cloudFrontOriginAccessIdentityConfig
                    .build() : null;
        }

        @Override
        public CreateCloudFrontOriginAccessIdentityRequest build() {
            return new CreateCloudFrontOriginAccessIdentityRequest(this);
        }
    }
}
