/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of the information about a CloudFront origin access identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CloudFrontOriginAccessIdentitySummary implements
        ToCopyableBuilder<CloudFrontOriginAccessIdentitySummary.Builder, CloudFrontOriginAccessIdentitySummary> {
    private final String id;

    private final String s3CanonicalUserId;

    private final String comment;

    private CloudFrontOriginAccessIdentitySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.s3CanonicalUserId = builder.s3CanonicalUserId;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The ID for the origin access identity. For example: <code>E74FTE3AJFJ256A</code>.
     * </p>
     * 
     * @return The ID for the origin access identity. For example: <code>E74FTE3AJFJ256A</code>.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon S3 canonical user ID for the origin access identity, which you use when giving the origin access
     * identity read permission to an object in Amazon S3.
     * </p>
     * 
     * @return The Amazon S3 canonical user ID for the origin access identity, which you use when giving the origin
     *         access identity read permission to an object in Amazon S3.
     */
    public String s3CanonicalUserId() {
        return s3CanonicalUserId;
    }

    /**
     * <p>
     * The comment for this origin access identity, as originally specified when created.
     * </p>
     * 
     * @return The comment for this origin access identity, as originally specified when created.
     */
    public String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((s3CanonicalUserId() == null) ? 0 : s3CanonicalUserId().hashCode());
        hashCode = 31 * hashCode + ((comment() == null) ? 0 : comment().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFrontOriginAccessIdentitySummary)) {
            return false;
        }
        CloudFrontOriginAccessIdentitySummary other = (CloudFrontOriginAccessIdentitySummary) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.s3CanonicalUserId() == null ^ this.s3CanonicalUserId() == null) {
            return false;
        }
        if (other.s3CanonicalUserId() != null && !other.s3CanonicalUserId().equals(this.s3CanonicalUserId())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (s3CanonicalUserId() != null) {
            sb.append("S3CanonicalUserId: ").append(s3CanonicalUserId()).append(",");
        }
        if (comment() != null) {
            sb.append("Comment: ").append(comment()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "S3CanonicalUserId":
            return Optional.of(clazz.cast(s3CanonicalUserId()));
        case "Comment":
            return Optional.of(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CloudFrontOriginAccessIdentitySummary> {
        /**
         * <p>
         * The ID for the origin access identity. For example: <code>E74FTE3AJFJ256A</code>.
         * </p>
         * 
         * @param id
         *        The ID for the origin access identity. For example: <code>E74FTE3AJFJ256A</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon S3 canonical user ID for the origin access identity, which you use when giving the origin access
         * identity read permission to an object in Amazon S3.
         * </p>
         * 
         * @param s3CanonicalUserId
         *        The Amazon S3 canonical user ID for the origin access identity, which you use when giving the origin
         *        access identity read permission to an object in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3CanonicalUserId(String s3CanonicalUserId);

        /**
         * <p>
         * The comment for this origin access identity, as originally specified when created.
         * </p>
         * 
         * @param comment
         *        The comment for this origin access identity, as originally specified when created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String s3CanonicalUserId;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFrontOriginAccessIdentitySummary model) {
            id(model.id);
            s3CanonicalUserId(model.s3CanonicalUserId);
            comment(model.comment);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getS3CanonicalUserId() {
            return s3CanonicalUserId;
        }

        @Override
        public final Builder s3CanonicalUserId(String s3CanonicalUserId) {
            this.s3CanonicalUserId = s3CanonicalUserId;
            return this;
        }

        public final void setS3CanonicalUserId(String s3CanonicalUserId) {
            this.s3CanonicalUserId = s3CanonicalUserId;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public CloudFrontOriginAccessIdentitySummary build() {
            return new CloudFrontOriginAccessIdentitySummary(this);
        }
    }
}
