/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CloudFront origin access identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CloudFrontOriginAccessIdentity implements
        ToCopyableBuilder<CloudFrontOriginAccessIdentity.Builder, CloudFrontOriginAccessIdentity> {
    private final String id;

    private final String s3CanonicalUserId;

    private final CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

    private CloudFrontOriginAccessIdentity(BuilderImpl builder) {
        this.id = builder.id;
        this.s3CanonicalUserId = builder.s3CanonicalUserId;
        this.cloudFrontOriginAccessIdentityConfig = builder.cloudFrontOriginAccessIdentityConfig;
    }

    /**
     * <p>
     * The ID for the origin access identity. For example: <code>E74FTE3AJFJ256A</code>.
     * </p>
     * 
     * @return The ID for the origin access identity. For example: <code>E74FTE3AJFJ256A</code>.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon S3 canonical user ID for the origin access identity, used when giving the origin access identity read
     * permission to an object in Amazon S3.
     * </p>
     * 
     * @return The Amazon S3 canonical user ID for the origin access identity, used when giving the origin access
     *         identity read permission to an object in Amazon S3.
     */
    public String s3CanonicalUserId() {
        return s3CanonicalUserId;
    }

    /**
     * <p>
     * The current configuration information for the identity.
     * </p>
     * 
     * @return The current configuration information for the identity.
     */
    public CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig() {
        return cloudFrontOriginAccessIdentityConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((s3CanonicalUserId() == null) ? 0 : s3CanonicalUserId().hashCode());
        hashCode = 31 * hashCode
                + ((cloudFrontOriginAccessIdentityConfig() == null) ? 0 : cloudFrontOriginAccessIdentityConfig().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFrontOriginAccessIdentity)) {
            return false;
        }
        CloudFrontOriginAccessIdentity other = (CloudFrontOriginAccessIdentity) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.s3CanonicalUserId() == null ^ this.s3CanonicalUserId() == null) {
            return false;
        }
        if (other.s3CanonicalUserId() != null && !other.s3CanonicalUserId().equals(this.s3CanonicalUserId())) {
            return false;
        }
        if (other.cloudFrontOriginAccessIdentityConfig() == null ^ this.cloudFrontOriginAccessIdentityConfig() == null) {
            return false;
        }
        if (other.cloudFrontOriginAccessIdentityConfig() != null
                && !other.cloudFrontOriginAccessIdentityConfig().equals(this.cloudFrontOriginAccessIdentityConfig())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (s3CanonicalUserId() != null) {
            sb.append("S3CanonicalUserId: ").append(s3CanonicalUserId()).append(",");
        }
        if (cloudFrontOriginAccessIdentityConfig() != null) {
            sb.append("CloudFrontOriginAccessIdentityConfig: ").append(cloudFrontOriginAccessIdentityConfig()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "S3CanonicalUserId":
            return Optional.of(clazz.cast(s3CanonicalUserId()));
        case "CloudFrontOriginAccessIdentityConfig":
            return Optional.of(clazz.cast(cloudFrontOriginAccessIdentityConfig()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CloudFrontOriginAccessIdentity> {
        /**
         * <p>
         * The ID for the origin access identity. For example: <code>E74FTE3AJFJ256A</code>.
         * </p>
         * 
         * @param id
         *        The ID for the origin access identity. For example: <code>E74FTE3AJFJ256A</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon S3 canonical user ID for the origin access identity, used when giving the origin access identity
         * read permission to an object in Amazon S3.
         * </p>
         * 
         * @param s3CanonicalUserId
         *        The Amazon S3 canonical user ID for the origin access identity, used when giving the origin access
         *        identity read permission to an object in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3CanonicalUserId(String s3CanonicalUserId);

        /**
         * <p>
         * The current configuration information for the identity.
         * </p>
         * 
         * @param cloudFrontOriginAccessIdentityConfig
         *        The current configuration information for the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String s3CanonicalUserId;

        private CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFrontOriginAccessIdentity model) {
            id(model.id);
            s3CanonicalUserId(model.s3CanonicalUserId);
            cloudFrontOriginAccessIdentityConfig(model.cloudFrontOriginAccessIdentityConfig);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getS3CanonicalUserId() {
            return s3CanonicalUserId;
        }

        @Override
        public final Builder s3CanonicalUserId(String s3CanonicalUserId) {
            this.s3CanonicalUserId = s3CanonicalUserId;
            return this;
        }

        public final void setS3CanonicalUserId(String s3CanonicalUserId) {
            this.s3CanonicalUserId = s3CanonicalUserId;
        }

        public final CloudFrontOriginAccessIdentityConfig.Builder getCloudFrontOriginAccessIdentityConfig() {
            return cloudFrontOriginAccessIdentityConfig != null ? cloudFrontOriginAccessIdentityConfig.toBuilder() : null;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentityConfig(
                CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
            return this;
        }

        public final void setCloudFrontOriginAccessIdentityConfig(
                CloudFrontOriginAccessIdentityConfig.BuilderImpl cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig != null ? cloudFrontOriginAccessIdentityConfig
                    .build() : null;
        }

        @Override
        public CloudFrontOriginAccessIdentity build() {
            return new CloudFrontOriginAccessIdentity(this);
        }
    }
}
