/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.waiters.DistributionDeployed;
import software.amazon.awssdk.services.cloudfront.waiters.GetDistributionFunction;
import software.amazon.awssdk.services.cloudfront.waiters.GetInvalidationFunction;
import software.amazon.awssdk.services.cloudfront.waiters.GetStreamingDistributionFunction;
import software.amazon.awssdk.services.cloudfront.waiters.InvalidationCompleted;
import software.amazon.awssdk.services.cloudfront.waiters.StreamingDistributionDeployed;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;

public class CloudFrontClientWaiters {
    private final CloudFrontClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public CloudFrontClientWaiters(CloudFrontClient client) {
        this.client = client;
    }

    public Waiter<GetDistributionRequest> distributionDeployed() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetDistributionFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new DistributionDeployed.IsDeployedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(25), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetStreamingDistributionRequest> streamingDistributionDeployed() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetStreamingDistributionFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StreamingDistributionDeployed.IsDeployedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(25), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetInvalidationRequest> invalidationCompleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetInvalidationFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InvalidationCompleted.IsCompletedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(30), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(20))).withExecutorService(this.executorService).build();
    }
}

