/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.QueryStringCacheKeys;

public class QueryStringCacheKeysUnmarshaller
implements Unmarshaller<QueryStringCacheKeys, StaxUnmarshallerContext> {
    private static final QueryStringCacheKeysUnmarshaller INSTANCE = new QueryStringCacheKeysUnmarshaller();

    public QueryStringCacheKeys unmarshall(StaxUnmarshallerContext context) throws Exception {
        QueryStringCacheKeys.Builder queryStringCacheKeys;
        block6: {
            queryStringCacheKeys = QueryStringCacheKeys.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> items = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    queryStringCacheKeys.items(items);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Quantity", targetDepth)) {
                        queryStringCacheKeys.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Items", targetDepth)) {
                        items = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("Items/Name", targetDepth)) continue;
                    items.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            queryStringCacheKeys.items(items);
        }
        return (QueryStringCacheKeys)queryStringCacheKeys.build();
    }

    public static QueryStringCacheKeysUnmarshaller getInstance() {
        return INSTANCE;
    }
}

