/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListStreamingDistributionsRequestMarshaller
implements Marshaller<Request<ListStreamingDistributionsRequest>, ListStreamingDistributionsRequest> {
    public Request<ListStreamingDistributionsRequest> marshall(ListStreamingDistributionsRequest listStreamingDistributionsRequest) {
        if (listStreamingDistributionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listStreamingDistributionsRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2017-03-25/streaming-distribution";
        request.setResourcePath(uriResourcePath);
        if (listStreamingDistributionsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listStreamingDistributionsRequest.marker()));
        }
        if (listStreamingDistributionsRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromString((String)listStreamingDistributionsRequest.maxItems()));
        }
        return request;
    }
}

