/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.AllowedMethods;
import software.amazon.awssdk.services.cloudfront.transform.CachedMethodsUnmarshaller;

public class AllowedMethodsUnmarshaller
implements Unmarshaller<AllowedMethods, StaxUnmarshallerContext> {
    private static final AllowedMethodsUnmarshaller INSTANCE = new AllowedMethodsUnmarshaller();

    public AllowedMethods unmarshall(StaxUnmarshallerContext context) throws Exception {
        AllowedMethods.Builder allowedMethods;
        block7: {
            allowedMethods = AllowedMethods.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> items = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    allowedMethods.items(items);
                    break block7;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Quantity", targetDepth)) {
                        allowedMethods.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Items", targetDepth)) {
                        items = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("Items/Method", targetDepth)) {
                        items.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("CachedMethods", targetDepth)) continue;
                    allowedMethods.cachedMethods(CachedMethodsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            allowedMethods.items(items);
        }
        return (AllowedMethods)allowedMethods.build();
    }

    public static AllowedMethodsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

