/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudFrontOriginAccessIdentity
implements ToCopyableBuilder<Builder, CloudFrontOriginAccessIdentity> {
    private final String id;
    private final String s3CanonicalUserId;
    private final CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

    private CloudFrontOriginAccessIdentity(BuilderImpl builder) {
        this.id = builder.id;
        this.s3CanonicalUserId = builder.s3CanonicalUserId;
        this.cloudFrontOriginAccessIdentityConfig = builder.cloudFrontOriginAccessIdentityConfig;
    }

    public String id() {
        return this.id;
    }

    public String s3CanonicalUserId() {
        return this.s3CanonicalUserId;
    }

    public CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig() {
        return this.cloudFrontOriginAccessIdentityConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.s3CanonicalUserId() == null ? 0 : this.s3CanonicalUserId().hashCode());
        hashCode = 31 * hashCode + (this.cloudFrontOriginAccessIdentityConfig() == null ? 0 : this.cloudFrontOriginAccessIdentityConfig().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFrontOriginAccessIdentity)) {
            return false;
        }
        CloudFrontOriginAccessIdentity other = (CloudFrontOriginAccessIdentity)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.s3CanonicalUserId() == null ^ this.s3CanonicalUserId() == null) {
            return false;
        }
        if (other.s3CanonicalUserId() != null && !other.s3CanonicalUserId().equals(this.s3CanonicalUserId())) {
            return false;
        }
        if (other.cloudFrontOriginAccessIdentityConfig() == null ^ this.cloudFrontOriginAccessIdentityConfig() == null) {
            return false;
        }
        return other.cloudFrontOriginAccessIdentityConfig() == null || other.cloudFrontOriginAccessIdentityConfig().equals(this.cloudFrontOriginAccessIdentityConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.s3CanonicalUserId() != null) {
            sb.append("S3CanonicalUserId: ").append(this.s3CanonicalUserId()).append(",");
        }
        if (this.cloudFrontOriginAccessIdentityConfig() != null) {
            sb.append("CloudFrontOriginAccessIdentityConfig: ").append(this.cloudFrontOriginAccessIdentityConfig()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String s3CanonicalUserId;
        private CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFrontOriginAccessIdentity model) {
            this.setId(model.id);
            this.setS3CanonicalUserId(model.s3CanonicalUserId);
            this.setCloudFrontOriginAccessIdentityConfig(model.cloudFrontOriginAccessIdentityConfig);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getS3CanonicalUserId() {
            return this.s3CanonicalUserId;
        }

        @Override
        public final Builder s3CanonicalUserId(String s3CanonicalUserId) {
            this.s3CanonicalUserId = s3CanonicalUserId;
            return this;
        }

        public final void setS3CanonicalUserId(String s3CanonicalUserId) {
            this.s3CanonicalUserId = s3CanonicalUserId;
        }

        public final CloudFrontOriginAccessIdentityConfig getCloudFrontOriginAccessIdentityConfig() {
            return this.cloudFrontOriginAccessIdentityConfig;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
            return this;
        }

        public final void setCloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
        }

        public CloudFrontOriginAccessIdentity build() {
            return new CloudFrontOriginAccessIdentity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudFrontOriginAccessIdentity> {
        public Builder id(String var1);

        public Builder s3CanonicalUserId(String var1);

        public Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig var1);
    }
}

