/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudfront.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * LambdaFunctionAssociations StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class LambdaFunctionAssociationsUnmarshaller implements Unmarshaller<LambdaFunctionAssociations, StaxUnmarshallerContext> {

    public LambdaFunctionAssociations unmarshall(StaxUnmarshallerContext context) throws Exception {
        LambdaFunctionAssociations.Builder lambdaFunctionAssociations = LambdaFunctionAssociations.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<LambdaFunctionAssociation> items = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                lambdaFunctionAssociations.items(items);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Quantity", targetDepth)) {
                    lambdaFunctionAssociations.quantity(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Items", targetDepth)) {
                    items = new ArrayList<LambdaFunctionAssociation>();
                    continue;
                }

                if (context.testExpression("Items/LambdaFunctionAssociation", targetDepth)) {
                    items.add(LambdaFunctionAssociationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    lambdaFunctionAssociations.items(items);
                    break;
                }
            }
        }
        return lambdaFunctionAssociations.build();
    }

    private static final LambdaFunctionAssociationsUnmarshaller INSTANCE = new LambdaFunctionAssociationsUnmarshaller();

    public static LambdaFunctionAssociationsUnmarshaller getInstance() {
        return INSTANCE;
    }
}
