/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to update an origin access identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateCloudFrontOriginAccessIdentityRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateCloudFrontOriginAccessIdentityRequest.Builder, UpdateCloudFrontOriginAccessIdentityRequest> {
    private final CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

    private final String id;

    private final String ifMatch;

    private UpdateCloudFrontOriginAccessIdentityRequest(BuilderImpl builder) {
        this.cloudFrontOriginAccessIdentityConfig = builder.cloudFrontOriginAccessIdentityConfig;
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    /**
     * <p>
     * The identity's configuration information.
     * </p>
     * 
     * @return The identity's configuration information.
     */
    public CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig() {
        return cloudFrontOriginAccessIdentityConfig;
    }

    /**
     * <p>
     * The identity's id.
     * </p>
     * 
     * @return The identity's id.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The value of the <code>ETag</code> header that you received when retrieving the identity's configuration. For
     * example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The value of the <code>ETag</code> header that you received when retrieving the identity's configuration.
     *         For example: <code>E2QWRUHAPOMQZL</code>.
     */
    public String ifMatch() {
        return ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + ((cloudFrontOriginAccessIdentityConfig() == null) ? 0 : cloudFrontOriginAccessIdentityConfig().hashCode());
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((ifMatch() == null) ? 0 : ifMatch().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCloudFrontOriginAccessIdentityRequest)) {
            return false;
        }
        UpdateCloudFrontOriginAccessIdentityRequest other = (UpdateCloudFrontOriginAccessIdentityRequest) obj;
        if (other.cloudFrontOriginAccessIdentityConfig() == null ^ this.cloudFrontOriginAccessIdentityConfig() == null) {
            return false;
        }
        if (other.cloudFrontOriginAccessIdentityConfig() != null
                && !other.cloudFrontOriginAccessIdentityConfig().equals(this.cloudFrontOriginAccessIdentityConfig())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.ifMatch() == null ^ this.ifMatch() == null) {
            return false;
        }
        if (other.ifMatch() != null && !other.ifMatch().equals(this.ifMatch())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (cloudFrontOriginAccessIdentityConfig() != null) {
            sb.append("CloudFrontOriginAccessIdentityConfig: ").append(cloudFrontOriginAccessIdentityConfig()).append(",");
        }
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (ifMatch() != null) {
            sb.append("IfMatch: ").append(ifMatch()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateCloudFrontOriginAccessIdentityRequest> {
        /**
         * <p>
         * The identity's configuration information.
         * </p>
         * 
         * @param cloudFrontOriginAccessIdentityConfig
         *        The identity's configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig);

        /**
         * <p>
         * The identity's id.
         * </p>
         * 
         * @param id
         *        The identity's id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The value of the <code>ETag</code> header that you received when retrieving the identity's configuration. For
         * example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param ifMatch
         *        The value of the <code>ETag</code> header that you received when retrieving the identity's
         *        configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);
    }

    private static final class BuilderImpl implements Builder {
        private CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

        private String id;

        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCloudFrontOriginAccessIdentityRequest model) {
            setCloudFrontOriginAccessIdentityConfig(model.cloudFrontOriginAccessIdentityConfig);
            setId(model.id);
            setIfMatch(model.ifMatch);
        }

        public final CloudFrontOriginAccessIdentityConfig getCloudFrontOriginAccessIdentityConfig() {
            return cloudFrontOriginAccessIdentityConfig;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentityConfig(
                CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
            return this;
        }

        public final void setCloudFrontOriginAccessIdentityConfig(
                CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public UpdateCloudFrontOriginAccessIdentityRequest build() {
            return new UpdateCloudFrontOriginAccessIdentityRequest(this);
        }
    }
}
