/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that controls whether access logs are written for this streaming distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StreamingLoggingConfig implements ToCopyableBuilder<StreamingLoggingConfig.Builder, StreamingLoggingConfig> {
    private final Boolean enabled;

    private final String bucket;

    private final String prefix;

    private StreamingLoggingConfig(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
    }

    /**
     * <p>
     * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you do not want to enable
     * logging when you create a streaming distribution or if you want to disable logging for an existing streaming
     * distribution, specify <code>false</code> for <code>Enabled</code>, and specify <code>empty Bucket</code> and
     * <code>Prefix</code> elements. If you specify <code>false</code> for <code>Enabled</code> but you specify values
     * for <code>Bucket</code> and <code>Prefix</code>, the values are automatically deleted.
     * </p>
     * 
     * @return Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you do not want to
     *         enable logging when you create a streaming distribution or if you want to disable logging for an existing
     *         streaming distribution, specify <code>false</code> for <code>Enabled</code>, and specify
     *         <code>empty Bucket</code> and <code>Prefix</code> elements. If you specify <code>false</code> for
     *         <code>Enabled</code> but you specify values for <code>Bucket</code> and <code>Prefix</code>, the values
     *         are automatically deleted.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The Amazon S3 bucket to store the access logs in, for example, <code>myawslogbucket.s3.amazonaws.com</code>.
     * </p>
     * 
     * @return The Amazon S3 bucket to store the access logs in, for example,
     *         <code>myawslogbucket.s3.amazonaws.com</code>.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * An optional string that you want CloudFront to prefix to the access log <code>filenames</code> for this streaming
     * distribution, for example, <code>myprefix/</code>. If you want to enable logging, but you do not want to specify
     * a prefix, you still must include an empty <code>Prefix</code> element in the <code>Logging</code> element.
     * </p>
     * 
     * @return An optional string that you want CloudFront to prefix to the access log <code>filenames</code> for this
     *         streaming distribution, for example, <code>myprefix/</code>. If you want to enable logging, but you do
     *         not want to specify a prefix, you still must include an empty <code>Prefix</code> element in the
     *         <code>Logging</code> element.
     */
    public String prefix() {
        return prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((enabled() == null) ? 0 : enabled().hashCode());
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingLoggingConfig)) {
            return false;
        }
        StreamingLoggingConfig other = (StreamingLoggingConfig) obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (enabled() != null) {
            sb.append("Enabled: ").append(enabled()).append(",");
        }
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, StreamingLoggingConfig> {
        /**
         * <p>
         * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you do not want to
         * enable logging when you create a streaming distribution or if you want to disable logging for an existing
         * streaming distribution, specify <code>false</code> for <code>Enabled</code>, and specify
         * <code>empty Bucket</code> and <code>Prefix</code> elements. If you specify <code>false</code> for
         * <code>Enabled</code> but you specify values for <code>Bucket</code> and <code>Prefix</code>, the values are
         * automatically deleted.
         * </p>
         * 
         * @param enabled
         *        Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you do not want
         *        to enable logging when you create a streaming distribution or if you want to disable logging for an
         *        existing streaming distribution, specify <code>false</code> for <code>Enabled</code>, and specify
         *        <code>empty Bucket</code> and <code>Prefix</code> elements. If you specify <code>false</code> for
         *        <code>Enabled</code> but you specify values for <code>Bucket</code> and <code>Prefix</code>, the
         *        values are automatically deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The Amazon S3 bucket to store the access logs in, for example, <code>myawslogbucket.s3.amazonaws.com</code>.
         * </p>
         * 
         * @param bucket
         *        The Amazon S3 bucket to store the access logs in, for example,
         *        <code>myawslogbucket.s3.amazonaws.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * An optional string that you want CloudFront to prefix to the access log <code>filenames</code> for this
         * streaming distribution, for example, <code>myprefix/</code>. If you want to enable logging, but you do not
         * want to specify a prefix, you still must include an empty <code>Prefix</code> element in the
         * <code>Logging</code> element.
         * </p>
         * 
         * @param prefix
         *        An optional string that you want CloudFront to prefix to the access log <code>filenames</code> for
         *        this streaming distribution, for example, <code>myprefix/</code>. If you want to enable logging, but
         *        you do not want to specify a prefix, you still must include an empty <code>Prefix</code> element in
         *        the <code>Logging</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String bucket;

        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingLoggingConfig model) {
            setEnabled(model.enabled);
            setBucket(model.bucket);
            setPrefix(model.prefix);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public StreamingLoggingConfig build() {
            return new StreamingLoggingConfig(this);
        }
    }
}
