/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListInvalidationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListInvalidationsResponse.Builder, ListInvalidationsResponse> {
    private final InvalidationList invalidationList;

    private ListInvalidationsResponse(BuilderImpl builder) {
        this.invalidationList = builder.invalidationList;
    }

    /**
     * <p>
     * Information about invalidation batches.
     * </p>
     * 
     * @return Information about invalidation batches.
     */
    public InvalidationList invalidationList() {
        return invalidationList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((invalidationList() == null) ? 0 : invalidationList().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvalidationsResponse)) {
            return false;
        }
        ListInvalidationsResponse other = (ListInvalidationsResponse) obj;
        if (other.invalidationList() == null ^ this.invalidationList() == null) {
            return false;
        }
        if (other.invalidationList() != null && !other.invalidationList().equals(this.invalidationList())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (invalidationList() != null) {
            sb.append("InvalidationList: ").append(invalidationList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListInvalidationsResponse> {
        /**
         * <p>
         * Information about invalidation batches.
         * </p>
         * 
         * @param invalidationList
         *        Information about invalidation batches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidationList(InvalidationList invalidationList);
    }

    private static final class BuilderImpl implements Builder {
        private InvalidationList invalidationList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvalidationsResponse model) {
            setInvalidationList(model.invalidationList);
        }

        public final InvalidationList getInvalidationList() {
            return invalidationList;
        }

        @Override
        public final Builder invalidationList(InvalidationList invalidationList) {
            this.invalidationList = invalidationList;
            return this;
        }

        public final void setInvalidationList(InvalidationList invalidationList) {
            this.invalidationList = invalidationList;
        }

        @Override
        public ListInvalidationsResponse build() {
            return new ListInvalidationsResponse(this);
        }
    }
}
