/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that specifies a list of Lambda functions associations for a cache behavior.
 * </p>
 * <p>
 * If you want to invoke one or more Lambda functions triggered by requests that match the <code>PathPattern</code> of
 * the cache behavior, specify the applicable values for <code>Quantity</code> and <code>Items</code>. Note that there
 * can be up to 4 <code>LambdaFunctionAssociation</code> items in this list (one for each possible value of
 * <code>EventType</code>) and each <code>EventType</code> can be associated with the Lambda function only once.
 * </p>
 * <p>
 * If you don't want to invoke any Lambda functions for the requests that match <code>PathPattern</code>, specify
 * <code>0</code> for <code>Quantity</code> and omit <code>Items</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LambdaFunctionAssociations implements
        ToCopyableBuilder<LambdaFunctionAssociations.Builder, LambdaFunctionAssociations> {
    private final Integer quantity;

    private final List<LambdaFunctionAssociation> items;

    private LambdaFunctionAssociations(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The number of Lambda function associations for this cache behavior.
     * </p>
     * 
     * @return The number of Lambda function associations for this cache behavior.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items for this cache
     * behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items for this cache
     *         behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
     */
    public List<LambdaFunctionAssociation> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((quantity() == null) ? 0 : quantity().hashCode());
        hashCode = 31 * hashCode + ((items() == null) ? 0 : items().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionAssociations)) {
            return false;
        }
        LambdaFunctionAssociations other = (LambdaFunctionAssociations) obj;
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        if (other.items() != null && !other.items().equals(this.items())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (quantity() != null) {
            sb.append("Quantity: ").append(quantity()).append(",");
        }
        if (items() != null) {
            sb.append("Items: ").append(items()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, LambdaFunctionAssociations> {
        /**
         * <p>
         * The number of Lambda function associations for this cache behavior.
         * </p>
         * 
         * @param quantity
         *        The number of Lambda function associations for this cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items for this cache
         * behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
         * </p>
         * 
         * @param items
         *        <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items for this
         *        cache behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<LambdaFunctionAssociation> items);

        /**
         * <p>
         * <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items for this cache
         * behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
         * </p>
         * 
         * @param items
         *        <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items for this
         *        cache behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(LambdaFunctionAssociation... items);
    }

    private static final class BuilderImpl implements Builder {
        private Integer quantity;

        private List<LambdaFunctionAssociation> items;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionAssociations model) {
            setQuantity(model.quantity);
            setItems(model.items);
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<LambdaFunctionAssociation> getItems() {
            return items;
        }

        @Override
        public final Builder items(Collection<LambdaFunctionAssociation> items) {
            this.items = LambdaFunctionAssociationListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(LambdaFunctionAssociation... items) {
            items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<LambdaFunctionAssociation> items) {
            this.items = LambdaFunctionAssociationListCopier.copy(items);
        }

        @Override
        public LambdaFunctionAssociations build() {
            return new LambdaFunctionAssociations(this);
        }
    }
}
