/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDistributionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetDistributionResponse.Builder, GetDistributionResponse> {
    private final Distribution distribution;

    private final String eTag;

    private GetDistributionResponse(BuilderImpl builder) {
        this.distribution = builder.distribution;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The distribution's information.
     * </p>
     * 
     * @return The distribution's information.
     */
    public Distribution distribution() {
        return distribution;
    }

    /**
     * <p>
     * The current version of the distribution's information. For example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The current version of the distribution's information. For example: <code>E2QWRUHAPOMQZL</code>.
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((distribution() == null) ? 0 : distribution().hashCode());
        hashCode = 31 * hashCode + ((eTag() == null) ? 0 : eTag().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDistributionResponse)) {
            return false;
        }
        GetDistributionResponse other = (GetDistributionResponse) obj;
        if (other.distribution() == null ^ this.distribution() == null) {
            return false;
        }
        if (other.distribution() != null && !other.distribution().equals(this.distribution())) {
            return false;
        }
        if (other.eTag() == null ^ this.eTag() == null) {
            return false;
        }
        if (other.eTag() != null && !other.eTag().equals(this.eTag())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (distribution() != null) {
            sb.append("Distribution: ").append(distribution()).append(",");
        }
        if (eTag() != null) {
            sb.append("ETag: ").append(eTag()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetDistributionResponse> {
        /**
         * <p>
         * The distribution's information.
         * </p>
         * 
         * @param distribution
         *        The distribution's information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distribution(Distribution distribution);

        /**
         * <p>
         * The current version of the distribution's information. For example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param eTag
         *        The current version of the distribution's information. For example: <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    private static final class BuilderImpl implements Builder {
        private Distribution distribution;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDistributionResponse model) {
            setDistribution(model.distribution);
            setETag(model.eTag);
        }

        public final Distribution getDistribution() {
            return distribution;
        }

        @Override
        public final Builder distribution(Distribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public final void setDistribution(Distribution distribution) {
            this.distribution = distribution;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public GetDistributionResponse build() {
            return new GetDistributionResponse(this);
        }
    }
}
