/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the information about a CloudFront distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DistributionSummary implements ToCopyableBuilder<DistributionSummary.Builder, DistributionSummary> {
    private final String id;

    private final String arn;

    private final String status;

    private final Instant lastModifiedTime;

    private final String domainName;

    private final Aliases aliases;

    private final Origins origins;

    private final DefaultCacheBehavior defaultCacheBehavior;

    private final CacheBehaviors cacheBehaviors;

    private final CustomErrorResponses customErrorResponses;

    private final String comment;

    private final String priceClass;

    private final Boolean enabled;

    private final ViewerCertificate viewerCertificate;

    private final Restrictions restrictions;

    private final String webACLId;

    private final String httpVersion;

    private final Boolean isIPV6Enabled;

    private DistributionSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.domainName = builder.domainName;
        this.aliases = builder.aliases;
        this.origins = builder.origins;
        this.defaultCacheBehavior = builder.defaultCacheBehavior;
        this.cacheBehaviors = builder.cacheBehaviors;
        this.customErrorResponses = builder.customErrorResponses;
        this.comment = builder.comment;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
        this.viewerCertificate = builder.viewerCertificate;
        this.restrictions = builder.restrictions;
        this.webACLId = builder.webACLId;
        this.httpVersion = builder.httpVersion;
        this.isIPV6Enabled = builder.isIPV6Enabled;
    }

    /**
     * <p>
     * The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
     * </p>
     * 
     * @return The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) for the distribution. For example:
     * <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where <code>123456789012</code> is
     * your AWS account ID.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) for the distribution. For example:
     *         <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
     *         <code>123456789012</code> is your AWS account ID.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The current status of the distribution. When the status is <code>Deployed</code>, the distribution's information
     * is propagated to all CloudFront edge locations.
     * </p>
     * 
     * @return The current status of the distribution. When the status is <code>Deployed</code>, the distribution's
     *         information is propagated to all CloudFront edge locations.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The date and time the distribution was last modified.
     * </p>
     * 
     * @return The date and time the distribution was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The domain name that corresponds to the distribution. For example: <code>d604721fxaaqy9.cloudfront.net</code>.
     * </p>
     * 
     * @return The domain name that corresponds to the distribution. For example:
     *         <code>d604721fxaaqy9.cloudfront.net</code>.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
     * </p>
     * 
     * @return A complex type that contains information about CNAMEs (alternate domain names), if any, for this
     *         distribution.
     */
    public Aliases aliases() {
        return aliases;
    }

    /**
     * <p>
     * A complex type that contains information about origins for this distribution.
     * </p>
     * 
     * @return A complex type that contains information about origins for this distribution.
     */
    public Origins origins() {
        return origins;
    }

    /**
     * <p>
     * A complex type that describes the default cache behavior if you do not specify a <code>CacheBehavior</code>
     * element or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code>
     * elements. You must create exactly one default cache behavior.
     * </p>
     * 
     * @return A complex type that describes the default cache behavior if you do not specify a
     *         <code>CacheBehavior</code> element or if files don't match any of the values of <code>PathPattern</code>
     *         in <code>CacheBehavior</code> elements. You must create exactly one default cache behavior.
     */
    public DefaultCacheBehavior defaultCacheBehavior() {
        return defaultCacheBehavior;
    }

    /**
     * <p>
     * A complex type that contains zero or more <code>CacheBehavior</code> elements.
     * </p>
     * 
     * @return A complex type that contains zero or more <code>CacheBehavior</code> elements.
     */
    public CacheBehaviors cacheBehaviors() {
        return cacheBehaviors;
    }

    /**
     * <p>
     * A complex type that contains zero or more <code>CustomErrorResponses</code> elements.
     * </p>
     * 
     * @return A complex type that contains zero or more <code>CustomErrorResponses</code> elements.
     */
    public CustomErrorResponses customErrorResponses() {
        return customErrorResponses;
    }

    /**
     * <p>
     * The comment originally specified when this distribution was created.
     * </p>
     * 
     * @return The comment originally specified when this distribution was created.
     */
    public String comment() {
        return comment;
    }

    /**
     * Returns the value of the PriceClass property for this object.
     * 
     * @return The value of the PriceClass property for this object.
     * @see PriceClass
     */
    public String priceClass() {
        return priceClass;
    }

    /**
     * <p>
     * Whether the distribution is enabled to accept user requests for content.
     * </p>
     * 
     * @return Whether the distribution is enabled to accept user requests for content.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * Returns the value of the ViewerCertificate property for this object.
     * 
     * @return The value of the ViewerCertificate property for this object.
     */
    public ViewerCertificate viewerCertificate() {
        return viewerCertificate;
    }

    /**
     * Returns the value of the Restrictions property for this object.
     * 
     * @return The value of the Restrictions property for this object.
     */
    public Restrictions restrictions() {
        return restrictions;
    }

    /**
     * <p>
     * The Web ACL Id (if any) associated with the distribution.
     * </p>
     * 
     * @return The Web ACL Id (if any) associated with the distribution.
     */
    public String webACLId() {
        return webACLId;
    }

    /**
     * <p>
     * Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default value
     * for new web distributions is <code>http2</code>. Viewers that don't support <code>HTTP/2</code> will
     * automatically use an earlier version.
     * </p>
     * 
     * @return Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default
     *         value for new web distributions is <code>http2</code>. Viewers that don't support <code>HTTP/2</code>
     *         will automatically use an earlier version.
     * @see HttpVersion
     */
    public String httpVersion() {
        return httpVersion;
    }

    /**
     * <p>
     * Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your distribution.
     * </p>
     * 
     * @return Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your distribution.
     */
    public Boolean isIPV6Enabled() {
        return isIPV6Enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((lastModifiedTime() == null) ? 0 : lastModifiedTime().hashCode());
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        hashCode = 31 * hashCode + ((aliases() == null) ? 0 : aliases().hashCode());
        hashCode = 31 * hashCode + ((origins() == null) ? 0 : origins().hashCode());
        hashCode = 31 * hashCode + ((defaultCacheBehavior() == null) ? 0 : defaultCacheBehavior().hashCode());
        hashCode = 31 * hashCode + ((cacheBehaviors() == null) ? 0 : cacheBehaviors().hashCode());
        hashCode = 31 * hashCode + ((customErrorResponses() == null) ? 0 : customErrorResponses().hashCode());
        hashCode = 31 * hashCode + ((comment() == null) ? 0 : comment().hashCode());
        hashCode = 31 * hashCode + ((priceClass() == null) ? 0 : priceClass().hashCode());
        hashCode = 31 * hashCode + ((enabled() == null) ? 0 : enabled().hashCode());
        hashCode = 31 * hashCode + ((viewerCertificate() == null) ? 0 : viewerCertificate().hashCode());
        hashCode = 31 * hashCode + ((restrictions() == null) ? 0 : restrictions().hashCode());
        hashCode = 31 * hashCode + ((webACLId() == null) ? 0 : webACLId().hashCode());
        hashCode = 31 * hashCode + ((httpVersion() == null) ? 0 : httpVersion().hashCode());
        hashCode = 31 * hashCode + ((isIPV6Enabled() == null) ? 0 : isIPV6Enabled().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionSummary)) {
            return false;
        }
        DistributionSummary other = (DistributionSummary) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.lastModifiedTime() == null ^ this.lastModifiedTime() == null) {
            return false;
        }
        if (other.lastModifiedTime() != null && !other.lastModifiedTime().equals(this.lastModifiedTime())) {
            return false;
        }
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.aliases() == null ^ this.aliases() == null) {
            return false;
        }
        if (other.aliases() != null && !other.aliases().equals(this.aliases())) {
            return false;
        }
        if (other.origins() == null ^ this.origins() == null) {
            return false;
        }
        if (other.origins() != null && !other.origins().equals(this.origins())) {
            return false;
        }
        if (other.defaultCacheBehavior() == null ^ this.defaultCacheBehavior() == null) {
            return false;
        }
        if (other.defaultCacheBehavior() != null && !other.defaultCacheBehavior().equals(this.defaultCacheBehavior())) {
            return false;
        }
        if (other.cacheBehaviors() == null ^ this.cacheBehaviors() == null) {
            return false;
        }
        if (other.cacheBehaviors() != null && !other.cacheBehaviors().equals(this.cacheBehaviors())) {
            return false;
        }
        if (other.customErrorResponses() == null ^ this.customErrorResponses() == null) {
            return false;
        }
        if (other.customErrorResponses() != null && !other.customErrorResponses().equals(this.customErrorResponses())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        if (other.priceClass() == null ^ this.priceClass() == null) {
            return false;
        }
        if (other.priceClass() != null && !other.priceClass().equals(this.priceClass())) {
            return false;
        }
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.viewerCertificate() == null ^ this.viewerCertificate() == null) {
            return false;
        }
        if (other.viewerCertificate() != null && !other.viewerCertificate().equals(this.viewerCertificate())) {
            return false;
        }
        if (other.restrictions() == null ^ this.restrictions() == null) {
            return false;
        }
        if (other.restrictions() != null && !other.restrictions().equals(this.restrictions())) {
            return false;
        }
        if (other.webACLId() == null ^ this.webACLId() == null) {
            return false;
        }
        if (other.webACLId() != null && !other.webACLId().equals(this.webACLId())) {
            return false;
        }
        if (other.httpVersion() == null ^ this.httpVersion() == null) {
            return false;
        }
        if (other.httpVersion() != null && !other.httpVersion().equals(this.httpVersion())) {
            return false;
        }
        if (other.isIPV6Enabled() == null ^ this.isIPV6Enabled() == null) {
            return false;
        }
        if (other.isIPV6Enabled() != null && !other.isIPV6Enabled().equals(this.isIPV6Enabled())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (arn() != null) {
            sb.append("ARN: ").append(arn()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (lastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(lastModifiedTime()).append(",");
        }
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (aliases() != null) {
            sb.append("Aliases: ").append(aliases()).append(",");
        }
        if (origins() != null) {
            sb.append("Origins: ").append(origins()).append(",");
        }
        if (defaultCacheBehavior() != null) {
            sb.append("DefaultCacheBehavior: ").append(defaultCacheBehavior()).append(",");
        }
        if (cacheBehaviors() != null) {
            sb.append("CacheBehaviors: ").append(cacheBehaviors()).append(",");
        }
        if (customErrorResponses() != null) {
            sb.append("CustomErrorResponses: ").append(customErrorResponses()).append(",");
        }
        if (comment() != null) {
            sb.append("Comment: ").append(comment()).append(",");
        }
        if (priceClass() != null) {
            sb.append("PriceClass: ").append(priceClass()).append(",");
        }
        if (enabled() != null) {
            sb.append("Enabled: ").append(enabled()).append(",");
        }
        if (viewerCertificate() != null) {
            sb.append("ViewerCertificate: ").append(viewerCertificate()).append(",");
        }
        if (restrictions() != null) {
            sb.append("Restrictions: ").append(restrictions()).append(",");
        }
        if (webACLId() != null) {
            sb.append("WebACLId: ").append(webACLId()).append(",");
        }
        if (httpVersion() != null) {
            sb.append("HttpVersion: ").append(httpVersion()).append(",");
        }
        if (isIPV6Enabled() != null) {
            sb.append("IsIPV6Enabled: ").append(isIPV6Enabled()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DistributionSummary> {
        /**
         * <p>
         * The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
         * </p>
         * 
         * @param id
         *        The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN (Amazon Resource Name) for the distribution. For example:
         * <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where <code>123456789012</code>
         * is your AWS account ID.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) for the distribution. For example:
         *        <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
         *        <code>123456789012</code> is your AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The current status of the distribution. When the status is <code>Deployed</code>, the distribution's
         * information is propagated to all CloudFront edge locations.
         * </p>
         * 
         * @param status
         *        The current status of the distribution. When the status is <code>Deployed</code>, the distribution's
         *        information is propagated to all CloudFront edge locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time the distribution was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time the distribution was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The domain name that corresponds to the distribution. For example: <code>d604721fxaaqy9.cloudfront.net</code>
         * .
         * </p>
         * 
         * @param domainName
         *        The domain name that corresponds to the distribution. For example:
         *        <code>d604721fxaaqy9.cloudfront.net</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         * distribution.
         * </p>
         * 
         * @param aliases
         *        A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         *        distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Aliases aliases);

        /**
         * <p>
         * A complex type that contains information about origins for this distribution.
         * </p>
         * 
         * @param origins
         *        A complex type that contains information about origins for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origins(Origins origins);

        /**
         * <p>
         * A complex type that describes the default cache behavior if you do not specify a <code>CacheBehavior</code>
         * element or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code>
         * elements. You must create exactly one default cache behavior.
         * </p>
         * 
         * @param defaultCacheBehavior
         *        A complex type that describes the default cache behavior if you do not specify a
         *        <code>CacheBehavior</code> element or if files don't match any of the values of
         *        <code>PathPattern</code> in <code>CacheBehavior</code> elements. You must create exactly one default
         *        cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCacheBehavior(DefaultCacheBehavior defaultCacheBehavior);

        /**
         * <p>
         * A complex type that contains zero or more <code>CacheBehavior</code> elements.
         * </p>
         * 
         * @param cacheBehaviors
         *        A complex type that contains zero or more <code>CacheBehavior</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheBehaviors(CacheBehaviors cacheBehaviors);

        /**
         * <p>
         * A complex type that contains zero or more <code>CustomErrorResponses</code> elements.
         * </p>
         * 
         * @param customErrorResponses
         *        A complex type that contains zero or more <code>CustomErrorResponses</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customErrorResponses(CustomErrorResponses customErrorResponses);

        /**
         * <p>
         * The comment originally specified when this distribution was created.
         * </p>
         * 
         * @param comment
         *        The comment originally specified when this distribution was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * Sets the value of the PriceClass property for this object.
         *
         * @param priceClass
         *        The new value for the PriceClass property for this object.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(String priceClass);

        /**
         * Sets the value of the PriceClass property for this object.
         *
         * @param priceClass
         *        The new value for the PriceClass property for this object.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(PriceClass priceClass);

        /**
         * <p>
         * Whether the distribution is enabled to accept user requests for content.
         * </p>
         * 
         * @param enabled
         *        Whether the distribution is enabled to accept user requests for content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * Sets the value of the ViewerCertificate property for this object.
         *
         * @param viewerCertificate
         *        The new value for the ViewerCertificate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewerCertificate(ViewerCertificate viewerCertificate);

        /**
         * Sets the value of the Restrictions property for this object.
         *
         * @param restrictions
         *        The new value for the Restrictions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictions(Restrictions restrictions);

        /**
         * <p>
         * The Web ACL Id (if any) associated with the distribution.
         * </p>
         * 
         * @param webACLId
         *        The Web ACL Id (if any) associated with the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLId(String webACLId);

        /**
         * <p>
         * Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default
         * value for new web distributions is <code>http2</code>. Viewers that don't support <code>HTTP/2</code> will
         * automatically use an earlier version.
         * </p>
         * 
         * @param httpVersion
         *        Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The
         *        default value for new web distributions is <code>http2</code>. Viewers that don't support
         *        <code>HTTP/2</code> will automatically use an earlier version.
         * @see HttpVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpVersion
         */
        Builder httpVersion(String httpVersion);

        /**
         * <p>
         * Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default
         * value for new web distributions is <code>http2</code>. Viewers that don't support <code>HTTP/2</code> will
         * automatically use an earlier version.
         * </p>
         * 
         * @param httpVersion
         *        Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The
         *        default value for new web distributions is <code>http2</code>. Viewers that don't support
         *        <code>HTTP/2</code> will automatically use an earlier version.
         * @see HttpVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpVersion
         */
        Builder httpVersion(HttpVersion httpVersion);

        /**
         * <p>
         * Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your distribution.
         * </p>
         * 
         * @param isIPV6Enabled
         *        Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isIPV6Enabled(Boolean isIPV6Enabled);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String status;

        private Instant lastModifiedTime;

        private String domainName;

        private Aliases aliases;

        private Origins origins;

        private DefaultCacheBehavior defaultCacheBehavior;

        private CacheBehaviors cacheBehaviors;

        private CustomErrorResponses customErrorResponses;

        private String comment;

        private String priceClass;

        private Boolean enabled;

        private ViewerCertificate viewerCertificate;

        private Restrictions restrictions;

        private String webACLId;

        private String httpVersion;

        private Boolean isIPV6Enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionSummary model) {
            setId(model.id);
            setARN(model.arn);
            setStatus(model.status);
            setLastModifiedTime(model.lastModifiedTime);
            setDomainName(model.domainName);
            setAliases(model.aliases);
            setOrigins(model.origins);
            setDefaultCacheBehavior(model.defaultCacheBehavior);
            setCacheBehaviors(model.cacheBehaviors);
            setCustomErrorResponses(model.customErrorResponses);
            setComment(model.comment);
            setPriceClass(model.priceClass);
            setEnabled(model.enabled);
            setViewerCertificate(model.viewerCertificate);
            setRestrictions(model.restrictions);
            setWebACLId(model.webACLId);
            setHttpVersion(model.httpVersion);
            setIsIPV6Enabled(model.isIPV6Enabled);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getARN() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Aliases getAliases() {
            return aliases;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final void setAliases(Aliases aliases) {
            this.aliases = aliases;
        }

        public final Origins getOrigins() {
            return origins;
        }

        @Override
        public final Builder origins(Origins origins) {
            this.origins = origins;
            return this;
        }

        public final void setOrigins(Origins origins) {
            this.origins = origins;
        }

        public final DefaultCacheBehavior getDefaultCacheBehavior() {
            return defaultCacheBehavior;
        }

        @Override
        public final Builder defaultCacheBehavior(DefaultCacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        public final void setDefaultCacheBehavior(DefaultCacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
        }

        public final CacheBehaviors getCacheBehaviors() {
            return cacheBehaviors;
        }

        @Override
        public final Builder cacheBehaviors(CacheBehaviors cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors;
            return this;
        }

        public final void setCacheBehaviors(CacheBehaviors cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors;
        }

        public final CustomErrorResponses getCustomErrorResponses() {
            return customErrorResponses;
        }

        @Override
        public final Builder customErrorResponses(CustomErrorResponses customErrorResponses) {
            this.customErrorResponses = customErrorResponses;
            return this;
        }

        public final void setCustomErrorResponses(CustomErrorResponses customErrorResponses) {
            this.customErrorResponses = customErrorResponses;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getPriceClass() {
            return priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass.toString());
            return this;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final ViewerCertificate getViewerCertificate() {
            return viewerCertificate;
        }

        @Override
        public final Builder viewerCertificate(ViewerCertificate viewerCertificate) {
            this.viewerCertificate = viewerCertificate;
            return this;
        }

        public final void setViewerCertificate(ViewerCertificate viewerCertificate) {
            this.viewerCertificate = viewerCertificate;
        }

        public final Restrictions getRestrictions() {
            return restrictions;
        }

        @Override
        public final Builder restrictions(Restrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public final void setRestrictions(Restrictions restrictions) {
            this.restrictions = restrictions;
        }

        public final String getWebACLId() {
            return webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        public final String getHttpVersion() {
            return httpVersion;
        }

        @Override
        public final Builder httpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        @Override
        public final Builder httpVersion(HttpVersion httpVersion) {
            this.httpVersion(httpVersion.toString());
            return this;
        }

        public final void setHttpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
        }

        public final Boolean getIsIPV6Enabled() {
            return isIPV6Enabled;
        }

        @Override
        public final Builder isIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
            return this;
        }

        public final void setIsIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
        }

        @Override
        public DistributionSummary build() {
            return new DistributionSummary(this);
        }
    }
}
