/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that controls:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning
 * the response to the viewer.
 * </p>
 * </li>
 * <li>
 * <p>
 * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information about custom error pages, see <a
 * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error
 * Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CustomErrorResponses implements ToCopyableBuilder<CustomErrorResponses.Builder, CustomErrorResponses> {
    private final Integer quantity;

    private final List<CustomErrorResponse> items;

    private CustomErrorResponses(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The number of HTTP status codes for which you want to specify a custom error page and/or a caching duration. If
     * <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
     * </p>
     * 
     * @return The number of HTTP status codes for which you want to specify a custom error page and/or a caching
     *         duration. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP status code for which you
     * want to specify a custom error page and/or a caching duration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP status code for
     *         which you want to specify a custom error page and/or a caching duration.
     */
    public List<CustomErrorResponse> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((quantity() == null) ? 0 : quantity().hashCode());
        hashCode = 31 * hashCode + ((items() == null) ? 0 : items().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomErrorResponses)) {
            return false;
        }
        CustomErrorResponses other = (CustomErrorResponses) obj;
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        if (other.items() != null && !other.items().equals(this.items())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (quantity() != null) {
            sb.append("Quantity: ").append(quantity()).append(",");
        }
        if (items() != null) {
            sb.append("Items: ").append(items()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CustomErrorResponses> {
        /**
         * <p>
         * The number of HTTP status codes for which you want to specify a custom error page and/or a caching duration.
         * If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
         * </p>
         * 
         * @param quantity
         *        The number of HTTP status codes for which you want to specify a custom error page and/or a caching
         *        duration. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP status code for which
         * you want to specify a custom error page and/or a caching duration.
         * </p>
         * 
         * @param items
         *        A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP status code for
         *        which you want to specify a custom error page and/or a caching duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<CustomErrorResponse> items);

        /**
         * <p>
         * A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP status code for which
         * you want to specify a custom error page and/or a caching duration.
         * </p>
         * 
         * @param items
         *        A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP status code for
         *        which you want to specify a custom error page and/or a caching duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(CustomErrorResponse... items);
    }

    private static final class BuilderImpl implements Builder {
        private Integer quantity;

        private List<CustomErrorResponse> items;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomErrorResponses model) {
            setQuantity(model.quantity);
            setItems(model.items);
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<CustomErrorResponse> getItems() {
            return items;
        }

        @Override
        public final Builder items(Collection<CustomErrorResponse> items) {
            this.items = CustomErrorResponseListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(CustomErrorResponse... items) {
            items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<CustomErrorResponse> items) {
            this.items = CustomErrorResponseListCopier.copy(items);
        }

        @Override
        public CustomErrorResponses build() {
            return new CustomErrorResponses(this);
        }
    }
}
