/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to create an invalidation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateInvalidationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateInvalidationRequest.Builder, CreateInvalidationRequest> {
    private final String distributionId;

    private final InvalidationBatch invalidationBatch;

    private CreateInvalidationRequest(BuilderImpl builder) {
        this.distributionId = builder.distributionId;
        this.invalidationBatch = builder.invalidationBatch;
    }

    /**
     * <p>
     * The distribution's id.
     * </p>
     * 
     * @return The distribution's id.
     */
    public String distributionId() {
        return distributionId;
    }

    /**
     * <p>
     * The batch information for the invalidation.
     * </p>
     * 
     * @return The batch information for the invalidation.
     */
    public InvalidationBatch invalidationBatch() {
        return invalidationBatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((distributionId() == null) ? 0 : distributionId().hashCode());
        hashCode = 31 * hashCode + ((invalidationBatch() == null) ? 0 : invalidationBatch().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInvalidationRequest)) {
            return false;
        }
        CreateInvalidationRequest other = (CreateInvalidationRequest) obj;
        if (other.distributionId() == null ^ this.distributionId() == null) {
            return false;
        }
        if (other.distributionId() != null && !other.distributionId().equals(this.distributionId())) {
            return false;
        }
        if (other.invalidationBatch() == null ^ this.invalidationBatch() == null) {
            return false;
        }
        if (other.invalidationBatch() != null && !other.invalidationBatch().equals(this.invalidationBatch())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (distributionId() != null) {
            sb.append("DistributionId: ").append(distributionId()).append(",");
        }
        if (invalidationBatch() != null) {
            sb.append("InvalidationBatch: ").append(invalidationBatch()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateInvalidationRequest> {
        /**
         * <p>
         * The distribution's id.
         * </p>
         * 
         * @param distributionId
         *        The distribution's id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionId(String distributionId);

        /**
         * <p>
         * The batch information for the invalidation.
         * </p>
         * 
         * @param invalidationBatch
         *        The batch information for the invalidation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidationBatch(InvalidationBatch invalidationBatch);
    }

    private static final class BuilderImpl implements Builder {
        private String distributionId;

        private InvalidationBatch invalidationBatch;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInvalidationRequest model) {
            setDistributionId(model.distributionId);
            setInvalidationBatch(model.invalidationBatch);
        }

        public final String getDistributionId() {
            return distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        public final InvalidationBatch getInvalidationBatch() {
            return invalidationBatch;
        }

        @Override
        public final Builder invalidationBatch(InvalidationBatch invalidationBatch) {
            this.invalidationBatch = invalidationBatch;
            return this;
        }

        public final void setInvalidationBatch(InvalidationBatch invalidationBatch) {
            this.invalidationBatch = invalidationBatch;
        }

        @Override
        public CreateInvalidationRequest build() {
            return new CreateInvalidationRequest(this);
        }
    }
}
