/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that lists the AWS accounts, if any, that you included in the <code>TrustedSigners</code> complex type
 * for this distribution. These are the accounts that you want to allow to create signed URLs for private content.
 * </p>
 * <p>
 * The <code>Signer</code> complex type lists the AWS account number of the trusted signer or <code>self</code> if the
 * signer is the AWS account that created the distribution. The <code>Signer</code> element also includes the IDs of any
 * active CloudFront key pairs that are associated with the trusted signer's AWS account. If no <code>KeyPairId</code>
 * element appears for a <code>Signer</code>, that signer can't create signed URLs.
 * </p>
 * <p>
 * For more information, see <a
 * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content
 * through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ActiveTrustedSigners implements ToCopyableBuilder<ActiveTrustedSigners.Builder, ActiveTrustedSigners> {
    private final Boolean enabled;

    private final Integer quantity;

    private final List<Signer> items;

    private ActiveTrustedSigners(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * Enabled is <code>true</code> if any of the AWS accounts listed in the <code>TrustedSigners</code> complex type
     * for this RTMP distribution have active CloudFront key pairs. If not, <code>Enabled</code> is <code>false</code>.
     * </p>
     * <p>
     * For more information, see <a>ActiveTrustedSigners</a>.
     * </p>
     * 
     * @return Enabled is <code>true</code> if any of the AWS accounts listed in the <code>TrustedSigners</code> complex
     *         type for this RTMP distribution have active CloudFront key pairs. If not, <code>Enabled</code> is
     *         <code>false</code>.</p>
     *         <p>
     *         For more information, see <a>ActiveTrustedSigners</a>.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * A complex type that contains one <code>Signer</code> complex type for each trusted signer specified in the
     * <code>TrustedSigners</code> complex type.
     * </p>
     * <p>
     * For more information, see <a>ActiveTrustedSigners</a>.
     * </p>
     * 
     * @return A complex type that contains one <code>Signer</code> complex type for each trusted signer specified in
     *         the <code>TrustedSigners</code> complex type.</p>
     *         <p>
     *         For more information, see <a>ActiveTrustedSigners</a>.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * A complex type that contains one <code>Signer</code> complex type for each trusted signer that is specified in
     * the <code>TrustedSigners</code> complex type.
     * </p>
     * <p>
     * For more information, see <a>ActiveTrustedSigners</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains one <code>Signer</code> complex type for each trusted signer that is
     *         specified in the <code>TrustedSigners</code> complex type.</p>
     *         <p>
     *         For more information, see <a>ActiveTrustedSigners</a>.
     */
    public List<Signer> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((enabled() == null) ? 0 : enabled().hashCode());
        hashCode = 31 * hashCode + ((quantity() == null) ? 0 : quantity().hashCode());
        hashCode = 31 * hashCode + ((items() == null) ? 0 : items().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveTrustedSigners)) {
            return false;
        }
        ActiveTrustedSigners other = (ActiveTrustedSigners) obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        if (other.items() != null && !other.items().equals(this.items())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (enabled() != null) {
            sb.append("Enabled: ").append(enabled()).append(",");
        }
        if (quantity() != null) {
            sb.append("Quantity: ").append(quantity()).append(",");
        }
        if (items() != null) {
            sb.append("Items: ").append(items()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ActiveTrustedSigners> {
        /**
         * <p>
         * Enabled is <code>true</code> if any of the AWS accounts listed in the <code>TrustedSigners</code> complex
         * type for this RTMP distribution have active CloudFront key pairs. If not, <code>Enabled</code> is
         * <code>false</code>.
         * </p>
         * <p>
         * For more information, see <a>ActiveTrustedSigners</a>.
         * </p>
         * 
         * @param enabled
         *        Enabled is <code>true</code> if any of the AWS accounts listed in the <code>TrustedSigners</code>
         *        complex type for this RTMP distribution have active CloudFront key pairs. If not, <code>Enabled</code>
         *        is <code>false</code>.</p>
         *        <p>
         *        For more information, see <a>ActiveTrustedSigners</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * A complex type that contains one <code>Signer</code> complex type for each trusted signer specified in the
         * <code>TrustedSigners</code> complex type.
         * </p>
         * <p>
         * For more information, see <a>ActiveTrustedSigners</a>.
         * </p>
         * 
         * @param quantity
         *        A complex type that contains one <code>Signer</code> complex type for each trusted signer specified in
         *        the <code>TrustedSigners</code> complex type.</p>
         *        <p>
         *        For more information, see <a>ActiveTrustedSigners</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * A complex type that contains one <code>Signer</code> complex type for each trusted signer that is specified
         * in the <code>TrustedSigners</code> complex type.
         * </p>
         * <p>
         * For more information, see <a>ActiveTrustedSigners</a>.
         * </p>
         * 
         * @param items
         *        A complex type that contains one <code>Signer</code> complex type for each trusted signer that is
         *        specified in the <code>TrustedSigners</code> complex type.</p>
         *        <p>
         *        For more information, see <a>ActiveTrustedSigners</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<Signer> items);

        /**
         * <p>
         * A complex type that contains one <code>Signer</code> complex type for each trusted signer that is specified
         * in the <code>TrustedSigners</code> complex type.
         * </p>
         * <p>
         * For more information, see <a>ActiveTrustedSigners</a>.
         * </p>
         * 
         * @param items
         *        A complex type that contains one <code>Signer</code> complex type for each trusted signer that is
         *        specified in the <code>TrustedSigners</code> complex type.</p>
         *        <p>
         *        For more information, see <a>ActiveTrustedSigners</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Signer... items);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Integer quantity;

        private List<Signer> items;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveTrustedSigners model) {
            setEnabled(model.enabled);
            setQuantity(model.quantity);
            setItems(model.items);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<Signer> getItems() {
            return items;
        }

        @Override
        public final Builder items(Collection<Signer> items) {
            this.items = SignerListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Signer... items) {
            items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<Signer> items) {
            this.items = SignerListCopier.copy(items);
        }

        @Override
        public ActiveTrustedSigners build() {
            return new ActiveTrustedSigners(this);
        }
    }
}
