/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebACLIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebACLIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Service client for accessing CloudFront asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Amazon CloudFront</fullname>
 * <p>
 * This is the <i>Amazon CloudFront API Reference</i>. This guide is for developers who need detailed information about
 * the CloudFront API actions, data types, and errors. For detailed information about CloudFront features and their
 * associated API calls, see the <i>Amazon CloudFront Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface CloudFrontAsyncClient extends SdkAutoCloseable {
    /**
     * Create a {@link CloudFrontAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.DefaultCredentialsProvider}.
     */
    static CloudFrontAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudFrontAsyncClient}.
     */
    static CloudFrontAsyncClientBuilder builder() {
        return new DefaultCloudFrontAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates a new origin access identity. If you're using Amazon S3 for your origin, you can use an origin access
     * identity to require users to access your content using a CloudFront URL instead of the Amazon S3 URL. For more
     * information about how to use origin access identities, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createCloudFrontOriginAccessIdentityRequest
     *        The request to create a new origin access identity.
     * @return A Java Future containing the result of the CreateCloudFrontOriginAccessIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CloudFrontOriginAccessIdentityAlreadyExistsException If the <code>CallerReference</code> is a value
     *         you already sent in a previous request to create an identity but the content of the
     *         <code>CloudFrontOriginAccessIdentityConfig</code> is different from the original request, CloudFront
     *         returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         Content-Type header is set.</li>
     *         <li>TooManyCloudFrontOriginAccessIdentitiesException Processing your request would cause you to exceed
     *         the maximum number of origin access identities allowed.</li>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         do not match.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateCloudFrontOriginAccessIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/CreateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudFrontOriginAccessIdentityResponse> createCloudFrontOriginAccessIdentity(
            CreateCloudFrontOriginAccessIdentityRequest createCloudFrontOriginAccessIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new web distribution. Send a <code>POST</code> request to the
     * <code>/<i>CloudFront API version</i>/distribution</code>/<code>distribution ID</code> resource.
     * </p>
     *
     * @param createDistributionRequest
     *        The request to create a new distribution.
     * @return A Java Future containing the result of the CreateDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CNAMEAlreadyExistsException</li>
     *         <li>DistributionAlreadyExistsException The caller reference you attempted to create the distribution with
     *         is associated with another distribution.</li>
     *         <li>InvalidOriginException The Amazon S3 origin server specified does not refer to a valid Amazon S3
     *         bucket.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers do not exist.</li>
     *         <li>InvalidViewerCertificateException</li>
     *         <li>InvalidMinimumProtocolVersionException</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         Content-Type header is set.</li>
     *         <li>TooManyDistributionCNAMEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>TooManyDistributionsException Processing your request would cause you to exceed the maximum number of
     *         distributions allowed.</li>
     *         <li>InvalidDefaultRootObjectException The default root object file name is too big or contains an invalid
     *         character.</li>
     *         <li>InvalidRelativePathException The relative path is too big, is not URL-encoded, or does not begin with
     *         a slash (/).</li>
     *         <li>InvalidErrorCodeException</li>
     *         <li>InvalidResponseCodeException</li>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>InvalidRequiredProtocolException This operation requires the HTTPS protocol. Ensure that you specify
     *         the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your
     *         distribution configuration.</li>
     *         <li>NoSuchOriginException No origin exists with the specified <code>Origin Id</code>.</li>
     *         <li>TooManyOriginsException You cannot create more origins for the distribution.</li>
     *         <li>TooManyCacheBehaviorsException You cannot create more cache behaviors for the distribution.</li>
     *         <li>TooManyCookieNamesInWhiteListException Your request contains more cookie names in the whitelist than
     *         are allowed per cache behavior.</li>
     *         <li>InvalidForwardCookiesException Your request contains forward cookies option which doesn't match with
     *         the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has
     *         been specified when not allowed or list of cookie names is missing when expected.</li>
     *         <li>TooManyHeadersInForwardedValuesException</li>
     *         <li>InvalidHeadersForS3OriginException</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         do not match.</li>
     *         <li>TooManyCertificatesException You cannot create anymore custom SSL/TLS certificates.</li>
     *         <li>InvalidLocationCodeException</li>
     *         <li>InvalidGeoRestrictionParameterException</li>
     *         <li>InvalidProtocolSettingsException You cannot specify SSLv3 as the minimum protocol version if you only
     *         want to support only clients that support Server Name Indication (SNI).</li>
     *         <li>InvalidTTLOrderException</li>
     *         <li>InvalidWebACLIdException</li>
     *         <li>TooManyOriginCustomHeadersException</li>
     *         <li>TooManyQueryStringParametersException</li>
     *         <li>InvalidQueryStringParametersException</li>
     *         <li>TooManyDistributionsWithLambdaAssociationsException Processing your request would cause the maximum
     *         number of distributions with Lambda function associations per owner to be exceeded.</li>
     *         <li>TooManyLambdaFunctionAssociationsException Your request contains more Lambda function associations
     *         than are allowed per distribution.</li>
     *         <li>InvalidLambdaFunctionAssociationException The specified Lambda function association is invalid.</li>
     *         <li>InvalidOriginReadTimeoutException</li>
     *         <li>InvalidOriginKeepaliveTimeoutException</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/CreateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDistributionResponse> createDistribution(CreateDistributionRequest createDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new distribution with tags.
     * </p>
     *
     * @param createDistributionWithTagsRequest
     *        The request to create a new distribution with tags.
     * @return A Java Future containing the result of the CreateDistributionWithTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CNAMEAlreadyExistsException</li>
     *         <li>DistributionAlreadyExistsException The caller reference you attempted to create the distribution with
     *         is associated with another distribution.</li>
     *         <li>InvalidOriginException The Amazon S3 origin server specified does not refer to a valid Amazon S3
     *         bucket.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers do not exist.</li>
     *         <li>InvalidViewerCertificateException</li>
     *         <li>InvalidMinimumProtocolVersionException</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         Content-Type header is set.</li>
     *         <li>TooManyDistributionCNAMEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>TooManyDistributionsException Processing your request would cause you to exceed the maximum number of
     *         distributions allowed.</li>
     *         <li>InvalidDefaultRootObjectException The default root object file name is too big or contains an invalid
     *         character.</li>
     *         <li>InvalidRelativePathException The relative path is too big, is not URL-encoded, or does not begin with
     *         a slash (/).</li>
     *         <li>InvalidErrorCodeException</li>
     *         <li>InvalidResponseCodeException</li>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>InvalidRequiredProtocolException This operation requires the HTTPS protocol. Ensure that you specify
     *         the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your
     *         distribution configuration.</li>
     *         <li>NoSuchOriginException No origin exists with the specified <code>Origin Id</code>.</li>
     *         <li>TooManyOriginsException You cannot create more origins for the distribution.</li>
     *         <li>TooManyCacheBehaviorsException You cannot create more cache behaviors for the distribution.</li>
     *         <li>TooManyCookieNamesInWhiteListException Your request contains more cookie names in the whitelist than
     *         are allowed per cache behavior.</li>
     *         <li>InvalidForwardCookiesException Your request contains forward cookies option which doesn't match with
     *         the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has
     *         been specified when not allowed or list of cookie names is missing when expected.</li>
     *         <li>TooManyHeadersInForwardedValuesException</li>
     *         <li>InvalidHeadersForS3OriginException</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         do not match.</li>
     *         <li>TooManyCertificatesException You cannot create anymore custom SSL/TLS certificates.</li>
     *         <li>InvalidLocationCodeException</li>
     *         <li>InvalidGeoRestrictionParameterException</li>
     *         <li>InvalidProtocolSettingsException You cannot specify SSLv3 as the minimum protocol version if you only
     *         want to support only clients that support Server Name Indication (SNI).</li>
     *         <li>InvalidTTLOrderException</li>
     *         <li>InvalidWebACLIdException</li>
     *         <li>TooManyOriginCustomHeadersException</li>
     *         <li>InvalidTaggingException</li>
     *         <li>TooManyQueryStringParametersException</li>
     *         <li>InvalidQueryStringParametersException</li>
     *         <li>TooManyDistributionsWithLambdaAssociationsException Processing your request would cause the maximum
     *         number of distributions with Lambda function associations per owner to be exceeded.</li>
     *         <li>TooManyLambdaFunctionAssociationsException Your request contains more Lambda function associations
     *         than are allowed per distribution.</li>
     *         <li>InvalidLambdaFunctionAssociationException The specified Lambda function association is invalid.</li>
     *         <li>InvalidOriginReadTimeoutException</li>
     *         <li>InvalidOriginKeepaliveTimeoutException</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateDistributionWithTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/CreateDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDistributionWithTagsResponse> createDistributionWithTags(
            CreateDistributionWithTagsRequest createDistributionWithTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new invalidation.
     * </p>
     *
     * @param createInvalidationRequest
     *        The request to create an invalidation.
     * @return A Java Future containing the result of the CreateInvalidation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         Content-Type header is set.</li>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>BatchTooLargeException</li>
     *         <li>TooManyInvalidationsInProgressException You have exceeded the maximum number of allowable InProgress
     *         invalidation batch requests, or invalidation objects.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         do not match.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateInvalidation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/CreateInvalidation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateInvalidationResponse> createInvalidation(CreateInvalidationRequest createInvalidationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new RMTP distribution. An RTMP distribution is similar to a web distribution, but an RTMP distribution
     * streams media files using the Adobe Real-Time Messaging Protocol (RTMP) instead of serving files using HTTP.
     * </p>
     * <p>
     * To create a new web distribution, submit a <code>POST</code> request to the <i>CloudFront API
     * version</i>/distribution resource. The request body must include a document with a
     * <i>StreamingDistributionConfig</i> element. The response echoes the <code>StreamingDistributionConfig</code>
     * element and returns other information about the RTMP distribution.
     * </p>
     * <p>
     * To get the status of your request, use the <i>GET StreamingDistribution</i> API action. When the value of
     * <code>Enabled</code> is <code>true</code> and the value of <code>Status</code> is <code>Deployed</code>, your
     * distribution is ready. A distribution usually deploys in less than 15 minutes.
     * </p>
     * <p>
     * For more information about web distributions, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-rtmp.html">Working with RTMP
     * Distributions</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <important>
     * <p>
     * Beginning with the 2012-05-05 version of the CloudFront API, we made substantial changes to the format of the XML
     * document that you include in the request body when you create or update a web distribution or an RTMP
     * distribution, and when you invalidate objects. With previous versions of the API, we discovered that it was too
     * easy to accidentally delete one or more values for an element that accepts multiple values, for example, CNAMEs
     * and trusted signers. Our changes for the 2012-05-05 release are intended to prevent these accidental deletions
     * and to notify you when there's a mismatch between the number of values you say you're specifying in the
     * <code>Quantity</code> element and the number of values specified.
     * </p>
     * </important>
     *
     * @param createStreamingDistributionRequest
     *        The request to create a new streaming distribution.
     * @return A Java Future containing the result of the CreateStreamingDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CNAMEAlreadyExistsException</li>
     *         <li>StreamingDistributionAlreadyExistsException</li>
     *         <li>InvalidOriginException The Amazon S3 origin server specified does not refer to a valid Amazon S3
     *         bucket.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers do not exist.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         Content-Type header is set.</li>
     *         <li>TooManyStreamingDistributionCNAMEsException</li>
     *         <li>TooManyStreamingDistributionsException Processing your request would cause you to exceed the maximum
     *         number of streaming distributions allowed.</li>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         do not match.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateStreamingDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/CreateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStreamingDistributionResponse> createStreamingDistribution(
            CreateStreamingDistributionRequest createStreamingDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new streaming distribution with tags.
     * </p>
     *
     * @param createStreamingDistributionWithTagsRequest
     *        The request to create a new streaming distribution with tags.
     * @return A Java Future containing the result of the CreateStreamingDistributionWithTags operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CNAMEAlreadyExistsException</li>
     *         <li>StreamingDistributionAlreadyExistsException</li>
     *         <li>InvalidOriginException The Amazon S3 origin server specified does not refer to a valid Amazon S3
     *         bucket.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers do not exist.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         Content-Type header is set.</li>
     *         <li>TooManyStreamingDistributionCNAMEsException</li>
     *         <li>TooManyStreamingDistributionsException Processing your request would cause you to exceed the maximum
     *         number of streaming distributions allowed.</li>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         do not match.</li>
     *         <li>InvalidTaggingException</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateStreamingDistributionWithTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/CreateStreamingDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStreamingDistributionWithTagsResponse> createStreamingDistributionWithTags(
            CreateStreamingDistributionWithTagsRequest createStreamingDistributionWithTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an origin access identity.
     * </p>
     *
     * @param deleteCloudFrontOriginAccessIdentityRequest
     *        Deletes a origin access identity.
     * @return A Java Future containing the result of the DeleteCloudFrontOriginAccessIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid for the
     *         distribution.</li>
     *         <li>NoSuchCloudFrontOriginAccessIdentityException The specified origin access identity does not exist.</li>
     *         <li>PreconditionFailedException The precondition given in one or more of the request-header fields
     *         evaluated to <code>false</code>.</li>
     *         <li>CloudFrontOriginAccessIdentityInUseException</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteCloudFrontOriginAccessIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/DeleteCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCloudFrontOriginAccessIdentityResponse> deleteCloudFrontOriginAccessIdentity(
            DeleteCloudFrontOriginAccessIdentityRequest deleteCloudFrontOriginAccessIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a distribution.
     * </p>
     *
     * @param deleteDistributionRequest
     *        This action deletes a web distribution. To delete a web distribution using the CloudFront API, perform the
     *        following steps.</p>
     *        <p>
     *        <b>To delete a web distribution using the CloudFront API:</b>
     *        </p>
     *        <ol>
     *        <li>
     *        <p>
     *        Disable the web distribution
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution Config</code> request to get the current configuration and the
     *        <code>Etag</code> header for the distribution.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Update the XML document that was returned in the response to your <code>GET Distribution Config</code>
     *        request to change the value of <code>Enabled</code> to <code>false</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>PUT Distribution Config</code> request to update the configuration for your distribution.
     *        In the request body, include the XML document that you updated in Step 3. Set the value of the HTTP
     *        <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when
     *        you submitted the <code>GET Distribution Config</code> request in Step 2.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to the <code>PUT Distribution Config</code> request to confirm that the distribution
     *        was successfully disabled.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution</code> request to confirm that your changes have propagated. When
     *        propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>DELETE Distribution</code> request. Set the value of the HTTP <code>If-Match</code> header
     *        to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     *        <code>GET Distribution Config</code> request in Step 6.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to your <code>DELETE Distribution</code> request to confirm that the distribution was
     *        successfully deleted.
     *        </p>
     *        </li>
     *        </ol>
     *        <p>
     *        For information about deleting a distribution using the CloudFront console, see <a
     *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html"
     *        >Deleting a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * @return A Java Future containing the result of the DeleteDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li> <li>DistributionNotDisabledException </li> <li>
     *         InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid for the
     *         distribution.</li> <li>NoSuchDistributionException The specified distribution does not exist.</li> <li>
     *         PreconditionFailedException The precondition given in one or more of the request-header fields evaluated
     *         to <code>false</code>.</li> <li>SdkBaseException Base class for all exceptions that can be thrown by the
     *         SDK (both service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If any
     *         client side error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>
     *         CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/DeleteDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDistributionResponse> deleteDistribution(DeleteDistributionRequest deleteDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API, perform the following
     * steps.
     * </p>
     * <p>
     * <b>To delete an RTMP distribution using the CloudFront API</b>:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Disable the RTMP distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to get the current configuration and the
     * <code>Etag</code> header for the distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the XML document that was returned in the response to your <code>GET Streaming Distribution Config</code>
     * request to change the value of <code>Enabled</code> to <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>PUT Streaming Distribution Config</code> request to update the configuration for your
     * distribution. In the request body, include the XML document that you updated in Step 3. Then set the value of the
     * HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you
     * submitted the <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to the <code>PUT Streaming Distribution Config</code> request to confirm that the
     * distribution was successfully disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to confirm that your changes have propagated.
     * When propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>DELETE Streaming Distribution</code> request. Set the value of the HTTP <code>If-Match</code>
     * header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     * <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to your <code>DELETE Streaming Distribution</code> request to confirm that the distribution
     * was successfully deleted.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For information about deleting a distribution using the CloudFront console, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a
     * Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param deleteStreamingDistributionRequest
     *        The request to delete a streaming distribution.
     * @return A Java Future containing the result of the DeleteStreamingDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>StreamingDistributionNotDisabledException</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid for the
     *         distribution.</li>
     *         <li>NoSuchStreamingDistributionException The specified streaming distribution does not exist.</li>
     *         <li>PreconditionFailedException The precondition given in one or more of the request-header fields
     *         evaluated to <code>false</code>.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteStreamingDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/DeleteStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStreamingDistributionResponse> deleteStreamingDistribution(
            DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the information about an origin access identity.
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityRequest
     *        The request to get an origin access identity's information.
     * @return A Java Future containing the result of the GetCloudFrontOriginAccessIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCloudFrontOriginAccessIdentityException The specified origin access identity does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetCloudFrontOriginAccessIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/GetCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudFrontOriginAccessIdentityResponse> getCloudFrontOriginAccessIdentity(
            GetCloudFrontOriginAccessIdentityRequest getCloudFrontOriginAccessIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the configuration information about an origin access identity.
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityConfigRequest
     *        The origin access identity's configuration information. For more information, see
     *        <a>CloudFrontOriginAccessIdentityConfigComplexType</a>.
     * @return A Java Future containing the result of the GetCloudFrontOriginAccessIdentityConfig operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCloudFrontOriginAccessIdentityException The specified origin access identity does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetCloudFrontOriginAccessIdentityConfig
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/GetCloudFrontOriginAccessIdentityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudFrontOriginAccessIdentityConfigResponse> getCloudFrontOriginAccessIdentityConfig(
            GetCloudFrontOriginAccessIdentityConfigRequest getCloudFrontOriginAccessIdentityConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the information about a distribution.
     * </p>
     *
     * @param getDistributionRequest
     *        The request to get a distribution's information.
     * @return A Java Future containing the result of the GetDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/GetDistribution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDistributionResponse> getDistribution(GetDistributionRequest getDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the configuration information about a distribution.
     * </p>
     *
     * @param getDistributionConfigRequest
     *        The request to get a distribution configuration.
     * @return A Java Future containing the result of the GetDistributionConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetDistributionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/GetDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDistributionConfigResponse> getDistributionConfig(
            GetDistributionConfigRequest getDistributionConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the information about an invalidation.
     * </p>
     *
     * @param getInvalidationRequest
     *        The request to get an invalidation's information.
     * @return A Java Future containing the result of the GetInvalidation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchInvalidationException The specified invalidation does not exist.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetInvalidation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/GetInvalidation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInvalidationResponse> getInvalidation(GetInvalidationRequest getInvalidationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified RTMP distribution, including the distribution configuration.
     * </p>
     *
     * @param getStreamingDistributionRequest
     *        The request to get a streaming distribution's information.
     * @return A Java Future containing the result of the GetStreamingDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchStreamingDistributionException The specified streaming distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetStreamingDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/GetStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStreamingDistributionResponse> getStreamingDistribution(
            GetStreamingDistributionRequest getStreamingDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the configuration information about a streaming distribution.
     * </p>
     *
     * @param getStreamingDistributionConfigRequest
     *        To request to get a streaming distribution configuration.
     * @return A Java Future containing the result of the GetStreamingDistributionConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchStreamingDistributionException The specified streaming distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetStreamingDistributionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/GetStreamingDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStreamingDistributionConfigResponse> getStreamingDistributionConfig(
            GetStreamingDistributionConfigRequest getStreamingDistributionConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists origin access identities.
     * </p>
     *
     * @param listCloudFrontOriginAccessIdentitiesRequest
     *        The request to list origin access identities.
     * @return A Java Future containing the result of the ListCloudFrontOriginAccessIdentities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListCloudFrontOriginAccessIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/ListCloudFrontOriginAccessIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCloudFrontOriginAccessIdentitiesResponse> listCloudFrontOriginAccessIdentities(
            ListCloudFrontOriginAccessIdentitiesRequest listCloudFrontOriginAccessIdentitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List distributions.
     * </p>
     *
     * @param listDistributionsRequest
     *        The request to list your distributions.
     * @return A Java Future containing the result of the ListDistributions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/ListDistributions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDistributionsResponse> listDistributions(ListDistributionsRequest listDistributionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the distributions that are associated with a specified AWS WAF web ACL.
     * </p>
     *
     * @param listDistributionsByWebACLIdRequest
     *        The request to list distributions that are associated with a specified AWS WAF web ACL.
     * @return A Java Future containing the result of the ListDistributionsByWebACLId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>InvalidWebACLIdException</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributionsByWebACLId
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/ListDistributionsByWebACLId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDistributionsByWebACLIdResponse> listDistributionsByWebACLId(
            ListDistributionsByWebACLIdRequest listDistributionsByWebACLIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists invalidation batches.
     * </p>
     *
     * @param listInvalidationsRequest
     *        The request to list invalidations.
     * @return A Java Future containing the result of the ListInvalidations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListInvalidations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/ListInvalidations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInvalidationsResponse> listInvalidations(ListInvalidationsRequest listInvalidationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List streaming distributions.
     * </p>
     *
     * @param listStreamingDistributionsRequest
     *        The request to list your streaming distributions.
     * @return A Java Future containing the result of the ListStreamingDistributions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListStreamingDistributions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/ListStreamingDistributions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStreamingDistributionsResponse> listStreamingDistributions(
            ListStreamingDistributionsRequest listStreamingDistributionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tags for a CloudFront resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The request to list tags for a CloudFront resource.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>InvalidTaggingException</li>
     *         <li>NoSuchResourceException</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add tags to a CloudFront resource.
     * </p>
     *
     * @param tagResourceRequest
     *        The request to add tags to a CloudFront resource.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>InvalidTaggingException</li>
     *         <li>NoSuchResourceException</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove tags from a CloudFront resource.
     * </p>
     *
     * @param untagResourceRequest
     *        The request to remove tags from a CloudFront resource.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>InvalidTaggingException</li>
     *         <li>NoSuchResourceException</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an origin access identity.
     * </p>
     *
     * @param updateCloudFrontOriginAccessIdentityRequest
     *        The request to update an origin access identity.
     * @return A Java Future containing the result of the UpdateCloudFrontOriginAccessIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>IllegalUpdateException Origin and <code>CallerReference</code> cannot be updated.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid for the
     *         distribution.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         Content-Type header is set.</li>
     *         <li>NoSuchCloudFrontOriginAccessIdentityException The specified origin access identity does not exist.</li>
     *         <li>PreconditionFailedException The precondition given in one or more of the request-header fields
     *         evaluated to <code>false</code>.</li>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         do not match.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateCloudFrontOriginAccessIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/UpdateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCloudFrontOriginAccessIdentityResponse> updateCloudFrontOriginAccessIdentity(
            UpdateCloudFrontOriginAccessIdentityRequest updateCloudFrontOriginAccessIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration for a web distribution. Perform the following steps.
     * </p>
     * <p>
     * For information about updating a distribution using the CloudFront console, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-creating-console.html"
     * >Creating or Updating a Web Distribution Using the CloudFront Console </a> in the <i>Amazon CloudFront Developer
     * Guide</i>.
     * </p>
     * <p>
     * <b>To update a web distribution using the CloudFront API</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Submit a <a>GetDistributionConfig</a> request to get the current configuration and an <code>Etag</code> header
     * for the distribution.
     * </p>
     * <note>
     * <p>
     * If you update the distribution again, you need to get a new <code>Etag</code> header.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * Update the XML document that was returned in the response to your <code>GetDistributionConfig</code> request to
     * include the desired changes. You can't change the value of <code>CallerReference</code>. If you try to change
     * this value, CloudFront returns an <code>IllegalUpdate</code> error.
     * </p>
     * <important>
     * <p>
     * The new configuration replaces the existing configuration; the values that you specify in an
     * <code>UpdateDistribution</code> request are not merged into the existing configuration. When you add, delete, or
     * replace values in an element that allows multiple values (for example, <code>CNAME</code>), you must specify all
     * of the values that you want to appear in the updated distribution. In addition, you must update the corresponding
     * <code>Quantity</code> element.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * Submit an <code>UpdateDistribution</code> request to update the configuration for your distribution:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In the request body, include the XML document that you updated in Step 2. The request body must include an XML
     * document with a <code>DistributionConfig</code> element.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set the value of the HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that
     * CloudFront returned when you submitted the <code>GetDistributionConfig</code> request in Step 1.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Review the response to the <code>UpdateDistribution</code> request to confirm that the configuration was
     * successfully updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: Submit a <a>GetDistribution</a> request to confirm that your changes have propagated. When propagation
     * is complete, the value of <code>Status</code> is <code>Deployed</code>.
     * </p>
     * <important>
     * <p>
     * Beginning with the 2012-05-05 version of the CloudFront API, we made substantial changes to the format of the XML
     * document that you include in the request body when you create or update a distribution. With previous versions of
     * the API, we discovered that it was too easy to accidentally delete one or more values for an element that accepts
     * multiple values, for example, CNAMEs and trusted signers. Our changes for the 2012-05-05 release are intended to
     * prevent these accidental deletions and to notify you when there's a mismatch between the number of values you say
     * you're specifying in the <code>Quantity</code> element and the number of values you're actually specifying.
     * </p>
     * </important></li>
     * </ol>
     *
     * @param updateDistributionRequest
     *        The request to update a distribution.
     * @return A Java Future containing the result of the UpdateDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>CNAMEAlreadyExistsException</li>
     *         <li>IllegalUpdateException Origin and <code>CallerReference</code> cannot be updated.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid for the
     *         distribution.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         Content-Type header is set.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>PreconditionFailedException The precondition given in one or more of the request-header fields
     *         evaluated to <code>false</code>.</li>
     *         <li>TooManyDistributionCNAMEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>InvalidDefaultRootObjectException The default root object file name is too big or contains an invalid
     *         character.</li>
     *         <li>InvalidRelativePathException The relative path is too big, is not URL-encoded, or does not begin with
     *         a slash (/).</li>
     *         <li>InvalidErrorCodeException</li>
     *         <li>InvalidResponseCodeException</li>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers do not exist.</li>
     *         <li>InvalidViewerCertificateException</li>
     *         <li>InvalidMinimumProtocolVersionException</li>
     *         <li>InvalidRequiredProtocolException This operation requires the HTTPS protocol. Ensure that you specify
     *         the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your
     *         distribution configuration.</li>
     *         <li>NoSuchOriginException No origin exists with the specified <code>Origin Id</code>.</li>
     *         <li>TooManyOriginsException You cannot create more origins for the distribution.</li>
     *         <li>TooManyCacheBehaviorsException You cannot create more cache behaviors for the distribution.</li>
     *         <li>TooManyCookieNamesInWhiteListException Your request contains more cookie names in the whitelist than
     *         are allowed per cache behavior.</li>
     *         <li>InvalidForwardCookiesException Your request contains forward cookies option which doesn't match with
     *         the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has
     *         been specified when not allowed or list of cookie names is missing when expected.</li>
     *         <li>TooManyHeadersInForwardedValuesException</li>
     *         <li>InvalidHeadersForS3OriginException</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         do not match.</li>
     *         <li>TooManyCertificatesException You cannot create anymore custom SSL/TLS certificates.</li>
     *         <li>InvalidLocationCodeException</li>
     *         <li>InvalidGeoRestrictionParameterException</li>
     *         <li>InvalidTTLOrderException</li>
     *         <li>InvalidWebACLIdException</li>
     *         <li>TooManyOriginCustomHeadersException</li>
     *         <li>TooManyQueryStringParametersException</li>
     *         <li>InvalidQueryStringParametersException</li>
     *         <li>TooManyDistributionsWithLambdaAssociationsException Processing your request would cause the maximum
     *         number of distributions with Lambda function associations per owner to be exceeded.</li>
     *         <li>TooManyLambdaFunctionAssociationsException Your request contains more Lambda function associations
     *         than are allowed per distribution.</li>
     *         <li>InvalidLambdaFunctionAssociationException The specified Lambda function association is invalid.</li>
     *         <li>InvalidOriginReadTimeoutException</li>
     *         <li>InvalidOriginKeepaliveTimeoutException</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/UpdateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDistributionResponse> updateDistribution(UpdateDistributionRequest updateDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a streaming distribution.
     * </p>
     *
     * @param updateStreamingDistributionRequest
     *        The request to update a streaming distribution.
     * @return A Java Future containing the result of the UpdateStreamingDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>CNAMEAlreadyExistsException</li>
     *         <li>IllegalUpdateException Origin and <code>CallerReference</code> cannot be updated.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid for the
     *         distribution.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         Content-Type header is set.</li>
     *         <li>NoSuchStreamingDistributionException The specified streaming distribution does not exist.</li>
     *         <li>PreconditionFailedException The precondition given in one or more of the request-header fields
     *         evaluated to <code>false</code>.</li>
     *         <li>TooManyStreamingDistributionCNAMEsException</li>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers do not exist.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         do not match.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateStreamingDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/UpdateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateStreamingDistributionResponse> updateStreamingDistribution(
            UpdateStreamingDistributionRequest updateStreamingDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists origin access identities.
     * </p>
     *
     * @return A Java Future containing the result of the ListCloudFrontOriginAccessIdentities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListCloudFrontOriginAccessIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/ListCloudFrontOriginAccessIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCloudFrontOriginAccessIdentitiesResponse> listCloudFrontOriginAccessIdentities() {
        return listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest.builder().build());
    }

    /**
     * <p>
     * List distributions.
     * </p>
     *
     * @return A Java Future containing the result of the ListDistributions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/ListDistributions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDistributionsResponse> listDistributions() {
        return listDistributions(ListDistributionsRequest.builder().build());
    }

    /**
     * <p>
     * List streaming distributions.
     * </p>
     *
     * @return A Java Future containing the result of the ListStreamingDistributions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException The argument is invalid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListStreamingDistributions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2017-03-25/ListStreamingDistributions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStreamingDistributionsResponse> listStreamingDistributions() {
        return listStreamingDistributions(ListStreamingDistributionsRequest.builder().build());
    }
}
