/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.Signer;
import software.amazon.awssdk.services.cloudfront.transform.KeyPairIdsUnmarshaller;

public class SignerUnmarshaller
implements Unmarshaller<Signer, StaxUnmarshallerContext> {
    private static SignerUnmarshaller INSTANCE;

    public Signer unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Signer.Builder signer = Signer.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AwsAccountNumber", targetDepth)) {
                    signer.awsAccountNumber(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("KeyPairIds", targetDepth)) continue;
                signer.keyPairIds(KeyPairIdsUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Signer)signer.build();
    }

    public static SignerUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SignerUnmarshaller();
        }
        return INSTANCE;
    }
}

