/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.S3Origin;

public class S3OriginUnmarshaller
implements Unmarshaller<S3Origin, StaxUnmarshallerContext> {
    private static S3OriginUnmarshaller INSTANCE;

    public S3Origin unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        S3Origin.Builder s3Origin = S3Origin.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DomainName", targetDepth)) {
                    s3Origin.domainName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OriginAccessIdentity", targetDepth)) continue;
                s3Origin.originAccessIdentity(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (S3Origin)s3Origin.build();
    }

    public static S3OriginUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new S3OriginUnmarshaller();
        }
        return INSTANCE;
    }
}

