/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import software.amazon.awssdk.services.cloudfront.model.AllowedMethods;
import software.amazon.awssdk.services.cloudfront.model.ForwardedValues;
import software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociations;
import software.amazon.awssdk.services.cloudfront.model.TrustedSigners;
import software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DefaultCacheBehavior
implements ToCopyableBuilder<Builder, DefaultCacheBehavior> {
    private final String targetOriginId;
    private final ForwardedValues forwardedValues;
    private final TrustedSigners trustedSigners;
    private final String viewerProtocolPolicy;
    private final Long minTTL;
    private final AllowedMethods allowedMethods;
    private final Boolean smoothStreaming;
    private final Long defaultTTL;
    private final Long maxTTL;
    private final Boolean compress;
    private final LambdaFunctionAssociations lambdaFunctionAssociations;

    private DefaultCacheBehavior(BuilderImpl builder) {
        this.targetOriginId = builder.targetOriginId;
        this.forwardedValues = builder.forwardedValues;
        this.trustedSigners = builder.trustedSigners;
        this.viewerProtocolPolicy = builder.viewerProtocolPolicy;
        this.minTTL = builder.minTTL;
        this.allowedMethods = builder.allowedMethods;
        this.smoothStreaming = builder.smoothStreaming;
        this.defaultTTL = builder.defaultTTL;
        this.maxTTL = builder.maxTTL;
        this.compress = builder.compress;
        this.lambdaFunctionAssociations = builder.lambdaFunctionAssociations;
    }

    public String targetOriginId() {
        return this.targetOriginId;
    }

    public ForwardedValues forwardedValues() {
        return this.forwardedValues;
    }

    public TrustedSigners trustedSigners() {
        return this.trustedSigners;
    }

    public String viewerProtocolPolicy() {
        return this.viewerProtocolPolicy;
    }

    public Long minTTL() {
        return this.minTTL;
    }

    public AllowedMethods allowedMethods() {
        return this.allowedMethods;
    }

    public Boolean smoothStreaming() {
        return this.smoothStreaming;
    }

    public Long defaultTTL() {
        return this.defaultTTL;
    }

    public Long maxTTL() {
        return this.maxTTL;
    }

    public Boolean compress() {
        return this.compress;
    }

    public LambdaFunctionAssociations lambdaFunctionAssociations() {
        return this.lambdaFunctionAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.targetOriginId() == null ? 0 : this.targetOriginId().hashCode());
        hashCode = 31 * hashCode + (this.forwardedValues() == null ? 0 : this.forwardedValues().hashCode());
        hashCode = 31 * hashCode + (this.trustedSigners() == null ? 0 : this.trustedSigners().hashCode());
        hashCode = 31 * hashCode + (this.viewerProtocolPolicy() == null ? 0 : this.viewerProtocolPolicy().hashCode());
        hashCode = 31 * hashCode + (this.minTTL() == null ? 0 : this.minTTL().hashCode());
        hashCode = 31 * hashCode + (this.allowedMethods() == null ? 0 : this.allowedMethods().hashCode());
        hashCode = 31 * hashCode + (this.smoothStreaming() == null ? 0 : this.smoothStreaming().hashCode());
        hashCode = 31 * hashCode + (this.defaultTTL() == null ? 0 : this.defaultTTL().hashCode());
        hashCode = 31 * hashCode + (this.maxTTL() == null ? 0 : this.maxTTL().hashCode());
        hashCode = 31 * hashCode + (this.compress() == null ? 0 : this.compress().hashCode());
        hashCode = 31 * hashCode + (this.lambdaFunctionAssociations() == null ? 0 : this.lambdaFunctionAssociations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultCacheBehavior)) {
            return false;
        }
        DefaultCacheBehavior other = (DefaultCacheBehavior)obj;
        if (other.targetOriginId() == null ^ this.targetOriginId() == null) {
            return false;
        }
        if (other.targetOriginId() != null && !other.targetOriginId().equals(this.targetOriginId())) {
            return false;
        }
        if (other.forwardedValues() == null ^ this.forwardedValues() == null) {
            return false;
        }
        if (other.forwardedValues() != null && !other.forwardedValues().equals(this.forwardedValues())) {
            return false;
        }
        if (other.trustedSigners() == null ^ this.trustedSigners() == null) {
            return false;
        }
        if (other.trustedSigners() != null && !other.trustedSigners().equals(this.trustedSigners())) {
            return false;
        }
        if (other.viewerProtocolPolicy() == null ^ this.viewerProtocolPolicy() == null) {
            return false;
        }
        if (other.viewerProtocolPolicy() != null && !other.viewerProtocolPolicy().equals(this.viewerProtocolPolicy())) {
            return false;
        }
        if (other.minTTL() == null ^ this.minTTL() == null) {
            return false;
        }
        if (other.minTTL() != null && !other.minTTL().equals(this.minTTL())) {
            return false;
        }
        if (other.allowedMethods() == null ^ this.allowedMethods() == null) {
            return false;
        }
        if (other.allowedMethods() != null && !other.allowedMethods().equals(this.allowedMethods())) {
            return false;
        }
        if (other.smoothStreaming() == null ^ this.smoothStreaming() == null) {
            return false;
        }
        if (other.smoothStreaming() != null && !other.smoothStreaming().equals(this.smoothStreaming())) {
            return false;
        }
        if (other.defaultTTL() == null ^ this.defaultTTL() == null) {
            return false;
        }
        if (other.defaultTTL() != null && !other.defaultTTL().equals(this.defaultTTL())) {
            return false;
        }
        if (other.maxTTL() == null ^ this.maxTTL() == null) {
            return false;
        }
        if (other.maxTTL() != null && !other.maxTTL().equals(this.maxTTL())) {
            return false;
        }
        if (other.compress() == null ^ this.compress() == null) {
            return false;
        }
        if (other.compress() != null && !other.compress().equals(this.compress())) {
            return false;
        }
        if (other.lambdaFunctionAssociations() == null ^ this.lambdaFunctionAssociations() == null) {
            return false;
        }
        return other.lambdaFunctionAssociations() == null || other.lambdaFunctionAssociations().equals(this.lambdaFunctionAssociations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.targetOriginId() != null) {
            sb.append("TargetOriginId: ").append(this.targetOriginId()).append(",");
        }
        if (this.forwardedValues() != null) {
            sb.append("ForwardedValues: ").append(this.forwardedValues()).append(",");
        }
        if (this.trustedSigners() != null) {
            sb.append("TrustedSigners: ").append(this.trustedSigners()).append(",");
        }
        if (this.viewerProtocolPolicy() != null) {
            sb.append("ViewerProtocolPolicy: ").append(this.viewerProtocolPolicy()).append(",");
        }
        if (this.minTTL() != null) {
            sb.append("MinTTL: ").append(this.minTTL()).append(",");
        }
        if (this.allowedMethods() != null) {
            sb.append("AllowedMethods: ").append(this.allowedMethods()).append(",");
        }
        if (this.smoothStreaming() != null) {
            sb.append("SmoothStreaming: ").append(this.smoothStreaming()).append(",");
        }
        if (this.defaultTTL() != null) {
            sb.append("DefaultTTL: ").append(this.defaultTTL()).append(",");
        }
        if (this.maxTTL() != null) {
            sb.append("MaxTTL: ").append(this.maxTTL()).append(",");
        }
        if (this.compress() != null) {
            sb.append("Compress: ").append(this.compress()).append(",");
        }
        if (this.lambdaFunctionAssociations() != null) {
            sb.append("LambdaFunctionAssociations: ").append(this.lambdaFunctionAssociations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String targetOriginId;
        private ForwardedValues forwardedValues;
        private TrustedSigners trustedSigners;
        private String viewerProtocolPolicy;
        private Long minTTL;
        private AllowedMethods allowedMethods;
        private Boolean smoothStreaming;
        private Long defaultTTL;
        private Long maxTTL;
        private Boolean compress;
        private LambdaFunctionAssociations lambdaFunctionAssociations;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultCacheBehavior model) {
            this.setTargetOriginId(model.targetOriginId);
            this.setForwardedValues(model.forwardedValues);
            this.setTrustedSigners(model.trustedSigners);
            this.setViewerProtocolPolicy(model.viewerProtocolPolicy);
            this.setMinTTL(model.minTTL);
            this.setAllowedMethods(model.allowedMethods);
            this.setSmoothStreaming(model.smoothStreaming);
            this.setDefaultTTL(model.defaultTTL);
            this.setMaxTTL(model.maxTTL);
            this.setCompress(model.compress);
            this.setLambdaFunctionAssociations(model.lambdaFunctionAssociations);
        }

        public final String getTargetOriginId() {
            return this.targetOriginId;
        }

        @Override
        public final Builder targetOriginId(String targetOriginId) {
            this.targetOriginId = targetOriginId;
            return this;
        }

        public final void setTargetOriginId(String targetOriginId) {
            this.targetOriginId = targetOriginId;
        }

        public final ForwardedValues getForwardedValues() {
            return this.forwardedValues;
        }

        @Override
        public final Builder forwardedValues(ForwardedValues forwardedValues) {
            this.forwardedValues = forwardedValues;
            return this;
        }

        public final void setForwardedValues(ForwardedValues forwardedValues) {
            this.forwardedValues = forwardedValues;
        }

        public final TrustedSigners getTrustedSigners() {
            return this.trustedSigners;
        }

        @Override
        public final Builder trustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        public final void setTrustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
        }

        public final String getViewerProtocolPolicy() {
            return this.viewerProtocolPolicy;
        }

        @Override
        public final Builder viewerProtocolPolicy(String viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
            return this;
        }

        @Override
        public final Builder viewerProtocolPolicy(ViewerProtocolPolicy viewerProtocolPolicy) {
            this.viewerProtocolPolicy(viewerProtocolPolicy.toString());
            return this;
        }

        public final void setViewerProtocolPolicy(String viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
        }

        public final void setViewerProtocolPolicy(ViewerProtocolPolicy viewerProtocolPolicy) {
            this.viewerProtocolPolicy(viewerProtocolPolicy.toString());
        }

        public final Long getMinTTL() {
            return this.minTTL;
        }

        @Override
        public final Builder minTTL(Long minTTL) {
            this.minTTL = minTTL;
            return this;
        }

        public final void setMinTTL(Long minTTL) {
            this.minTTL = minTTL;
        }

        public final AllowedMethods getAllowedMethods() {
            return this.allowedMethods;
        }

        @Override
        public final Builder allowedMethods(AllowedMethods allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        public final void setAllowedMethods(AllowedMethods allowedMethods) {
            this.allowedMethods = allowedMethods;
        }

        public final Boolean getSmoothStreaming() {
            return this.smoothStreaming;
        }

        @Override
        public final Builder smoothStreaming(Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
            return this;
        }

        public final void setSmoothStreaming(Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
        }

        public final Long getDefaultTTL() {
            return this.defaultTTL;
        }

        @Override
        public final Builder defaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
            return this;
        }

        public final void setDefaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
        }

        public final Long getMaxTTL() {
            return this.maxTTL;
        }

        @Override
        public final Builder maxTTL(Long maxTTL) {
            this.maxTTL = maxTTL;
            return this;
        }

        public final void setMaxTTL(Long maxTTL) {
            this.maxTTL = maxTTL;
        }

        public final Boolean getCompress() {
            return this.compress;
        }

        @Override
        public final Builder compress(Boolean compress) {
            this.compress = compress;
            return this;
        }

        public final void setCompress(Boolean compress) {
            this.compress = compress;
        }

        public final LambdaFunctionAssociations getLambdaFunctionAssociations() {
            return this.lambdaFunctionAssociations;
        }

        @Override
        public final Builder lambdaFunctionAssociations(LambdaFunctionAssociations lambdaFunctionAssociations) {
            this.lambdaFunctionAssociations = lambdaFunctionAssociations;
            return this;
        }

        public final void setLambdaFunctionAssociations(LambdaFunctionAssociations lambdaFunctionAssociations) {
            this.lambdaFunctionAssociations = lambdaFunctionAssociations;
        }

        public DefaultCacheBehavior build() {
            return new DefaultCacheBehavior(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DefaultCacheBehavior> {
        public Builder targetOriginId(String var1);

        public Builder forwardedValues(ForwardedValues var1);

        public Builder trustedSigners(TrustedSigners var1);

        public Builder viewerProtocolPolicy(String var1);

        public Builder viewerProtocolPolicy(ViewerProtocolPolicy var1);

        public Builder minTTL(Long var1);

        public Builder allowedMethods(AllowedMethods var1);

        public Builder smoothStreaming(Boolean var1);

        public Builder defaultTTL(Long var1);

        public Builder maxTTL(Long var1);

        public Builder compress(Boolean var1);

        public Builder lambdaFunctionAssociations(LambdaFunctionAssociations var1);
    }
}

