/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudFrontOriginAccessIdentitySummary
implements ToCopyableBuilder<Builder, CloudFrontOriginAccessIdentitySummary> {
    private final String id;
    private final String s3CanonicalUserId;
    private final String comment;

    private CloudFrontOriginAccessIdentitySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.s3CanonicalUserId = builder.s3CanonicalUserId;
        this.comment = builder.comment;
    }

    public String id() {
        return this.id;
    }

    public String s3CanonicalUserId() {
        return this.s3CanonicalUserId;
    }

    public String comment() {
        return this.comment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.s3CanonicalUserId() == null ? 0 : this.s3CanonicalUserId().hashCode());
        hashCode = 31 * hashCode + (this.comment() == null ? 0 : this.comment().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFrontOriginAccessIdentitySummary)) {
            return false;
        }
        CloudFrontOriginAccessIdentitySummary other = (CloudFrontOriginAccessIdentitySummary)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.s3CanonicalUserId() == null ^ this.s3CanonicalUserId() == null) {
            return false;
        }
        if (other.s3CanonicalUserId() != null && !other.s3CanonicalUserId().equals(this.s3CanonicalUserId())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        return other.comment() == null || other.comment().equals(this.comment());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.s3CanonicalUserId() != null) {
            sb.append("S3CanonicalUserId: ").append(this.s3CanonicalUserId()).append(",");
        }
        if (this.comment() != null) {
            sb.append("Comment: ").append(this.comment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String s3CanonicalUserId;
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFrontOriginAccessIdentitySummary model) {
            this.setId(model.id);
            this.setS3CanonicalUserId(model.s3CanonicalUserId);
            this.setComment(model.comment);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getS3CanonicalUserId() {
            return this.s3CanonicalUserId;
        }

        @Override
        public final Builder s3CanonicalUserId(String s3CanonicalUserId) {
            this.s3CanonicalUserId = s3CanonicalUserId;
            return this;
        }

        public final void setS3CanonicalUserId(String s3CanonicalUserId) {
            this.s3CanonicalUserId = s3CanonicalUserId;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public CloudFrontOriginAccessIdentitySummary build() {
            return new CloudFrontOriginAccessIdentitySummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudFrontOriginAccessIdentitySummary> {
        public Builder id(String var1);

        public Builder s3CanonicalUserId(String var1);

        public Builder comment(String var1);
    }
}

