/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.transform;

import static software.amazon.awssdk.util.StringUtils.UTF8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.cloudfront.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.util.StringInputStream;

import software.amazon.awssdk.util.XmlWriter;

/**
 * CreateStreamingDistributionRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateStreamingDistributionRequestMarshaller implements
        Marshaller<Request<CreateStreamingDistributionRequest>, CreateStreamingDistributionRequest> {

    public Request<CreateStreamingDistributionRequest> marshall(
            CreateStreamingDistributionRequest createStreamingDistributionRequest) {

        if (createStreamingDistributionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateStreamingDistributionRequest> request = new DefaultRequest<CreateStreamingDistributionRequest>(
                createStreamingDistributionRequest, "CloudFrontClient");

        request.setHttpMethod(HttpMethodName.POST);

        String uriResourcePath = "/2017-03-25/streaming-distribution";

        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = null;
            StreamingDistributionConfig streamingDistributionConfig = createStreamingDistributionRequest
                    .streamingDistributionConfig();
            if (streamingDistributionConfig != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2017-03-25/");
                xmlWriter.startElement("StreamingDistributionConfig");

                if (streamingDistributionConfig.callerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(streamingDistributionConfig.callerReference()).endElement();
                }

                S3Origin s3Origin = streamingDistributionConfig.s3Origin();
                if (s3Origin != null) {
                    xmlWriter.startElement("S3Origin");

                    if (s3Origin.domainName() != null) {
                        xmlWriter.startElement("DomainName").value(s3Origin.domainName()).endElement();
                    }

                    if (s3Origin.originAccessIdentity() != null) {
                        xmlWriter.startElement("OriginAccessIdentity").value(s3Origin.originAccessIdentity()).endElement();
                    }
                    xmlWriter.endElement();
                }

                Aliases aliases = streamingDistributionConfig.aliases();
                if (aliases != null) {
                    xmlWriter.startElement("Aliases");

                    if (aliases.quantity() != null) {
                        xmlWriter.startElement("Quantity").value(aliases.quantity()).endElement();
                    }

                    java.util.List<String> aliasesItemsList = aliases.items();
                    if (aliasesItemsList != null) {
                        xmlWriter.startElement("Items");

                        for (String aliasesItemsListValue : aliasesItemsList) {
                            xmlWriter.startElement("CNAME");
                            xmlWriter.value(aliasesItemsListValue);
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }

                if (streamingDistributionConfig.comment() != null) {
                    xmlWriter.startElement("Comment").value(streamingDistributionConfig.comment()).endElement();
                }

                StreamingLoggingConfig logging = streamingDistributionConfig.logging();
                if (logging != null) {
                    xmlWriter.startElement("Logging");

                    if (logging.enabled() != null) {
                        xmlWriter.startElement("Enabled").value(logging.enabled()).endElement();
                    }

                    if (logging.bucket() != null) {
                        xmlWriter.startElement("Bucket").value(logging.bucket()).endElement();
                    }

                    if (logging.prefix() != null) {
                        xmlWriter.startElement("Prefix").value(logging.prefix()).endElement();
                    }
                    xmlWriter.endElement();
                }

                TrustedSigners trustedSigners = streamingDistributionConfig.trustedSigners();
                if (trustedSigners != null) {
                    xmlWriter.startElement("TrustedSigners");

                    if (trustedSigners.enabled() != null) {
                        xmlWriter.startElement("Enabled").value(trustedSigners.enabled()).endElement();
                    }

                    if (trustedSigners.quantity() != null) {
                        xmlWriter.startElement("Quantity").value(trustedSigners.quantity()).endElement();
                    }

                    java.util.List<String> trustedSignersItemsList = trustedSigners.items();
                    if (trustedSignersItemsList != null) {
                        xmlWriter.startElement("Items");

                        for (String trustedSignersItemsListValue : trustedSignersItemsList) {
                            xmlWriter.startElement("AwsAccountNumber");
                            xmlWriter.value(trustedSignersItemsListValue);
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }

                if (streamingDistributionConfig.priceClass() != null) {
                    xmlWriter.startElement("PriceClass").value(streamingDistributionConfig.priceClass()).endElement();
                }

                if (streamingDistributionConfig.enabled() != null) {
                    xmlWriter.startElement("Enabled").value(streamingDistributionConfig.enabled()).endElement();
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}