/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudfront.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * CacheBehavior StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CacheBehaviorUnmarshaller implements Unmarshaller<CacheBehavior, StaxUnmarshallerContext> {

    public CacheBehavior unmarshall(StaxUnmarshallerContext context) throws Exception {
        CacheBehavior.Builder cacheBehavior = CacheBehavior.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("PathPattern", targetDepth)) {
                    cacheBehavior.pathPattern(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("TargetOriginId", targetDepth)) {
                    cacheBehavior.targetOriginId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ForwardedValues", targetDepth)) {
                    cacheBehavior.forwardedValues(ForwardedValuesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("TrustedSigners", targetDepth)) {
                    cacheBehavior.trustedSigners(TrustedSignersUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ViewerProtocolPolicy", targetDepth)) {
                    cacheBehavior.viewerProtocolPolicy(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MinTTL", targetDepth)) {
                    cacheBehavior.minTTL(LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AllowedMethods", targetDepth)) {
                    cacheBehavior.allowedMethods(AllowedMethodsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("SmoothStreaming", targetDepth)) {
                    cacheBehavior.smoothStreaming(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DefaultTTL", targetDepth)) {
                    cacheBehavior.defaultTTL(LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxTTL", targetDepth)) {
                    cacheBehavior.maxTTL(LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Compress", targetDepth)) {
                    cacheBehavior.compress(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("LambdaFunctionAssociations", targetDepth)) {
                    cacheBehavior.lambdaFunctionAssociations(LambdaFunctionAssociationsUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return cacheBehavior.build();
    }

    private static CacheBehaviorUnmarshaller INSTANCE;

    public static CacheBehaviorUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new CacheBehaviorUnmarshaller();
        return INSTANCE;
    }
}
