/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that specifies the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Which SSL/TLS certificate to use when viewers request objects using HTTPS
 * </p>
 * </li>
 * <li>
 * <p>
 * Whether you want CloudFront to use dedicated IP addresses or SNI when you're using alternate domain names in your
 * object names
 * </p>
 * </li>
 * <li>
 * <p>
 * The minimum protocol version that you want CloudFront to use when communicating with viewers
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information, see <a
 * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html">Using an HTTPS
 * Connection to Access Your Objects</a> in the <i>Amazon Amazon CloudFront Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ViewerCertificate implements ToCopyableBuilder<ViewerCertificate.Builder, ViewerCertificate> {
    private final Boolean cloudFrontDefaultCertificate;

    private final String iamCertificateId;

    private final String acmCertificateArn;

    private final String sslSupportMethod;

    private final String minimumProtocolVersion;

    private final String certificate;

    private final String certificateSource;

    private ViewerCertificate(BuilderImpl builder) {
        this.cloudFrontDefaultCertificate = builder.cloudFrontDefaultCertificate;
        this.iamCertificateId = builder.iamCertificateId;
        this.acmCertificateArn = builder.acmCertificateArn;
        this.sslSupportMethod = builder.sslSupportMethod;
        this.minimumProtocolVersion = builder.minimumProtocolVersion;
        this.certificate = builder.certificate;
        this.certificateSource = builder.certificateSource;
    }

    /**
     * Returns the value of the CloudFrontDefaultCertificate property for this object.
     * 
     * @return The value of the CloudFrontDefaultCertificate property for this object.
     */
    public Boolean cloudFrontDefaultCertificate() {
        return cloudFrontDefaultCertificate;
    }

    /**
     * Returns the value of the IAMCertificateId property for this object.
     * 
     * @return The value of the IAMCertificateId property for this object.
     */
    public String iamCertificateId() {
        return iamCertificateId;
    }

    /**
     * Returns the value of the ACMCertificateArn property for this object.
     * 
     * @return The value of the ACMCertificateArn property for this object.
     */
    public String acmCertificateArn() {
        return acmCertificateArn;
    }

    /**
     * <p>
     * If you specify a value for <code>ACMCertificateArn</code> or for <code>IAMCertificateId</code>, you must also
     * specify how you want CloudFront to serve HTTPS requests: using a method that works for all clients or one that
     * works for most clients:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>vip</code>: CloudFront uses dedicated IP addresses for your content and can respond to HTTPS requests from
     * any viewer. However, you will incur additional monthly charges.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sni-only</code>: CloudFront can respond to HTTPS requests from viewers that support Server Name Indication
     * (SNI). All modern browsers support SNI, but some browsers still in use don't support SNI. If some of your users'
     * browsers don't support SNI, we recommend that you do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>vip</code> option (dedicated IP addresses) instead of <code>sni-only</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the CloudFront SSL/TLS certificate instead of a custom certificate. This requires that you use the CloudFront
     * domain name of your distribution in the URLs for your objects, for example,
     * <code>https://d111111abcdef8.cloudfront.net/logo.png</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you can control which browser your users use, upgrade the browser to one that supports SNI.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use HTTP instead of HTTPS.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Do not specify a value for <code>SSLSupportMethod</code> if you specified
     * <code>&lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt;</code>.
     * </p>
     * <p>
     * For more information, see <a href=
     * "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html#CNAMEsAndHTTPS.html"
     * >Using Alternate Domain Names and HTTPS</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return If you specify a value for <code>ACMCertificateArn</code> or for <code>IAMCertificateId</code>, you must
     *         also specify how you want CloudFront to serve HTTPS requests: using a method that works for all clients
     *         or one that works for most clients:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>vip</code>: CloudFront uses dedicated IP addresses for your content and can respond to HTTPS
     *         requests from any viewer. However, you will incur additional monthly charges.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sni-only</code>: CloudFront can respond to HTTPS requests from viewers that support Server Name
     *         Indication (SNI). All modern browsers support SNI, but some browsers still in use don't support SNI. If
     *         some of your users' browsers don't support SNI, we recommend that you do one of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use the <code>vip</code> option (dedicated IP addresses) instead of <code>sni-only</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the CloudFront SSL/TLS certificate instead of a custom certificate. This requires that you use the
     *         CloudFront domain name of your distribution in the URLs for your objects, for example,
     *         <code>https://d111111abcdef8.cloudfront.net/logo.png</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you can control which browser your users use, upgrade the browser to one that supports SNI.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use HTTP instead of HTTPS.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         Do not specify a value for <code>SSLSupportMethod</code> if you specified
     *         <code>&lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt;</code>.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html#CNAMEsAndHTTPS.html"
     *         >Using Alternate Domain Names and HTTPS</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * @see SSLSupportMethod
     */
    public String sslSupportMethod() {
        return sslSupportMethod;
    }

    /**
     * <p>
     * Specify the minimum version of the SSL/TLS protocol that you want CloudFront to use for HTTPS connections between
     * viewers and CloudFront: <code>SSLv3</code> or <code>TLSv1</code>. CloudFront serves your objects only to viewers
     * that support SSL/TLS version that you specify and later versions. The <code>TLSv1</code> protocol is more secure,
     * so we recommend that you specify <code>SSLv3</code> only if your users are using browsers or devices that don't
     * support <code>TLSv1</code>. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify &lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt;, the minimum SSL
     * protocol version is <code>TLSv1</code> and can't be changed.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you're using a custom certificate (if you specify a value for <code>ACMCertificateArn</code> or for
     * <code>IAMCertificateId</code>) and if you're using SNI (if you specify <code>sni-only</code> for
     * <code>SSLSupportMethod</code>), you must specify <code>TLSv1</code> for <code>MinimumProtocolVersion</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specify the minimum version of the SSL/TLS protocol that you want CloudFront to use for HTTPS connections
     *         between viewers and CloudFront: <code>SSLv3</code> or <code>TLSv1</code>. CloudFront serves your objects
     *         only to viewers that support SSL/TLS version that you specify and later versions. The <code>TLSv1</code>
     *         protocol is more secure, so we recommend that you specify <code>SSLv3</code> only if your users are using
     *         browsers or devices that don't support <code>TLSv1</code>. Note the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify &lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt;, the minimum
     *         SSL protocol version is <code>TLSv1</code> and can't be changed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you're using a custom certificate (if you specify a value for <code>ACMCertificateArn</code> or for
     *         <code>IAMCertificateId</code>) and if you're using SNI (if you specify <code>sni-only</code> for
     *         <code>SSLSupportMethod</code>), you must specify <code>TLSv1</code> for
     *         <code>MinimumProtocolVersion</code>.
     *         </p>
     *         </li>
     * @see MinimumProtocolVersion
     */
    public String minimumProtocolVersion() {
        return minimumProtocolVersion;
    }

    /**
     * <p>
     * Include one of these values to specify the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Whether you want viewers to use HTTP or HTTPS to request your objects.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you want viewers to use HTTPS, whether you're using an alternate domain name such as example.com or the
     * CloudFront domain name for your distribution, such as <code>d111111abcdef8.cloudfront.net</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you're using an alternate domain name, whether AWS Certificate Manager (ACM) provided the certificate, or you
     * purchased a certificate from a third-party certificate authority and imported it into ACM or uploaded it to the
     * IAM certificate store.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You must specify one (and only one) of the three values. Do not specify <code>false</code> for
     * <code>CloudFrontDefaultCertificate</code>.
     * </p>
     * <p>
     * <b>If you want viewers to use HTTP to request your objects</b>: Specify the following value:
     * </p>
     * <p>
     * <code>&lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt;</code>
     * </p>
     * <p>
     * In addition, specify <code>allow-all</code> for <code>ViewerProtocolPolicy</code> for all of your cache
     * behaviors.
     * </p>
     * <p>
     * <b>If you want viewers to use HTTPS to request your objects</b>: Choose the type of certificate that you want to
     * use based on whether you're using an alternate domain name for your objects or the CloudFront domain name:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>If you're using an alternate domain name, such as example.com</b>: Specify one of the following values,
     * depending on whether ACM provided your certificate or you purchased your certificate from third-party certificate
     * authority:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>&lt;ACMCertificateArn&gt;ARN for ACM SSL/TLS certificate&lt;ACMCertificateArn&gt;</code> where ARN for ACM
     * SSL/TLS certificate is the ARN for the ACM SSL/TLS certificate that you want to use for this distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>&lt;IAMCertificateId&gt;IAM certificate ID&lt;IAMCertificateId&gt;</code> where IAM certificate ID is the
     * ID that IAM returned when you added the certificate to the IAM certificate store.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify <code>ACMCertificateArn</code> or <code>IAMCertificateId</code>, you must also specify a value for
     * <code>SSLSupportMethod</code>.
     * </p>
     * <p>
     * If you choose to use an ACM certificate or a certificate in the IAM certificate store, we recommend that you use
     * only an alternate domain name in your object URLs (<code>https://example.com/logo.jpg</code>). If you use the
     * domain name that is associated with your CloudFront distribution (
     * <code>https://d111111abcdef8.cloudfront.net/logo.jpg</code>) and the viewer supports <code>SNI</code>, then
     * CloudFront behaves normally. However, if the browser does not support SNI, the user's experience depends on the
     * value that you choose for <code>SSLSupportMethod</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>vip</code>: The viewer displays a warning because there is a mismatch between the CloudFront domain name
     * and the domain name in your SSL/TLS certificate.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sni-only</code>: CloudFront drops the connection with the browser without returning the object.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>If you're using the CloudFront domain name for your distribution, such as
     * <code>d111111abcdef8.cloudfront.net</code> </b>: Specify the following value:
     * </p>
     * <p>
     * <code> &lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt; </code>
     * </p>
     * <p>
     * If you want viewers to use HTTPS, you must also specify one of the following values in your cache behaviors:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code> &lt;ViewerProtocolPolicy&gt;https-only&lt;ViewerProtocolPolicy&gt; </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> &lt;ViewerProtocolPolicy&gt;redirect-to-https&lt;ViewerProtocolPolicy&gt; </code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also optionally require that CloudFront use HTTPS to communicate with your origin by specifying one of
     * the following values for the applicable origins:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code> &lt;OriginProtocolPolicy&gt;https-only&lt;OriginProtocolPolicy&gt; </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> &lt;OriginProtocolPolicy&gt;match-viewer&lt;OriginProtocolPolicy&gt; </code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html#CNAMEsAndHTTPS"
     * >Using Alternate Domain Names and HTTPS</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Include one of these values to specify the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Whether you want viewers to use HTTP or HTTPS to request your objects.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you want viewers to use HTTPS, whether you're using an alternate domain name such as example.com or
     *         the CloudFront domain name for your distribution, such as <code>d111111abcdef8.cloudfront.net</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you're using an alternate domain name, whether AWS Certificate Manager (ACM) provided the certificate,
     *         or you purchased a certificate from a third-party certificate authority and imported it into ACM or
     *         uploaded it to the IAM certificate store.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You must specify one (and only one) of the three values. Do not specify <code>false</code> for
     *         <code>CloudFrontDefaultCertificate</code>.
     *         </p>
     *         <p>
     *         <b>If you want viewers to use HTTP to request your objects</b>: Specify the following value:
     *         </p>
     *         <p>
     *         <code>&lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt;</code>
     *         </p>
     *         <p>
     *         In addition, specify <code>allow-all</code> for <code>ViewerProtocolPolicy</code> for all of your cache
     *         behaviors.
     *         </p>
     *         <p>
     *         <b>If you want viewers to use HTTPS to request your objects</b>: Choose the type of certificate that you
     *         want to use based on whether you're using an alternate domain name for your objects or the CloudFront
     *         domain name:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>If you're using an alternate domain name, such as example.com</b>: Specify one of the following
     *         values, depending on whether ACM provided your certificate or you purchased your certificate from
     *         third-party certificate authority:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>&lt;ACMCertificateArn&gt;ARN for ACM SSL/TLS certificate&lt;ACMCertificateArn&gt;</code> where ARN
     *         for ACM SSL/TLS certificate is the ARN for the ACM SSL/TLS certificate that you want to use for this
     *         distribution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>&lt;IAMCertificateId&gt;IAM certificate ID&lt;IAMCertificateId&gt;</code> where IAM certificate ID
     *         is the ID that IAM returned when you added the certificate to the IAM certificate store.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you specify <code>ACMCertificateArn</code> or <code>IAMCertificateId</code>, you must also specify a
     *         value for <code>SSLSupportMethod</code>.
     *         </p>
     *         <p>
     *         If you choose to use an ACM certificate or a certificate in the IAM certificate store, we recommend that
     *         you use only an alternate domain name in your object URLs (<code>https://example.com/logo.jpg</code>). If
     *         you use the domain name that is associated with your CloudFront distribution (
     *         <code>https://d111111abcdef8.cloudfront.net/logo.jpg</code>) and the viewer supports <code>SNI</code>,
     *         then CloudFront behaves normally. However, if the browser does not support SNI, the user's experience
     *         depends on the value that you choose for <code>SSLSupportMethod</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>vip</code>: The viewer displays a warning because there is a mismatch between the CloudFront domain
     *         name and the domain name in your SSL/TLS certificate.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sni-only</code>: CloudFront drops the connection with the browser without returning the object.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>If you're using the CloudFront domain name for your distribution, such as
     *         <code>d111111abcdef8.cloudfront.net</code> </b>: Specify the following value:
     *         </p>
     *         <p>
     *         <code> &lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt; </code>
     *         </p>
     *         <p>
     *         If you want viewers to use HTTPS, you must also specify one of the following values in your cache
     *         behaviors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code> &lt;ViewerProtocolPolicy&gt;https-only&lt;ViewerProtocolPolicy&gt; </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code> &lt;ViewerProtocolPolicy&gt;redirect-to-https&lt;ViewerProtocolPolicy&gt; </code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can also optionally require that CloudFront use HTTPS to communicate with your origin by specifying
     *         one of the following values for the applicable origins:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code> &lt;OriginProtocolPolicy&gt;https-only&lt;OriginProtocolPolicy&gt; </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code> &lt;OriginProtocolPolicy&gt;match-viewer&lt;OriginProtocolPolicy&gt; </code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html#CNAMEsAndHTTPS"
     *         >Using Alternate Domain Names and HTTPS</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         </li>
     */
    public String certificate() {
        return certificate;
    }

    /**
     * <note>
     * <p>
     * This field is deprecated. You can use one of the following: <code>[ACMCertificateArn</code>,
     * <code>IAMCertificateId</code>, or <code>CloudFrontDefaultCertificate]</code>.
     * </p>
     * </note>
     * 
     * @return <p>
     *         This field is deprecated. You can use one of the following: <code>[ACMCertificateArn</code>,
     *         <code>IAMCertificateId</code>, or <code>CloudFrontDefaultCertificate]</code>.
     *         </p>
     * @see CertificateSource
     */
    public String certificateSource() {
        return certificateSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((cloudFrontDefaultCertificate() == null) ? 0 : cloudFrontDefaultCertificate().hashCode());
        hashCode = 31 * hashCode + ((iamCertificateId() == null) ? 0 : iamCertificateId().hashCode());
        hashCode = 31 * hashCode + ((acmCertificateArn() == null) ? 0 : acmCertificateArn().hashCode());
        hashCode = 31 * hashCode + ((sslSupportMethod() == null) ? 0 : sslSupportMethod().hashCode());
        hashCode = 31 * hashCode + ((minimumProtocolVersion() == null) ? 0 : minimumProtocolVersion().hashCode());
        hashCode = 31 * hashCode + ((certificate() == null) ? 0 : certificate().hashCode());
        hashCode = 31 * hashCode + ((certificateSource() == null) ? 0 : certificateSource().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewerCertificate)) {
            return false;
        }
        ViewerCertificate other = (ViewerCertificate) obj;
        if (other.cloudFrontDefaultCertificate() == null ^ this.cloudFrontDefaultCertificate() == null) {
            return false;
        }
        if (other.cloudFrontDefaultCertificate() != null
                && !other.cloudFrontDefaultCertificate().equals(this.cloudFrontDefaultCertificate())) {
            return false;
        }
        if (other.iamCertificateId() == null ^ this.iamCertificateId() == null) {
            return false;
        }
        if (other.iamCertificateId() != null && !other.iamCertificateId().equals(this.iamCertificateId())) {
            return false;
        }
        if (other.acmCertificateArn() == null ^ this.acmCertificateArn() == null) {
            return false;
        }
        if (other.acmCertificateArn() != null && !other.acmCertificateArn().equals(this.acmCertificateArn())) {
            return false;
        }
        if (other.sslSupportMethod() == null ^ this.sslSupportMethod() == null) {
            return false;
        }
        if (other.sslSupportMethod() != null && !other.sslSupportMethod().equals(this.sslSupportMethod())) {
            return false;
        }
        if (other.minimumProtocolVersion() == null ^ this.minimumProtocolVersion() == null) {
            return false;
        }
        if (other.minimumProtocolVersion() != null && !other.minimumProtocolVersion().equals(this.minimumProtocolVersion())) {
            return false;
        }
        if (other.certificate() == null ^ this.certificate() == null) {
            return false;
        }
        if (other.certificate() != null && !other.certificate().equals(this.certificate())) {
            return false;
        }
        if (other.certificateSource() == null ^ this.certificateSource() == null) {
            return false;
        }
        if (other.certificateSource() != null && !other.certificateSource().equals(this.certificateSource())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (cloudFrontDefaultCertificate() != null) {
            sb.append("CloudFrontDefaultCertificate: ").append(cloudFrontDefaultCertificate()).append(",");
        }
        if (iamCertificateId() != null) {
            sb.append("IAMCertificateId: ").append(iamCertificateId()).append(",");
        }
        if (acmCertificateArn() != null) {
            sb.append("ACMCertificateArn: ").append(acmCertificateArn()).append(",");
        }
        if (sslSupportMethod() != null) {
            sb.append("SSLSupportMethod: ").append(sslSupportMethod()).append(",");
        }
        if (minimumProtocolVersion() != null) {
            sb.append("MinimumProtocolVersion: ").append(minimumProtocolVersion()).append(",");
        }
        if (certificate() != null) {
            sb.append("Certificate: ").append(certificate()).append(",");
        }
        if (certificateSource() != null) {
            sb.append("CertificateSource: ").append(certificateSource()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ViewerCertificate> {
        /**
         * Sets the value of the CloudFrontDefaultCertificate property for this object.
         *
         * @param cloudFrontDefaultCertificate
         *        The new value for the CloudFrontDefaultCertificate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontDefaultCertificate(Boolean cloudFrontDefaultCertificate);

        /**
         * Sets the value of the IAMCertificateId property for this object.
         *
         * @param iamCertificateId
         *        The new value for the IAMCertificateId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamCertificateId(String iamCertificateId);

        /**
         * Sets the value of the ACMCertificateArn property for this object.
         *
         * @param acmCertificateArn
         *        The new value for the ACMCertificateArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acmCertificateArn(String acmCertificateArn);

        /**
         * <p>
         * If you specify a value for <code>ACMCertificateArn</code> or for <code>IAMCertificateId</code>, you must also
         * specify how you want CloudFront to serve HTTPS requests: using a method that works for all clients or one
         * that works for most clients:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>vip</code>: CloudFront uses dedicated IP addresses for your content and can respond to HTTPS requests
         * from any viewer. However, you will incur additional monthly charges.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sni-only</code>: CloudFront can respond to HTTPS requests from viewers that support Server Name
         * Indication (SNI). All modern browsers support SNI, but some browsers still in use don't support SNI. If some
         * of your users' browsers don't support SNI, we recommend that you do one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use the <code>vip</code> option (dedicated IP addresses) instead of <code>sni-only</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the CloudFront SSL/TLS certificate instead of a custom certificate. This requires that you use the
         * CloudFront domain name of your distribution in the URLs for your objects, for example,
         * <code>https://d111111abcdef8.cloudfront.net/logo.png</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you can control which browser your users use, upgrade the browser to one that supports SNI.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use HTTP instead of HTTPS.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * Do not specify a value for <code>SSLSupportMethod</code> if you specified
         * <code>&lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt;</code>.
         * </p>
         * <p>
         * For more information, see <a href=
         * "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html#CNAMEsAndHTTPS.html"
         * >Using Alternate Domain Names and HTTPS</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param sslSupportMethod
         *        If you specify a value for <code>ACMCertificateArn</code> or for <code>IAMCertificateId</code>, you
         *        must also specify how you want CloudFront to serve HTTPS requests: using a method that works for all
         *        clients or one that works for most clients:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>vip</code>: CloudFront uses dedicated IP addresses for your content and can respond to HTTPS
         *        requests from any viewer. However, you will incur additional monthly charges.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sni-only</code>: CloudFront can respond to HTTPS requests from viewers that support Server Name
         *        Indication (SNI). All modern browsers support SNI, but some browsers still in use don't support SNI.
         *        If some of your users' browsers don't support SNI, we recommend that you do one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use the <code>vip</code> option (dedicated IP addresses) instead of <code>sni-only</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the CloudFront SSL/TLS certificate instead of a custom certificate. This requires that you use the
         *        CloudFront domain name of your distribution in the URLs for your objects, for example,
         *        <code>https://d111111abcdef8.cloudfront.net/logo.png</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you can control which browser your users use, upgrade the browser to one that supports SNI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use HTTP instead of HTTPS.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        Do not specify a value for <code>SSLSupportMethod</code> if you specified
         *        <code>&lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt;</code>.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html#CNAMEsAndHTTPS.html"
         *        >Using Alternate Domain Names and HTTPS</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @see SSLSupportMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSLSupportMethod
         */
        Builder sslSupportMethod(String sslSupportMethod);

        /**
         * <p>
         * If you specify a value for <code>ACMCertificateArn</code> or for <code>IAMCertificateId</code>, you must also
         * specify how you want CloudFront to serve HTTPS requests: using a method that works for all clients or one
         * that works for most clients:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>vip</code>: CloudFront uses dedicated IP addresses for your content and can respond to HTTPS requests
         * from any viewer. However, you will incur additional monthly charges.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sni-only</code>: CloudFront can respond to HTTPS requests from viewers that support Server Name
         * Indication (SNI). All modern browsers support SNI, but some browsers still in use don't support SNI. If some
         * of your users' browsers don't support SNI, we recommend that you do one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use the <code>vip</code> option (dedicated IP addresses) instead of <code>sni-only</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the CloudFront SSL/TLS certificate instead of a custom certificate. This requires that you use the
         * CloudFront domain name of your distribution in the URLs for your objects, for example,
         * <code>https://d111111abcdef8.cloudfront.net/logo.png</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you can control which browser your users use, upgrade the browser to one that supports SNI.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use HTTP instead of HTTPS.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * Do not specify a value for <code>SSLSupportMethod</code> if you specified
         * <code>&lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt;</code>.
         * </p>
         * <p>
         * For more information, see <a href=
         * "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html#CNAMEsAndHTTPS.html"
         * >Using Alternate Domain Names and HTTPS</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param sslSupportMethod
         *        If you specify a value for <code>ACMCertificateArn</code> or for <code>IAMCertificateId</code>, you
         *        must also specify how you want CloudFront to serve HTTPS requests: using a method that works for all
         *        clients or one that works for most clients:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>vip</code>: CloudFront uses dedicated IP addresses for your content and can respond to HTTPS
         *        requests from any viewer. However, you will incur additional monthly charges.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sni-only</code>: CloudFront can respond to HTTPS requests from viewers that support Server Name
         *        Indication (SNI). All modern browsers support SNI, but some browsers still in use don't support SNI.
         *        If some of your users' browsers don't support SNI, we recommend that you do one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use the <code>vip</code> option (dedicated IP addresses) instead of <code>sni-only</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the CloudFront SSL/TLS certificate instead of a custom certificate. This requires that you use the
         *        CloudFront domain name of your distribution in the URLs for your objects, for example,
         *        <code>https://d111111abcdef8.cloudfront.net/logo.png</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you can control which browser your users use, upgrade the browser to one that supports SNI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use HTTP instead of HTTPS.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        Do not specify a value for <code>SSLSupportMethod</code> if you specified
         *        <code>&lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt;</code>.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html#CNAMEsAndHTTPS.html"
         *        >Using Alternate Domain Names and HTTPS</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @see SSLSupportMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSLSupportMethod
         */
        Builder sslSupportMethod(SSLSupportMethod sslSupportMethod);

        /**
         * <p>
         * Specify the minimum version of the SSL/TLS protocol that you want CloudFront to use for HTTPS connections
         * between viewers and CloudFront: <code>SSLv3</code> or <code>TLSv1</code>. CloudFront serves your objects only
         * to viewers that support SSL/TLS version that you specify and later versions. The <code>TLSv1</code> protocol
         * is more secure, so we recommend that you specify <code>SSLv3</code> only if your users are using browsers or
         * devices that don't support <code>TLSv1</code>. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify &lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt;, the minimum SSL
         * protocol version is <code>TLSv1</code> and can't be changed.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you're using a custom certificate (if you specify a value for <code>ACMCertificateArn</code> or for
         * <code>IAMCertificateId</code>) and if you're using SNI (if you specify <code>sni-only</code> for
         * <code>SSLSupportMethod</code>), you must specify <code>TLSv1</code> for <code>MinimumProtocolVersion</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param minimumProtocolVersion
         *        Specify the minimum version of the SSL/TLS protocol that you want CloudFront to use for HTTPS
         *        connections between viewers and CloudFront: <code>SSLv3</code> or <code>TLSv1</code>. CloudFront
         *        serves your objects only to viewers that support SSL/TLS version that you specify and later versions.
         *        The <code>TLSv1</code> protocol is more secure, so we recommend that you specify <code>SSLv3</code>
         *        only if your users are using browsers or devices that don't support <code>TLSv1</code>. Note the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify &lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt;, the
         *        minimum SSL protocol version is <code>TLSv1</code> and can't be changed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you're using a custom certificate (if you specify a value for <code>ACMCertificateArn</code> or for
         *        <code>IAMCertificateId</code>) and if you're using SNI (if you specify <code>sni-only</code> for
         *        <code>SSLSupportMethod</code>), you must specify <code>TLSv1</code> for
         *        <code>MinimumProtocolVersion</code>.
         *        </p>
         *        </li>
         * @see MinimumProtocolVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MinimumProtocolVersion
         */
        Builder minimumProtocolVersion(String minimumProtocolVersion);

        /**
         * <p>
         * Specify the minimum version of the SSL/TLS protocol that you want CloudFront to use for HTTPS connections
         * between viewers and CloudFront: <code>SSLv3</code> or <code>TLSv1</code>. CloudFront serves your objects only
         * to viewers that support SSL/TLS version that you specify and later versions. The <code>TLSv1</code> protocol
         * is more secure, so we recommend that you specify <code>SSLv3</code> only if your users are using browsers or
         * devices that don't support <code>TLSv1</code>. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify &lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt;, the minimum SSL
         * protocol version is <code>TLSv1</code> and can't be changed.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you're using a custom certificate (if you specify a value for <code>ACMCertificateArn</code> or for
         * <code>IAMCertificateId</code>) and if you're using SNI (if you specify <code>sni-only</code> for
         * <code>SSLSupportMethod</code>), you must specify <code>TLSv1</code> for <code>MinimumProtocolVersion</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param minimumProtocolVersion
         *        Specify the minimum version of the SSL/TLS protocol that you want CloudFront to use for HTTPS
         *        connections between viewers and CloudFront: <code>SSLv3</code> or <code>TLSv1</code>. CloudFront
         *        serves your objects only to viewers that support SSL/TLS version that you specify and later versions.
         *        The <code>TLSv1</code> protocol is more secure, so we recommend that you specify <code>SSLv3</code>
         *        only if your users are using browsers or devices that don't support <code>TLSv1</code>. Note the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify &lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt;, the
         *        minimum SSL protocol version is <code>TLSv1</code> and can't be changed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you're using a custom certificate (if you specify a value for <code>ACMCertificateArn</code> or for
         *        <code>IAMCertificateId</code>) and if you're using SNI (if you specify <code>sni-only</code> for
         *        <code>SSLSupportMethod</code>), you must specify <code>TLSv1</code> for
         *        <code>MinimumProtocolVersion</code>.
         *        </p>
         *        </li>
         * @see MinimumProtocolVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MinimumProtocolVersion
         */
        Builder minimumProtocolVersion(MinimumProtocolVersion minimumProtocolVersion);

        /**
         * <p>
         * Include one of these values to specify the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Whether you want viewers to use HTTP or HTTPS to request your objects.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you want viewers to use HTTPS, whether you're using an alternate domain name such as example.com or the
         * CloudFront domain name for your distribution, such as <code>d111111abcdef8.cloudfront.net</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you're using an alternate domain name, whether AWS Certificate Manager (ACM) provided the certificate, or
         * you purchased a certificate from a third-party certificate authority and imported it into ACM or uploaded it
         * to the IAM certificate store.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You must specify one (and only one) of the three values. Do not specify <code>false</code> for
         * <code>CloudFrontDefaultCertificate</code>.
         * </p>
         * <p>
         * <b>If you want viewers to use HTTP to request your objects</b>: Specify the following value:
         * </p>
         * <p>
         * <code>&lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt;</code>
         * </p>
         * <p>
         * In addition, specify <code>allow-all</code> for <code>ViewerProtocolPolicy</code> for all of your cache
         * behaviors.
         * </p>
         * <p>
         * <b>If you want viewers to use HTTPS to request your objects</b>: Choose the type of certificate that you want
         * to use based on whether you're using an alternate domain name for your objects or the CloudFront domain name:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>If you're using an alternate domain name, such as example.com</b>: Specify one of the following values,
         * depending on whether ACM provided your certificate or you purchased your certificate from third-party
         * certificate authority:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>&lt;ACMCertificateArn&gt;ARN for ACM SSL/TLS certificate&lt;ACMCertificateArn&gt;</code> where ARN for
         * ACM SSL/TLS certificate is the ARN for the ACM SSL/TLS certificate that you want to use for this
         * distribution.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>&lt;IAMCertificateId&gt;IAM certificate ID&lt;IAMCertificateId&gt;</code> where IAM certificate ID is
         * the ID that IAM returned when you added the certificate to the IAM certificate store.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify <code>ACMCertificateArn</code> or <code>IAMCertificateId</code>, you must also specify a value
         * for <code>SSLSupportMethod</code>.
         * </p>
         * <p>
         * If you choose to use an ACM certificate or a certificate in the IAM certificate store, we recommend that you
         * use only an alternate domain name in your object URLs (<code>https://example.com/logo.jpg</code>). If you use
         * the domain name that is associated with your CloudFront distribution (
         * <code>https://d111111abcdef8.cloudfront.net/logo.jpg</code>) and the viewer supports <code>SNI</code>, then
         * CloudFront behaves normally. However, if the browser does not support SNI, the user's experience depends on
         * the value that you choose for <code>SSLSupportMethod</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>vip</code>: The viewer displays a warning because there is a mismatch between the CloudFront domain
         * name and the domain name in your SSL/TLS certificate.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sni-only</code>: CloudFront drops the connection with the browser without returning the object.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>If you're using the CloudFront domain name for your distribution, such as
         * <code>d111111abcdef8.cloudfront.net</code> </b>: Specify the following value:
         * </p>
         * <p>
         * <code> &lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt; </code>
         * </p>
         * <p>
         * If you want viewers to use HTTPS, you must also specify one of the following values in your cache behaviors:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code> &lt;ViewerProtocolPolicy&gt;https-only&lt;ViewerProtocolPolicy&gt; </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code> &lt;ViewerProtocolPolicy&gt;redirect-to-https&lt;ViewerProtocolPolicy&gt; </code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can also optionally require that CloudFront use HTTPS to communicate with your origin by specifying one
         * of the following values for the applicable origins:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code> &lt;OriginProtocolPolicy&gt;https-only&lt;OriginProtocolPolicy&gt; </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code> &lt;OriginProtocolPolicy&gt;match-viewer&lt;OriginProtocolPolicy&gt; </code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html#CNAMEsAndHTTPS"
         * >Using Alternate Domain Names and HTTPS</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param certificate
         *        Include one of these values to specify the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Whether you want viewers to use HTTP or HTTPS to request your objects.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you want viewers to use HTTPS, whether you're using an alternate domain name such as example.com or
         *        the CloudFront domain name for your distribution, such as <code>d111111abcdef8.cloudfront.net</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you're using an alternate domain name, whether AWS Certificate Manager (ACM) provided the
         *        certificate, or you purchased a certificate from a third-party certificate authority and imported it
         *        into ACM or uploaded it to the IAM certificate store.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You must specify one (and only one) of the three values. Do not specify <code>false</code> for
         *        <code>CloudFrontDefaultCertificate</code>.
         *        </p>
         *        <p>
         *        <b>If you want viewers to use HTTP to request your objects</b>: Specify the following value:
         *        </p>
         *        <p>
         *        <code>&lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt;</code>
         *        </p>
         *        <p>
         *        In addition, specify <code>allow-all</code> for <code>ViewerProtocolPolicy</code> for all of your
         *        cache behaviors.
         *        </p>
         *        <p>
         *        <b>If you want viewers to use HTTPS to request your objects</b>: Choose the type of certificate that
         *        you want to use based on whether you're using an alternate domain name for your objects or the
         *        CloudFront domain name:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>If you're using an alternate domain name, such as example.com</b>: Specify one of the following
         *        values, depending on whether ACM provided your certificate or you purchased your certificate from
         *        third-party certificate authority:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>&lt;ACMCertificateArn&gt;ARN for ACM SSL/TLS certificate&lt;ACMCertificateArn&gt;</code> where
         *        ARN for ACM SSL/TLS certificate is the ARN for the ACM SSL/TLS certificate that you want to use for
         *        this distribution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>&lt;IAMCertificateId&gt;IAM certificate ID&lt;IAMCertificateId&gt;</code> where IAM certificate
         *        ID is the ID that IAM returned when you added the certificate to the IAM certificate store.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify <code>ACMCertificateArn</code> or <code>IAMCertificateId</code>, you must also specify
         *        a value for <code>SSLSupportMethod</code>.
         *        </p>
         *        <p>
         *        If you choose to use an ACM certificate or a certificate in the IAM certificate store, we recommend
         *        that you use only an alternate domain name in your object URLs (
         *        <code>https://example.com/logo.jpg</code>). If you use the domain name that is associated with your
         *        CloudFront distribution (<code>https://d111111abcdef8.cloudfront.net/logo.jpg</code>) and the viewer
         *        supports <code>SNI</code>, then CloudFront behaves normally. However, if the browser does not support
         *        SNI, the user's experience depends on the value that you choose for <code>SSLSupportMethod</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>vip</code>: The viewer displays a warning because there is a mismatch between the CloudFront
         *        domain name and the domain name in your SSL/TLS certificate.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sni-only</code>: CloudFront drops the connection with the browser without returning the object.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>If you're using the CloudFront domain name for your distribution, such as
         *        <code>d111111abcdef8.cloudfront.net</code> </b>: Specify the following value:
         *        </p>
         *        <p>
         *        <code> &lt;CloudFrontDefaultCertificate&gt;true&lt;CloudFrontDefaultCertificate&gt; </code>
         *        </p>
         *        <p>
         *        If you want viewers to use HTTPS, you must also specify one of the following values in your cache
         *        behaviors:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code> &lt;ViewerProtocolPolicy&gt;https-only&lt;ViewerProtocolPolicy&gt; </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code> &lt;ViewerProtocolPolicy&gt;redirect-to-https&lt;ViewerProtocolPolicy&gt; </code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can also optionally require that CloudFront use HTTPS to communicate with your origin by
         *        specifying one of the following values for the applicable origins:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code> &lt;OriginProtocolPolicy&gt;https-only&lt;OriginProtocolPolicy&gt; </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code> &lt;OriginProtocolPolicy&gt;match-viewer&lt;OriginProtocolPolicy&gt; </code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html#CNAMEsAndHTTPS"
         *        >Using Alternate Domain Names and HTTPS</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(String certificate);

        /**
         * <note>
         * <p>
         * This field is deprecated. You can use one of the following: <code>[ACMCertificateArn</code>,
         * <code>IAMCertificateId</code>, or <code>CloudFrontDefaultCertificate]</code>.
         * </p>
         * </note>
         * 
         * @param certificateSource
         *        <p>
         *        This field is deprecated. You can use one of the following: <code>[ACMCertificateArn</code>,
         *        <code>IAMCertificateId</code>, or <code>CloudFrontDefaultCertificate]</code>.
         *        </p>
         * @see CertificateSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateSource
         */
        Builder certificateSource(String certificateSource);

        /**
         * <note>
         * <p>
         * This field is deprecated. You can use one of the following: <code>[ACMCertificateArn</code>,
         * <code>IAMCertificateId</code>, or <code>CloudFrontDefaultCertificate]</code>.
         * </p>
         * </note>
         * 
         * @param certificateSource
         *        <p>
         *        This field is deprecated. You can use one of the following: <code>[ACMCertificateArn</code>,
         *        <code>IAMCertificateId</code>, or <code>CloudFrontDefaultCertificate]</code>.
         *        </p>
         * @see CertificateSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateSource
         */
        Builder certificateSource(CertificateSource certificateSource);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean cloudFrontDefaultCertificate;

        private String iamCertificateId;

        private String acmCertificateArn;

        private String sslSupportMethod;

        private String minimumProtocolVersion;

        private String certificate;

        private String certificateSource;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewerCertificate model) {
            setCloudFrontDefaultCertificate(model.cloudFrontDefaultCertificate);
            setIAMCertificateId(model.iamCertificateId);
            setACMCertificateArn(model.acmCertificateArn);
            setSSLSupportMethod(model.sslSupportMethod);
            setMinimumProtocolVersion(model.minimumProtocolVersion);
            setCertificate(model.certificate);
            setCertificateSource(model.certificateSource);
        }

        public final Boolean getCloudFrontDefaultCertificate() {
            return cloudFrontDefaultCertificate;
        }

        @Override
        public final Builder cloudFrontDefaultCertificate(Boolean cloudFrontDefaultCertificate) {
            this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
            return this;
        }

        public final void setCloudFrontDefaultCertificate(Boolean cloudFrontDefaultCertificate) {
            this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
        }

        public final String getIAMCertificateId() {
            return iamCertificateId;
        }

        @Override
        public final Builder iamCertificateId(String iamCertificateId) {
            this.iamCertificateId = iamCertificateId;
            return this;
        }

        public final void setIAMCertificateId(String iamCertificateId) {
            this.iamCertificateId = iamCertificateId;
        }

        public final String getACMCertificateArn() {
            return acmCertificateArn;
        }

        @Override
        public final Builder acmCertificateArn(String acmCertificateArn) {
            this.acmCertificateArn = acmCertificateArn;
            return this;
        }

        public final void setACMCertificateArn(String acmCertificateArn) {
            this.acmCertificateArn = acmCertificateArn;
        }

        public final String getSSLSupportMethod() {
            return sslSupportMethod;
        }

        @Override
        public final Builder sslSupportMethod(String sslSupportMethod) {
            this.sslSupportMethod = sslSupportMethod;
            return this;
        }

        @Override
        public final Builder sslSupportMethod(SSLSupportMethod sslSupportMethod) {
            this.sslSupportMethod(sslSupportMethod.toString());
            return this;
        }

        public final void setSSLSupportMethod(String sslSupportMethod) {
            this.sslSupportMethod = sslSupportMethod;
        }

        public final void setSSLSupportMethod(SSLSupportMethod sslSupportMethod) {
            this.sslSupportMethod(sslSupportMethod.toString());
        }

        public final String getMinimumProtocolVersion() {
            return minimumProtocolVersion;
        }

        @Override
        public final Builder minimumProtocolVersion(String minimumProtocolVersion) {
            this.minimumProtocolVersion = minimumProtocolVersion;
            return this;
        }

        @Override
        public final Builder minimumProtocolVersion(MinimumProtocolVersion minimumProtocolVersion) {
            this.minimumProtocolVersion(minimumProtocolVersion.toString());
            return this;
        }

        public final void setMinimumProtocolVersion(String minimumProtocolVersion) {
            this.minimumProtocolVersion = minimumProtocolVersion;
        }

        public final void setMinimumProtocolVersion(MinimumProtocolVersion minimumProtocolVersion) {
            this.minimumProtocolVersion(minimumProtocolVersion.toString());
        }

        public final String getCertificate() {
            return certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final String getCertificateSource() {
            return certificateSource;
        }

        @Override
        public final Builder certificateSource(String certificateSource) {
            this.certificateSource = certificateSource;
            return this;
        }

        @Override
        public final Builder certificateSource(CertificateSource certificateSource) {
            this.certificateSource(certificateSource.toString());
            return this;
        }

        public final void setCertificateSource(String certificateSource) {
            this.certificateSource = certificateSource;
        }

        public final void setCertificateSource(CertificateSource certificateSource) {
            this.certificateSource(certificateSource.toString());
        }

        @Override
        public ViewerCertificate build() {
            return new ViewerCertificate(this);
        }
    }
}
