/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to remove tags from a CloudFront resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UntagResourceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UntagResourceRequest.Builder, UntagResourceRequest> {
    private final String resource;

    private final TagKeys tagKeys;

    private UntagResourceRequest(BuilderImpl builder) {
        this.resource = builder.resource;
        this.tagKeys = builder.tagKeys;
    }

    /**
     * <p>
     * An ARN of a CloudFront resource.
     * </p>
     * 
     * @return An ARN of a CloudFront resource.
     */
    public String resource() {
        return resource;
    }

    /**
     * <p>
     * A complex type that contains zero or more <code>Tag</code> key elements.
     * </p>
     * 
     * @return A complex type that contains zero or more <code>Tag</code> key elements.
     */
    public TagKeys tagKeys() {
        return tagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resource() == null) ? 0 : resource().hashCode());
        hashCode = 31 * hashCode + ((tagKeys() == null) ? 0 : tagKeys().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagResourceRequest)) {
            return false;
        }
        UntagResourceRequest other = (UntagResourceRequest) obj;
        if (other.resource() == null ^ this.resource() == null) {
            return false;
        }
        if (other.resource() != null && !other.resource().equals(this.resource())) {
            return false;
        }
        if (other.tagKeys() == null ^ this.tagKeys() == null) {
            return false;
        }
        if (other.tagKeys() != null && !other.tagKeys().equals(this.tagKeys())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resource() != null) {
            sb.append("Resource: ").append(resource()).append(",");
        }
        if (tagKeys() != null) {
            sb.append("TagKeys: ").append(tagKeys()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UntagResourceRequest> {
        /**
         * <p>
         * An ARN of a CloudFront resource.
         * </p>
         * 
         * @param resource
         *        An ARN of a CloudFront resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * A complex type that contains zero or more <code>Tag</code> key elements.
         * </p>
         * 
         * @param tagKeys
         *        A complex type that contains zero or more <code>Tag</code> key elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(TagKeys tagKeys);
    }

    private static final class BuilderImpl implements Builder {
        private String resource;

        private TagKeys tagKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(UntagResourceRequest model) {
            setResource(model.resource);
            setTagKeys(model.tagKeys);
        }

        public final String getResource() {
            return resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final TagKeys getTagKeys() {
            return tagKeys;
        }

        @Override
        public final Builder tagKeys(TagKeys tagKeys) {
            this.tagKeys = tagKeys;
            return this;
        }

        public final void setTagKeys(TagKeys tagKeys) {
            this.tagKeys = tagKeys;
        }

        @Override
        public UntagResourceRequest build() {
            return new UntagResourceRequest(this);
        }
    }
}
