/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A streaming distribution Configuration and a list of tags to be associated with the streaming distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StreamingDistributionConfigWithTags implements
        ToCopyableBuilder<StreamingDistributionConfigWithTags.Builder, StreamingDistributionConfigWithTags> {
    private final StreamingDistributionConfig streamingDistributionConfig;

    private final Tags tags;

    private StreamingDistributionConfigWithTags(BuilderImpl builder) {
        this.streamingDistributionConfig = builder.streamingDistributionConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A streaming distribution Configuration.
     * </p>
     * 
     * @return A streaming distribution Configuration.
     */
    public StreamingDistributionConfig streamingDistributionConfig() {
        return streamingDistributionConfig;
    }

    /**
     * <p>
     * A complex type that contains zero or more <code>Tag</code> elements.
     * </p>
     * 
     * @return A complex type that contains zero or more <code>Tag</code> elements.
     */
    public Tags tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamingDistributionConfig() == null) ? 0 : streamingDistributionConfig().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDistributionConfigWithTags)) {
            return false;
        }
        StreamingDistributionConfigWithTags other = (StreamingDistributionConfigWithTags) obj;
        if (other.streamingDistributionConfig() == null ^ this.streamingDistributionConfig() == null) {
            return false;
        }
        if (other.streamingDistributionConfig() != null
                && !other.streamingDistributionConfig().equals(this.streamingDistributionConfig())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamingDistributionConfig() != null) {
            sb.append("StreamingDistributionConfig: ").append(streamingDistributionConfig()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, StreamingDistributionConfigWithTags> {
        /**
         * <p>
         * A streaming distribution Configuration.
         * </p>
         * 
         * @param streamingDistributionConfig
         *        A streaming distribution Configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig);

        /**
         * <p>
         * A complex type that contains zero or more <code>Tag</code> elements.
         * </p>
         * 
         * @param tags
         *        A complex type that contains zero or more <code>Tag</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tags tags);
    }

    private static final class BuilderImpl implements Builder {
        private StreamingDistributionConfig streamingDistributionConfig;

        private Tags tags;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDistributionConfigWithTags model) {
            setStreamingDistributionConfig(model.streamingDistributionConfig);
            setTags(model.tags);
        }

        public final StreamingDistributionConfig getStreamingDistributionConfig() {
            return streamingDistributionConfig;
        }

        @Override
        public final Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
            return this;
        }

        public final void setStreamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
        }

        public final Tags getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        public final void setTags(Tags tags) {
            this.tags = tags;
        }

        @Override
        public StreamingDistributionConfigWithTags build() {
            return new StreamingDistributionConfigWithTags(this);
        }
    }
}
