/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A streaming distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StreamingDistribution implements ToCopyableBuilder<StreamingDistribution.Builder, StreamingDistribution> {
    private final String id;

    private final String arn;

    private final String status;

    private final Instant lastModifiedTime;

    private final String domainName;

    private final ActiveTrustedSigners activeTrustedSigners;

    private final StreamingDistributionConfig streamingDistributionConfig;

    private StreamingDistribution(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.domainName = builder.domainName;
        this.activeTrustedSigners = builder.activeTrustedSigners;
        this.streamingDistributionConfig = builder.streamingDistributionConfig;
    }

    /**
     * <p>
     * The identifier for the RTMP distribution. For example: <code>EGTXBD79EXAMPLE</code>.
     * </p>
     * 
     * @return The identifier for the RTMP distribution. For example: <code>EGTXBD79EXAMPLE</code>.
     */
    public String id() {
        return id;
    }

    /**
     * Returns the value of the ARN property for this object.
     * 
     * @return The value of the ARN property for this object.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The current status of the RTMP distribution. When the status is <code>Deployed</code>, the distribution's
     * information is propagated to all CloudFront edge locations.
     * </p>
     * 
     * @return The current status of the RTMP distribution. When the status is <code>Deployed</code>, the distribution's
     *         information is propagated to all CloudFront edge locations.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The date and time that the distribution was last modified.
     * </p>
     * 
     * @return The date and time that the distribution was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The domain name that corresponds to the streaming distribution. For example:
     * <code>s5c39gqb8ow64r.cloudfront.net</code>.
     * </p>
     * 
     * @return The domain name that corresponds to the streaming distribution. For example:
     *         <code>s5c39gqb8ow64r.cloudfront.net</code>.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A complex type that lists the AWS accounts, if any, that you included in the <code>TrustedSigners</code> complex
     * type for this distribution. These are the accounts that you want to allow to create signed URLs for private
     * content.
     * </p>
     * <p>
     * The <code>Signer</code> complex type lists the AWS account number of the trusted signer or <code>self</code> if
     * the signer is the AWS account that created the distribution. The <code>Signer</code> element also includes the
     * IDs of any active CloudFront key pairs that are associated with the trusted signer's AWS account. If no
     * <code>KeyPairId</code> element appears for a <code>Signer</code>, that signer can't create signed URLs.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return A complex type that lists the AWS accounts, if any, that you included in the <code>TrustedSigners</code>
     *         complex type for this distribution. These are the accounts that you want to allow to create signed URLs
     *         for private content.</p>
     *         <p>
     *         The <code>Signer</code> complex type lists the AWS account number of the trusted signer or
     *         <code>self</code> if the signer is the AWS account that created the distribution. The <code>Signer</code>
     *         element also includes the IDs of any active CloudFront key pairs that are associated with the trusted
     *         signer's AWS account. If no <code>KeyPairId</code> element appears for a <code>Signer</code>, that signer
     *         can't create signed URLs.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
     *         Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public ActiveTrustedSigners activeTrustedSigners() {
        return activeTrustedSigners;
    }

    /**
     * <p>
     * The current configuration information for the RTMP distribution.
     * </p>
     * 
     * @return The current configuration information for the RTMP distribution.
     */
    public StreamingDistributionConfig streamingDistributionConfig() {
        return streamingDistributionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((lastModifiedTime() == null) ? 0 : lastModifiedTime().hashCode());
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        hashCode = 31 * hashCode + ((activeTrustedSigners() == null) ? 0 : activeTrustedSigners().hashCode());
        hashCode = 31 * hashCode + ((streamingDistributionConfig() == null) ? 0 : streamingDistributionConfig().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDistribution)) {
            return false;
        }
        StreamingDistribution other = (StreamingDistribution) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.lastModifiedTime() == null ^ this.lastModifiedTime() == null) {
            return false;
        }
        if (other.lastModifiedTime() != null && !other.lastModifiedTime().equals(this.lastModifiedTime())) {
            return false;
        }
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.activeTrustedSigners() == null ^ this.activeTrustedSigners() == null) {
            return false;
        }
        if (other.activeTrustedSigners() != null && !other.activeTrustedSigners().equals(this.activeTrustedSigners())) {
            return false;
        }
        if (other.streamingDistributionConfig() == null ^ this.streamingDistributionConfig() == null) {
            return false;
        }
        if (other.streamingDistributionConfig() != null
                && !other.streamingDistributionConfig().equals(this.streamingDistributionConfig())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (arn() != null) {
            sb.append("ARN: ").append(arn()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (lastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(lastModifiedTime()).append(",");
        }
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (activeTrustedSigners() != null) {
            sb.append("ActiveTrustedSigners: ").append(activeTrustedSigners()).append(",");
        }
        if (streamingDistributionConfig() != null) {
            sb.append("StreamingDistributionConfig: ").append(streamingDistributionConfig()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, StreamingDistribution> {
        /**
         * <p>
         * The identifier for the RTMP distribution. For example: <code>EGTXBD79EXAMPLE</code>.
         * </p>
         * 
         * @param id
         *        The identifier for the RTMP distribution. For example: <code>EGTXBD79EXAMPLE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the ARN property for this object.
         *
         * @param arn
         *        The new value for the ARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The current status of the RTMP distribution. When the status is <code>Deployed</code>, the distribution's
         * information is propagated to all CloudFront edge locations.
         * </p>
         * 
         * @param status
         *        The current status of the RTMP distribution. When the status is <code>Deployed</code>, the
         *        distribution's information is propagated to all CloudFront edge locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time that the distribution was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the distribution was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The domain name that corresponds to the streaming distribution. For example:
         * <code>s5c39gqb8ow64r.cloudfront.net</code>.
         * </p>
         * 
         * @param domainName
         *        The domain name that corresponds to the streaming distribution. For example:
         *        <code>s5c39gqb8ow64r.cloudfront.net</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A complex type that lists the AWS accounts, if any, that you included in the <code>TrustedSigners</code>
         * complex type for this distribution. These are the accounts that you want to allow to create signed URLs for
         * private content.
         * </p>
         * <p>
         * The <code>Signer</code> complex type lists the AWS account number of the trusted signer or <code>self</code>
         * if the signer is the AWS account that created the distribution. The <code>Signer</code> element also includes
         * the IDs of any active CloudFront key pairs that are associated with the trusted signer's AWS account. If no
         * <code>KeyPairId</code> element appears for a <code>Signer</code>, that signer can't create signed URLs.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param activeTrustedSigners
         *        A complex type that lists the AWS accounts, if any, that you included in the
         *        <code>TrustedSigners</code> complex type for this distribution. These are the accounts that you want
         *        to allow to create signed URLs for private content.</p>
         *        <p>
         *        The <code>Signer</code> complex type lists the AWS account number of the trusted signer or
         *        <code>self</code> if the signer is the AWS account that created the distribution. The
         *        <code>Signer</code> element also includes the IDs of any active CloudFront key pairs that are
         *        associated with the trusted signer's AWS account. If no <code>KeyPairId</code> element appears for a
         *        <code>Signer</code>, that signer can't create signed URLs.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
         *        Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeTrustedSigners(ActiveTrustedSigners activeTrustedSigners);

        /**
         * <p>
         * The current configuration information for the RTMP distribution.
         * </p>
         * 
         * @param streamingDistributionConfig
         *        The current configuration information for the RTMP distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String status;

        private Instant lastModifiedTime;

        private String domainName;

        private ActiveTrustedSigners activeTrustedSigners;

        private StreamingDistributionConfig streamingDistributionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDistribution model) {
            setId(model.id);
            setARN(model.arn);
            setStatus(model.status);
            setLastModifiedTime(model.lastModifiedTime);
            setDomainName(model.domainName);
            setActiveTrustedSigners(model.activeTrustedSigners);
            setStreamingDistributionConfig(model.streamingDistributionConfig);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getARN() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final ActiveTrustedSigners getActiveTrustedSigners() {
            return activeTrustedSigners;
        }

        @Override
        public final Builder activeTrustedSigners(ActiveTrustedSigners activeTrustedSigners) {
            this.activeTrustedSigners = activeTrustedSigners;
            return this;
        }

        public final void setActiveTrustedSigners(ActiveTrustedSigners activeTrustedSigners) {
            this.activeTrustedSigners = activeTrustedSigners;
        }

        public final StreamingDistributionConfig getStreamingDistributionConfig() {
            return streamingDistributionConfig;
        }

        @Override
        public final Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
            return this;
        }

        public final void setStreamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
        }

        @Override
        public StreamingDistribution build() {
            return new StreamingDistribution(this);
        }
    }
}
