/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListStreamingDistributionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListStreamingDistributionsResponse.Builder, ListStreamingDistributionsResponse> {
    private final StreamingDistributionList streamingDistributionList;

    private ListStreamingDistributionsResponse(BuilderImpl builder) {
        this.streamingDistributionList = builder.streamingDistributionList;
    }

    /**
     * <p>
     * The <code>StreamingDistributionList</code> type.
     * </p>
     * 
     * @return The <code>StreamingDistributionList</code> type.
     */
    public StreamingDistributionList streamingDistributionList() {
        return streamingDistributionList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamingDistributionList() == null) ? 0 : streamingDistributionList().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamingDistributionsResponse)) {
            return false;
        }
        ListStreamingDistributionsResponse other = (ListStreamingDistributionsResponse) obj;
        if (other.streamingDistributionList() == null ^ this.streamingDistributionList() == null) {
            return false;
        }
        if (other.streamingDistributionList() != null
                && !other.streamingDistributionList().equals(this.streamingDistributionList())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamingDistributionList() != null) {
            sb.append("StreamingDistributionList: ").append(streamingDistributionList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListStreamingDistributionsResponse> {
        /**
         * <p>
         * The <code>StreamingDistributionList</code> type.
         * </p>
         * 
         * @param streamingDistributionList
         *        The <code>StreamingDistributionList</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistributionList(StreamingDistributionList streamingDistributionList);
    }

    private static final class BuilderImpl implements Builder {
        private StreamingDistributionList streamingDistributionList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamingDistributionsResponse model) {
            setStreamingDistributionList(model.streamingDistributionList);
        }

        public final StreamingDistributionList getStreamingDistributionList() {
            return streamingDistributionList;
        }

        @Override
        public final Builder streamingDistributionList(StreamingDistributionList streamingDistributionList) {
            this.streamingDistributionList = streamingDistributionList;
            return this;
        }

        public final void setStreamingDistributionList(StreamingDistributionList streamingDistributionList) {
            this.streamingDistributionList = streamingDistributionList;
        }

        @Override
        public ListStreamingDistributionsResponse build() {
            return new ListStreamingDistributionsResponse(this);
        }
    }
}
