/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to list your streaming distributions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListStreamingDistributionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListStreamingDistributionsRequest.Builder, ListStreamingDistributionsRequest> {
    private final String marker;

    private final String maxItems;

    private ListStreamingDistributionsRequest(BuilderImpl builder) {
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The value that you provided for the <code>Marker</code> request parameter.
     * </p>
     * 
     * @return The value that you provided for the <code>Marker</code> request parameter.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The value that you provided for the <code>MaxItems</code> request parameter.
     * </p>
     * 
     * @return The value that you provided for the <code>MaxItems</code> request parameter.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((marker() == null) ? 0 : marker().hashCode());
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamingDistributionsRequest)) {
            return false;
        }
        ListStreamingDistributionsRequest other = (ListStreamingDistributionsRequest) obj;
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListStreamingDistributionsRequest> {
        /**
         * <p>
         * The value that you provided for the <code>Marker</code> request parameter.
         * </p>
         * 
         * @param marker
         *        The value that you provided for the <code>Marker</code> request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The value that you provided for the <code>MaxItems</code> request parameter.
         * </p>
         * 
         * @param maxItems
         *        The value that you provided for the <code>MaxItems</code> request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    private static final class BuilderImpl implements Builder {
        private String marker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamingDistributionsRequest model) {
            setMarker(model.marker);
            setMaxItems(model.maxItems);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListStreamingDistributionsRequest build() {
            return new ListStreamingDistributionsRequest(this);
        }
    }
}
