/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An invalidation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Invalidation implements ToCopyableBuilder<Invalidation.Builder, Invalidation> {
    private final String id;

    private final String status;

    private final Instant createTime;

    private final InvalidationBatch invalidationBatch;

    private Invalidation(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.createTime = builder.createTime;
        this.invalidationBatch = builder.invalidationBatch;
    }

    /**
     * <p>
     * The identifier for the invalidation request. For example: <code>IDFDVBD632BHDS5</code>.
     * </p>
     * 
     * @return The identifier for the invalidation request. For example: <code>IDFDVBD632BHDS5</code>.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The status of the invalidation request. When the invalidation batch is finished, the status is
     * <code>Completed</code>.
     * </p>
     * 
     * @return The status of the invalidation request. When the invalidation batch is finished, the status is
     *         <code>Completed</code>.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The date and time the invalidation request was first made.
     * </p>
     * 
     * @return The date and time the invalidation request was first made.
     */
    public Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The current invalidation information for the batch request.
     * </p>
     * 
     * @return The current invalidation information for the batch request.
     */
    public InvalidationBatch invalidationBatch() {
        return invalidationBatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((createTime() == null) ? 0 : createTime().hashCode());
        hashCode = 31 * hashCode + ((invalidationBatch() == null) ? 0 : invalidationBatch().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Invalidation)) {
            return false;
        }
        Invalidation other = (Invalidation) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.createTime() == null ^ this.createTime() == null) {
            return false;
        }
        if (other.createTime() != null && !other.createTime().equals(this.createTime())) {
            return false;
        }
        if (other.invalidationBatch() == null ^ this.invalidationBatch() == null) {
            return false;
        }
        if (other.invalidationBatch() != null && !other.invalidationBatch().equals(this.invalidationBatch())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (createTime() != null) {
            sb.append("CreateTime: ").append(createTime()).append(",");
        }
        if (invalidationBatch() != null) {
            sb.append("InvalidationBatch: ").append(invalidationBatch()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Invalidation> {
        /**
         * <p>
         * The identifier for the invalidation request. For example: <code>IDFDVBD632BHDS5</code>.
         * </p>
         * 
         * @param id
         *        The identifier for the invalidation request. For example: <code>IDFDVBD632BHDS5</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status of the invalidation request. When the invalidation batch is finished, the status is
         * <code>Completed</code>.
         * </p>
         * 
         * @param status
         *        The status of the invalidation request. When the invalidation batch is finished, the status is
         *        <code>Completed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time the invalidation request was first made.
         * </p>
         * 
         * @param createTime
         *        The date and time the invalidation request was first made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The current invalidation information for the batch request.
         * </p>
         * 
         * @param invalidationBatch
         *        The current invalidation information for the batch request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidationBatch(InvalidationBatch invalidationBatch);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String status;

        private Instant createTime;

        private InvalidationBatch invalidationBatch;

        private BuilderImpl() {
        }

        private BuilderImpl(Invalidation model) {
            setId(model.id);
            setStatus(model.status);
            setCreateTime(model.createTime);
            setInvalidationBatch(model.invalidationBatch);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final InvalidationBatch getInvalidationBatch() {
            return invalidationBatch;
        }

        @Override
        public final Builder invalidationBatch(InvalidationBatch invalidationBatch) {
            this.invalidationBatch = invalidationBatch;
            return this;
        }

        public final void setInvalidationBatch(InvalidationBatch invalidationBatch) {
            this.invalidationBatch = invalidationBatch;
        }

        @Override
        public Invalidation build() {
            return new Invalidation(this);
        }
    }
}
