/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInvalidationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetInvalidationResponse.Builder, GetInvalidationResponse> {
    private final Invalidation invalidation;

    private GetInvalidationResponse(BuilderImpl builder) {
        this.invalidation = builder.invalidation;
    }

    /**
     * <p>
     * The invalidation's information. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/InvalidationDatatype.html">Invalidation
     * Complex Type</a>.
     * </p>
     * 
     * @return The invalidation's information. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/InvalidationDatatype.html"
     *         >Invalidation Complex Type</a>.
     */
    public Invalidation invalidation() {
        return invalidation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((invalidation() == null) ? 0 : invalidation().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInvalidationResponse)) {
            return false;
        }
        GetInvalidationResponse other = (GetInvalidationResponse) obj;
        if (other.invalidation() == null ^ this.invalidation() == null) {
            return false;
        }
        if (other.invalidation() != null && !other.invalidation().equals(this.invalidation())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (invalidation() != null) {
            sb.append("Invalidation: ").append(invalidation()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetInvalidationResponse> {
        /**
         * <p>
         * The invalidation's information. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/InvalidationDatatype.html"
         * >Invalidation Complex Type</a>.
         * </p>
         * 
         * @param invalidation
         *        The invalidation's information. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/InvalidationDatatype.html"
         *        >Invalidation Complex Type</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidation(Invalidation invalidation);
    }

    private static final class BuilderImpl implements Builder {
        private Invalidation invalidation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInvalidationResponse model) {
            setInvalidation(model.invalidation);
        }

        public final Invalidation getInvalidation() {
            return invalidation;
        }

        @Override
        public final Builder invalidation(Invalidation invalidation) {
            this.invalidation = invalidation;
            return this;
        }

        public final void setInvalidation(Invalidation invalidation) {
            this.invalidation = invalidation;
        }

        @Override
        public GetInvalidationResponse build() {
            return new GetInvalidationResponse(this);
        }
    }
}
