/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetCloudFrontOriginAccessIdentityConfigResponse extends AmazonWebServiceResult<ResponseMetadata>
        implements
        ToCopyableBuilder<GetCloudFrontOriginAccessIdentityConfigResponse.Builder, GetCloudFrontOriginAccessIdentityConfigResponse> {
    private final CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

    private final String eTag;

    private GetCloudFrontOriginAccessIdentityConfigResponse(BuilderImpl builder) {
        this.cloudFrontOriginAccessIdentityConfig = builder.cloudFrontOriginAccessIdentityConfig;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The origin access identity's configuration information.
     * </p>
     * 
     * @return The origin access identity's configuration information.
     */
    public CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig() {
        return cloudFrontOriginAccessIdentityConfig;
    }

    /**
     * <p>
     * The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + ((cloudFrontOriginAccessIdentityConfig() == null) ? 0 : cloudFrontOriginAccessIdentityConfig().hashCode());
        hashCode = 31 * hashCode + ((eTag() == null) ? 0 : eTag().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCloudFrontOriginAccessIdentityConfigResponse)) {
            return false;
        }
        GetCloudFrontOriginAccessIdentityConfigResponse other = (GetCloudFrontOriginAccessIdentityConfigResponse) obj;
        if (other.cloudFrontOriginAccessIdentityConfig() == null ^ this.cloudFrontOriginAccessIdentityConfig() == null) {
            return false;
        }
        if (other.cloudFrontOriginAccessIdentityConfig() != null
                && !other.cloudFrontOriginAccessIdentityConfig().equals(this.cloudFrontOriginAccessIdentityConfig())) {
            return false;
        }
        if (other.eTag() == null ^ this.eTag() == null) {
            return false;
        }
        if (other.eTag() != null && !other.eTag().equals(this.eTag())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (cloudFrontOriginAccessIdentityConfig() != null) {
            sb.append("CloudFrontOriginAccessIdentityConfig: ").append(cloudFrontOriginAccessIdentityConfig()).append(",");
        }
        if (eTag() != null) {
            sb.append("ETag: ").append(eTag()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetCloudFrontOriginAccessIdentityConfigResponse> {
        /**
         * <p>
         * The origin access identity's configuration information.
         * </p>
         * 
         * @param cloudFrontOriginAccessIdentityConfig
         *        The origin access identity's configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig);

        /**
         * <p>
         * The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param eTag
         *        The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    private static final class BuilderImpl implements Builder {
        private CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCloudFrontOriginAccessIdentityConfigResponse model) {
            setCloudFrontOriginAccessIdentityConfig(model.cloudFrontOriginAccessIdentityConfig);
            setETag(model.eTag);
        }

        public final CloudFrontOriginAccessIdentityConfig getCloudFrontOriginAccessIdentityConfig() {
            return cloudFrontOriginAccessIdentityConfig;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentityConfig(
                CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
            return this;
        }

        public final void setCloudFrontOriginAccessIdentityConfig(
                CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public GetCloudFrontOriginAccessIdentityConfigResponse build() {
            return new GetCloudFrontOriginAccessIdentityConfigResponse(this);
        }
    }
}
