/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that specifies how CloudFront handles query strings and cookies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ForwardedValues implements ToCopyableBuilder<ForwardedValues.Builder, ForwardedValues> {
    private final Boolean queryString;

    private final CookiePreference cookies;

    private final Headers headers;

    private final QueryStringCacheKeys queryStringCacheKeys;

    private ForwardedValues(BuilderImpl builder) {
        this.queryString = builder.queryString;
        this.cookies = builder.cookies;
        this.headers = builder.headers;
        this.queryStringCacheKeys = builder.queryStringCacheKeys;
    }

    /**
     * <p>
     * Indicates whether you want CloudFront to forward query strings to the origin that is associated with this cache
     * behavior and cache based on the query string parameters. CloudFront behavior depends on the value of
     * <code>QueryString</code> and on the values that you specify for <code>QueryStringCacheKeys</code>, if any:
     * </p>
     * <p>
     * If you specify true for <code>QueryString</code> and you don't specify any values for
     * <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin and caches based
     * on all query string parameters. Depending on how many query string parameters and values you have, this can
     * adversely affect performance because CloudFront must forward more requests to the origin.
     * </p>
     * <p>
     * If you specify true for <code>QueryString</code> and you specify one or more values for
     * <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin, but it only
     * caches based on the query string parameters that you specify.
     * </p>
     * <p>
     * If you specify false for <code>QueryString</code>, CloudFront doesn't forward any query string parameters to the
     * origin, and doesn't cache based on query string parameters.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html">Configuring
     * CloudFront to Cache Based on Query String Parameters</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return Indicates whether you want CloudFront to forward query strings to the origin that is associated with this
     *         cache behavior and cache based on the query string parameters. CloudFront behavior depends on the value
     *         of <code>QueryString</code> and on the values that you specify for <code>QueryStringCacheKeys</code>, if
     *         any:</p>
     *         <p>
     *         If you specify true for <code>QueryString</code> and you don't specify any values for
     *         <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin and
     *         caches based on all query string parameters. Depending on how many query string parameters and values you
     *         have, this can adversely affect performance because CloudFront must forward more requests to the origin.
     *         </p>
     *         <p>
     *         If you specify true for <code>QueryString</code> and you specify one or more values for
     *         <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin, but it
     *         only caches based on the query string parameters that you specify.
     *         </p>
     *         <p>
     *         If you specify false for <code>QueryString</code>, CloudFront doesn't forward any query string parameters
     *         to the origin, and doesn't cache based on query string parameters.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html"
     *         >Configuring CloudFront to Cache Based on Query String Parameters</a> in the <i>Amazon CloudFront
     *         Developer Guide</i>.
     */
    public Boolean queryString() {
        return queryString;
    }

    /**
     * <p>
     * A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which
     * ones. For more information about forwarding cookies to the origin, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront Forwards,
     * Caches, and Logs Cookies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so,
     *         which ones. For more information about forwarding cookies to the origin, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront
     *         Forwards, Caches, and Logs Cookies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public CookiePreference cookies() {
        return cookies;
    }

    /**
     * <p>
     * A complex type that specifies the <code>Headers</code>, if any, that you want CloudFront to vary upon for this
     * cache behavior.
     * </p>
     * 
     * @return A complex type that specifies the <code>Headers</code>, if any, that you want CloudFront to vary upon for
     *         this cache behavior.
     */
    public Headers headers() {
        return headers;
    }

    /**
     * <p>
     * A complex type that contains information about the query string parameters that you want CloudFront to use for
     * caching for this cache behavior.
     * </p>
     * 
     * @return A complex type that contains information about the query string parameters that you want CloudFront to
     *         use for caching for this cache behavior.
     */
    public QueryStringCacheKeys queryStringCacheKeys() {
        return queryStringCacheKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((queryString() == null) ? 0 : queryString().hashCode());
        hashCode = 31 * hashCode + ((cookies() == null) ? 0 : cookies().hashCode());
        hashCode = 31 * hashCode + ((headers() == null) ? 0 : headers().hashCode());
        hashCode = 31 * hashCode + ((queryStringCacheKeys() == null) ? 0 : queryStringCacheKeys().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForwardedValues)) {
            return false;
        }
        ForwardedValues other = (ForwardedValues) obj;
        if (other.queryString() == null ^ this.queryString() == null) {
            return false;
        }
        if (other.queryString() != null && !other.queryString().equals(this.queryString())) {
            return false;
        }
        if (other.cookies() == null ^ this.cookies() == null) {
            return false;
        }
        if (other.cookies() != null && !other.cookies().equals(this.cookies())) {
            return false;
        }
        if (other.headers() == null ^ this.headers() == null) {
            return false;
        }
        if (other.headers() != null && !other.headers().equals(this.headers())) {
            return false;
        }
        if (other.queryStringCacheKeys() == null ^ this.queryStringCacheKeys() == null) {
            return false;
        }
        if (other.queryStringCacheKeys() != null && !other.queryStringCacheKeys().equals(this.queryStringCacheKeys())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (queryString() != null) {
            sb.append("QueryString: ").append(queryString()).append(",");
        }
        if (cookies() != null) {
            sb.append("Cookies: ").append(cookies()).append(",");
        }
        if (headers() != null) {
            sb.append("Headers: ").append(headers()).append(",");
        }
        if (queryStringCacheKeys() != null) {
            sb.append("QueryStringCacheKeys: ").append(queryStringCacheKeys()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ForwardedValues> {
        /**
         * <p>
         * Indicates whether you want CloudFront to forward query strings to the origin that is associated with this
         * cache behavior and cache based on the query string parameters. CloudFront behavior depends on the value of
         * <code>QueryString</code> and on the values that you specify for <code>QueryStringCacheKeys</code>, if any:
         * </p>
         * <p>
         * If you specify true for <code>QueryString</code> and you don't specify any values for
         * <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin and caches
         * based on all query string parameters. Depending on how many query string parameters and values you have, this
         * can adversely affect performance because CloudFront must forward more requests to the origin.
         * </p>
         * <p>
         * If you specify true for <code>QueryString</code> and you specify one or more values for
         * <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin, but it only
         * caches based on the query string parameters that you specify.
         * </p>
         * <p>
         * If you specify false for <code>QueryString</code>, CloudFront doesn't forward any query string parameters to
         * the origin, and doesn't cache based on query string parameters.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html"
         * >Configuring CloudFront to Cache Based on Query String Parameters</a> in the <i>Amazon CloudFront Developer
         * Guide</i>.
         * </p>
         * 
         * @param queryString
         *        Indicates whether you want CloudFront to forward query strings to the origin that is associated with
         *        this cache behavior and cache based on the query string parameters. CloudFront behavior depends on the
         *        value of <code>QueryString</code> and on the values that you specify for
         *        <code>QueryStringCacheKeys</code>, if any:</p>
         *        <p>
         *        If you specify true for <code>QueryString</code> and you don't specify any values for
         *        <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin and
         *        caches based on all query string parameters. Depending on how many query string parameters and values
         *        you have, this can adversely affect performance because CloudFront must forward more requests to the
         *        origin.
         *        </p>
         *        <p>
         *        If you specify true for <code>QueryString</code> and you specify one or more values for
         *        <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin, but
         *        it only caches based on the query string parameters that you specify.
         *        </p>
         *        <p>
         *        If you specify false for <code>QueryString</code>, CloudFront doesn't forward any query string
         *        parameters to the origin, and doesn't cache based on query string parameters.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html"
         *        >Configuring CloudFront to Cache Based on Query String Parameters</a> in the <i>Amazon CloudFront
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(Boolean queryString);

        /**
         * <p>
         * A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which
         * ones. For more information about forwarding cookies to the origin, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront
         * Forwards, Caches, and Logs Cookies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param cookies
         *        A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so,
         *        which ones. For more information about forwarding cookies to the origin, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront
         *        Forwards, Caches, and Logs Cookies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cookies(CookiePreference cookies);

        /**
         * <p>
         * A complex type that specifies the <code>Headers</code>, if any, that you want CloudFront to vary upon for
         * this cache behavior.
         * </p>
         * 
         * @param headers
         *        A complex type that specifies the <code>Headers</code>, if any, that you want CloudFront to vary upon
         *        for this cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Headers headers);

        /**
         * <p>
         * A complex type that contains information about the query string parameters that you want CloudFront to use
         * for caching for this cache behavior.
         * </p>
         * 
         * @param queryStringCacheKeys
         *        A complex type that contains information about the query string parameters that you want CloudFront to
         *        use for caching for this cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStringCacheKeys(QueryStringCacheKeys queryStringCacheKeys);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean queryString;

        private CookiePreference cookies;

        private Headers headers;

        private QueryStringCacheKeys queryStringCacheKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(ForwardedValues model) {
            setQueryString(model.queryString);
            setCookies(model.cookies);
            setHeaders(model.headers);
            setQueryStringCacheKeys(model.queryStringCacheKeys);
        }

        public final Boolean getQueryString() {
            return queryString;
        }

        @Override
        public final Builder queryString(Boolean queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(Boolean queryString) {
            this.queryString = queryString;
        }

        public final CookiePreference getCookies() {
            return cookies;
        }

        @Override
        public final Builder cookies(CookiePreference cookies) {
            this.cookies = cookies;
            return this;
        }

        public final void setCookies(CookiePreference cookies) {
            this.cookies = cookies;
        }

        public final Headers getHeaders() {
            return headers;
        }

        @Override
        public final Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public final void setHeaders(Headers headers) {
            this.headers = headers;
        }

        public final QueryStringCacheKeys getQueryStringCacheKeys() {
            return queryStringCacheKeys;
        }

        @Override
        public final Builder queryStringCacheKeys(QueryStringCacheKeys queryStringCacheKeys) {
            this.queryStringCacheKeys = queryStringCacheKeys;
            return this;
        }

        public final void setQueryStringCacheKeys(QueryStringCacheKeys queryStringCacheKeys) {
            this.queryStringCacheKeys = queryStringCacheKeys;
        }

        @Override
        public ForwardedValues build() {
            return new ForwardedValues(this);
        }
    }
}
