/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that describes the default cache behavior if you do not specify a <code>CacheBehavior</code> element
 * or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code> elements. You
 * must create exactly one default cache behavior.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DefaultCacheBehavior implements ToCopyableBuilder<DefaultCacheBehavior.Builder, DefaultCacheBehavior> {
    private final String targetOriginId;

    private final ForwardedValues forwardedValues;

    private final TrustedSigners trustedSigners;

    private final String viewerProtocolPolicy;

    private final Long minTTL;

    private final AllowedMethods allowedMethods;

    private final Boolean smoothStreaming;

    private final Long defaultTTL;

    private final Long maxTTL;

    private final Boolean compress;

    private final LambdaFunctionAssociations lambdaFunctionAssociations;

    private DefaultCacheBehavior(BuilderImpl builder) {
        this.targetOriginId = builder.targetOriginId;
        this.forwardedValues = builder.forwardedValues;
        this.trustedSigners = builder.trustedSigners;
        this.viewerProtocolPolicy = builder.viewerProtocolPolicy;
        this.minTTL = builder.minTTL;
        this.allowedMethods = builder.allowedMethods;
        this.smoothStreaming = builder.smoothStreaming;
        this.defaultTTL = builder.defaultTTL;
        this.maxTTL = builder.maxTTL;
        this.compress = builder.compress;
        this.lambdaFunctionAssociations = builder.lambdaFunctionAssociations;
    }

    /**
     * <p>
     * The value of <code>ID</code> for the origin that you want CloudFront to route requests to when a request matches
     * the path pattern either for a cache behavior or for the default cache behavior.
     * </p>
     * 
     * @return The value of <code>ID</code> for the origin that you want CloudFront to route requests to when a request
     *         matches the path pattern either for a cache behavior or for the default cache behavior.
     */
    public String targetOriginId() {
        return targetOriginId;
    }

    /**
     * <p>
     * A complex type that specifies how CloudFront handles query strings and cookies.
     * </p>
     * 
     * @return A complex type that specifies how CloudFront handles query strings and cookies.
     */
    public ForwardedValues forwardedValues() {
        return forwardedValues;
    }

    /**
     * <p>
     * A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs for private
     * content.
     * </p>
     * <p>
     * If you want to require signed URLs in requests for objects in the target origin that match the
     * <code>PathPattern</code> for this cache behavior, specify <code>true</code> for <code>Enabled</code>, and specify
     * the applicable values for <code>Quantity</code> and <code>Items</code>. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * If you don't want to require signed URLs in requests for objects that match <code>PathPattern</code>, specify
     * <code>false</code> for <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit <code>Items</code>
     * .
     * </p>
     * <p>
     * To add, change, or remove one or more trusted signers, change <code>Enabled</code> to <code>true</code> (if it's
     * currently <code>false</code>), change <code>Quantity</code> as applicable, and specify all of the trusted signers
     * that you want to include in the updated distribution.
     * </p>
     * 
     * @return A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs for
     *         private content.</p>
     *         <p>
     *         If you want to require signed URLs in requests for objects in the target origin that match the
     *         <code>PathPattern</code> for this cache behavior, specify <code>true</code> for <code>Enabled</code>, and
     *         specify the applicable values for <code>Quantity</code> and <code>Items</code>. For more information, see
     *         <a href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
     *         Private Content through CloudFront</a> in the <i>Amazon Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         If you don't want to require signed URLs in requests for objects that match <code>PathPattern</code>,
     *         specify <code>false</code> for <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit
     *         <code>Items</code>.
     *         </p>
     *         <p>
     *         To add, change, or remove one or more trusted signers, change <code>Enabled</code> to <code>true</code>
     *         (if it's currently <code>false</code>), change <code>Quantity</code> as applicable, and specify all of
     *         the trusted signers that you want to include in the updated distribution.
     */
    public TrustedSigners trustedSigners() {
        return trustedSigners;
    }

    /**
     * <p>
     * The protocol that viewers can use to access the files in the origin specified by <code>TargetOriginId</code> when
     * a request matches the path pattern in <code>PathPattern</code>. You can specify the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>allow-all</code>: Viewers can use HTTP or HTTPS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of
     * 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the
     * new URL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403
     * (Forbidden).
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about requiring the HTTPS protocol, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html">Using an HTTPS
     * Connection to Access Your Objects</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never
     * to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that
     * you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will
     * return an object from the cache regardless of whether the current request protocol matches the protocol used
     * previously. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Specifying How Long
     * Objects and Errors Stay in a CloudFront Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer
     * Guide</i>.
     * </p>
     * </note>
     * 
     * @return The protocol that viewers can use to access the files in the origin specified by
     *         <code>TargetOriginId</code> when a request matches the path pattern in <code>PathPattern</code>. You can
     *         specify the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>allow-all</code>: Viewers can use HTTP or HTTPS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status
     *         code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the
     *         request using the new URL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403
     *         (Forbidden).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about requiring the HTTPS protocol, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html">Using an
     *         HTTPS Connection to Access Your Objects</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is
     *         never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we
     *         recommend that you clear your objects' cache because cached objects are protocol agnostic. That means
     *         that an edge location will return an object from the cache regardless of whether the current request
     *         protocol matches the protocol used previously. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Specifying How
     *         Long Objects and Errors Stay in a CloudFront Edge Cache (Expiration)</a> in the <i>Amazon CloudFront
     *         Developer Guide</i>.
     *         </p>
     * @see ViewerProtocolPolicy
     */
    public String viewerProtocolPolicy() {
        return viewerProtocolPolicy;
    }

    /**
     * <p>
     * The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another
     * request to your origin to determine whether the object has been updated. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Specifying How Long
     * Objects and Errors Stay in a CloudFront Edge Cache (Expiration)</a> in the <i>Amazon Amazon CloudFront Developer
     * Guide</i>.
     * </p>
     * <p>
     * You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all headers to
     * your origin (under <code>Headers</code>, if you specify <code>1</code> for <code>Quantity</code> and
     * <code>*</code> for <code>Name</code>).
     * </p>
     * 
     * @return The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards
     *         another request to your origin to determine whether the object has been updated. For more information,
     *         see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Specifying How
     *         Long Objects and Errors Stay in a CloudFront Edge Cache (Expiration)</a> in the <i>Amazon Amazon
     *         CloudFront Developer Guide</i>.</p>
     *         <p>
     *         You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all
     *         headers to your origin (under <code>Headers</code>, if you specify <code>1</code> for
     *         <code>Quantity</code> and <code>*</code> for <code>Name</code>).
     */
    public Long minTTL() {
        return minTTL;
    }

    /**
     * Returns the value of the AllowedMethods property for this object.
     * 
     * @return The value of the AllowedMethods property for this object.
     */
    public AllowedMethods allowedMethods() {
        return allowedMethods;
    }

    /**
     * <p>
     * Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin
     * that is associated with this cache behavior. If so, specify <code>true</code>; if not, specify <code>false</code>
     * . If you specify <code>true</code> for <code>SmoothStreaming</code>, you can still distribute other content using
     * this cache behavior if the content matches the value of <code>PathPattern</code>.
     * </p>
     * 
     * @return Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the
     *         origin that is associated with this cache behavior. If so, specify <code>true</code>; if not, specify
     *         <code>false</code>. If you specify <code>true</code> for <code>SmoothStreaming</code>, you can still
     *         distribute other content using this cache behavior if the content matches the value of
     *         <code>PathPattern</code>.
     */
    public Boolean smoothStreaming() {
        return smoothStreaming;
    }

    /**
     * <p>
     * The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another
     * request to your origin to determine whether the object has been updated. The value that you specify applies only
     * when your origin does not add HTTP headers such as <code>Cache-Control max-age</code>,
     * <code>Cache-Control s-maxage</code>, and <code>Expires</code> to objects. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Specifying How Long
     * Objects and Errors Stay in a CloudFront Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer
     * Guide</i>.
     * </p>
     * 
     * @return The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards
     *         another request to your origin to determine whether the object has been updated. The value that you
     *         specify applies only when your origin does not add HTTP headers such as
     *         <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and <code>Expires</code> to
     *         objects. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Specifying How
     *         Long Objects and Errors Stay in a CloudFront Edge Cache (Expiration)</a> in the <i>Amazon CloudFront
     *         Developer Guide</i>.
     */
    public Long defaultTTL() {
        return defaultTTL;
    }

    /**
     * Returns the value of the MaxTTL property for this object.
     * 
     * @return The value of the MaxTTL property for this object.
     */
    public Long maxTTL() {
        return maxTTL;
    }

    /**
     * <p>
     * Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify
     * <code>true</code>; if not, specify <code>false</code>. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving
     * Compressed Files</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return Whether you want CloudFront to automatically compress certain files for this cache behavior. If so,
     *         specify <code>true</code>; if not, specify <code>false</code>. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html"
     *         >Serving Compressed Files</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public Boolean compress() {
        return compress;
    }

    /**
     * <p>
     * A complex type that contains zero or more Lambda function associations for a cache behavior.
     * </p>
     * 
     * @return A complex type that contains zero or more Lambda function associations for a cache behavior.
     */
    public LambdaFunctionAssociations lambdaFunctionAssociations() {
        return lambdaFunctionAssociations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((targetOriginId() == null) ? 0 : targetOriginId().hashCode());
        hashCode = 31 * hashCode + ((forwardedValues() == null) ? 0 : forwardedValues().hashCode());
        hashCode = 31 * hashCode + ((trustedSigners() == null) ? 0 : trustedSigners().hashCode());
        hashCode = 31 * hashCode + ((viewerProtocolPolicy() == null) ? 0 : viewerProtocolPolicy().hashCode());
        hashCode = 31 * hashCode + ((minTTL() == null) ? 0 : minTTL().hashCode());
        hashCode = 31 * hashCode + ((allowedMethods() == null) ? 0 : allowedMethods().hashCode());
        hashCode = 31 * hashCode + ((smoothStreaming() == null) ? 0 : smoothStreaming().hashCode());
        hashCode = 31 * hashCode + ((defaultTTL() == null) ? 0 : defaultTTL().hashCode());
        hashCode = 31 * hashCode + ((maxTTL() == null) ? 0 : maxTTL().hashCode());
        hashCode = 31 * hashCode + ((compress() == null) ? 0 : compress().hashCode());
        hashCode = 31 * hashCode + ((lambdaFunctionAssociations() == null) ? 0 : lambdaFunctionAssociations().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultCacheBehavior)) {
            return false;
        }
        DefaultCacheBehavior other = (DefaultCacheBehavior) obj;
        if (other.targetOriginId() == null ^ this.targetOriginId() == null) {
            return false;
        }
        if (other.targetOriginId() != null && !other.targetOriginId().equals(this.targetOriginId())) {
            return false;
        }
        if (other.forwardedValues() == null ^ this.forwardedValues() == null) {
            return false;
        }
        if (other.forwardedValues() != null && !other.forwardedValues().equals(this.forwardedValues())) {
            return false;
        }
        if (other.trustedSigners() == null ^ this.trustedSigners() == null) {
            return false;
        }
        if (other.trustedSigners() != null && !other.trustedSigners().equals(this.trustedSigners())) {
            return false;
        }
        if (other.viewerProtocolPolicy() == null ^ this.viewerProtocolPolicy() == null) {
            return false;
        }
        if (other.viewerProtocolPolicy() != null && !other.viewerProtocolPolicy().equals(this.viewerProtocolPolicy())) {
            return false;
        }
        if (other.minTTL() == null ^ this.minTTL() == null) {
            return false;
        }
        if (other.minTTL() != null && !other.minTTL().equals(this.minTTL())) {
            return false;
        }
        if (other.allowedMethods() == null ^ this.allowedMethods() == null) {
            return false;
        }
        if (other.allowedMethods() != null && !other.allowedMethods().equals(this.allowedMethods())) {
            return false;
        }
        if (other.smoothStreaming() == null ^ this.smoothStreaming() == null) {
            return false;
        }
        if (other.smoothStreaming() != null && !other.smoothStreaming().equals(this.smoothStreaming())) {
            return false;
        }
        if (other.defaultTTL() == null ^ this.defaultTTL() == null) {
            return false;
        }
        if (other.defaultTTL() != null && !other.defaultTTL().equals(this.defaultTTL())) {
            return false;
        }
        if (other.maxTTL() == null ^ this.maxTTL() == null) {
            return false;
        }
        if (other.maxTTL() != null && !other.maxTTL().equals(this.maxTTL())) {
            return false;
        }
        if (other.compress() == null ^ this.compress() == null) {
            return false;
        }
        if (other.compress() != null && !other.compress().equals(this.compress())) {
            return false;
        }
        if (other.lambdaFunctionAssociations() == null ^ this.lambdaFunctionAssociations() == null) {
            return false;
        }
        if (other.lambdaFunctionAssociations() != null
                && !other.lambdaFunctionAssociations().equals(this.lambdaFunctionAssociations())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (targetOriginId() != null) {
            sb.append("TargetOriginId: ").append(targetOriginId()).append(",");
        }
        if (forwardedValues() != null) {
            sb.append("ForwardedValues: ").append(forwardedValues()).append(",");
        }
        if (trustedSigners() != null) {
            sb.append("TrustedSigners: ").append(trustedSigners()).append(",");
        }
        if (viewerProtocolPolicy() != null) {
            sb.append("ViewerProtocolPolicy: ").append(viewerProtocolPolicy()).append(",");
        }
        if (minTTL() != null) {
            sb.append("MinTTL: ").append(minTTL()).append(",");
        }
        if (allowedMethods() != null) {
            sb.append("AllowedMethods: ").append(allowedMethods()).append(",");
        }
        if (smoothStreaming() != null) {
            sb.append("SmoothStreaming: ").append(smoothStreaming()).append(",");
        }
        if (defaultTTL() != null) {
            sb.append("DefaultTTL: ").append(defaultTTL()).append(",");
        }
        if (maxTTL() != null) {
            sb.append("MaxTTL: ").append(maxTTL()).append(",");
        }
        if (compress() != null) {
            sb.append("Compress: ").append(compress()).append(",");
        }
        if (lambdaFunctionAssociations() != null) {
            sb.append("LambdaFunctionAssociations: ").append(lambdaFunctionAssociations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DefaultCacheBehavior> {
        /**
         * <p>
         * The value of <code>ID</code> for the origin that you want CloudFront to route requests to when a request
         * matches the path pattern either for a cache behavior or for the default cache behavior.
         * </p>
         * 
         * @param targetOriginId
         *        The value of <code>ID</code> for the origin that you want CloudFront to route requests to when a
         *        request matches the path pattern either for a cache behavior or for the default cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetOriginId(String targetOriginId);

        /**
         * <p>
         * A complex type that specifies how CloudFront handles query strings and cookies.
         * </p>
         * 
         * @param forwardedValues
         *        A complex type that specifies how CloudFront handles query strings and cookies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardedValues(ForwardedValues forwardedValues);

        /**
         * <p>
         * A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs for
         * private content.
         * </p>
         * <p>
         * If you want to require signed URLs in requests for objects in the target origin that match the
         * <code>PathPattern</code> for this cache behavior, specify <code>true</code> for <code>Enabled</code>, and
         * specify the applicable values for <code>Quantity</code> and <code>Items</code>. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront</a> in the <i>Amazon Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you don't want to require signed URLs in requests for objects that match <code>PathPattern</code>, specify
         * <code>false</code> for <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit
         * <code>Items</code>.
         * </p>
         * <p>
         * To add, change, or remove one or more trusted signers, change <code>Enabled</code> to <code>true</code> (if
         * it's currently <code>false</code>), change <code>Quantity</code> as applicable, and specify all of the
         * trusted signers that you want to include in the updated distribution.
         * </p>
         * 
         * @param trustedSigners
         *        A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs
         *        for private content.</p>
         *        <p>
         *        If you want to require signed URLs in requests for objects in the target origin that match the
         *        <code>PathPattern</code> for this cache behavior, specify <code>true</code> for <code>Enabled</code>,
         *        and specify the applicable values for <code>Quantity</code> and <code>Items</code>. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
         *        Private Content through CloudFront</a> in the <i>Amazon Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        If you don't want to require signed URLs in requests for objects that match <code>PathPattern</code>,
         *        specify <code>false</code> for <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit
         *        <code>Items</code>.
         *        </p>
         *        <p>
         *        To add, change, or remove one or more trusted signers, change <code>Enabled</code> to
         *        <code>true</code> (if it's currently <code>false</code>), change <code>Quantity</code> as applicable,
         *        and specify all of the trusted signers that you want to include in the updated distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedSigners(TrustedSigners trustedSigners);

        /**
         * <p>
         * The protocol that viewers can use to access the files in the origin specified by <code>TargetOriginId</code>
         * when a request matches the path pattern in <code>PathPattern</code>. You can specify the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allow-all</code>: Viewers can use HTTP or HTTPS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status code
         * of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request
         * using the new URL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403
         * (Forbidden).
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about requiring the HTTPS protocol, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html">Using an
         * HTTPS Connection to Access Your Objects</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is
         * never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we
         * recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an
         * edge location will return an object from the cache regardless of whether the current request protocol matches
         * the protocol used previously. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Specifying How Long
         * Objects and Errors Stay in a CloudFront Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer
         * Guide</i>.
         * </p>
         * </note>
         * 
         * @param viewerProtocolPolicy
         *        The protocol that viewers can use to access the files in the origin specified by
         *        <code>TargetOriginId</code> when a request matches the path pattern in <code>PathPattern</code>. You
         *        can specify the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allow-all</code>: Viewers can use HTTP or HTTPS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status
         *        code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the
         *        request using the new URL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of
         *        403 (Forbidden).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about requiring the HTTPS protocol, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html">Using
         *        an HTTPS Connection to Access Your Objects</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS
         *        is never to use any other protocol to fetch the object. If you have recently changed from HTTP to
         *        HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic.
         *        That means that an edge location will return an object from the cache regardless of whether the
         *        current request protocol matches the protocol used previously. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Specifying
         *        How Long Objects and Errors Stay in a CloudFront Edge Cache (Expiration)</a> in the <i>Amazon
         *        CloudFront Developer Guide</i>.
         *        </p>
         * @see ViewerProtocolPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewerProtocolPolicy
         */
        Builder viewerProtocolPolicy(String viewerProtocolPolicy);

        /**
         * <p>
         * The protocol that viewers can use to access the files in the origin specified by <code>TargetOriginId</code>
         * when a request matches the path pattern in <code>PathPattern</code>. You can specify the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allow-all</code>: Viewers can use HTTP or HTTPS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status code
         * of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request
         * using the new URL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403
         * (Forbidden).
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about requiring the HTTPS protocol, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html">Using an
         * HTTPS Connection to Access Your Objects</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is
         * never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we
         * recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an
         * edge location will return an object from the cache regardless of whether the current request protocol matches
         * the protocol used previously. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Specifying How Long
         * Objects and Errors Stay in a CloudFront Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer
         * Guide</i>.
         * </p>
         * </note>
         * 
         * @param viewerProtocolPolicy
         *        The protocol that viewers can use to access the files in the origin specified by
         *        <code>TargetOriginId</code> when a request matches the path pattern in <code>PathPattern</code>. You
         *        can specify the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allow-all</code>: Viewers can use HTTP or HTTPS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status
         *        code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the
         *        request using the new URL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of
         *        403 (Forbidden).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about requiring the HTTPS protocol, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html">Using
         *        an HTTPS Connection to Access Your Objects</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS
         *        is never to use any other protocol to fetch the object. If you have recently changed from HTTP to
         *        HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic.
         *        That means that an edge location will return an object from the cache regardless of whether the
         *        current request protocol matches the protocol used previously. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Specifying
         *        How Long Objects and Errors Stay in a CloudFront Edge Cache (Expiration)</a> in the <i>Amazon
         *        CloudFront Developer Guide</i>.
         *        </p>
         * @see ViewerProtocolPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewerProtocolPolicy
         */
        Builder viewerProtocolPolicy(ViewerProtocolPolicy viewerProtocolPolicy);

        /**
         * <p>
         * The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards
         * another request to your origin to determine whether the object has been updated. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Specifying How Long
         * Objects and Errors Stay in a CloudFront Edge Cache (Expiration)</a> in the <i>Amazon Amazon CloudFront
         * Developer Guide</i>.
         * </p>
         * <p>
         * You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all headers to
         * your origin (under <code>Headers</code>, if you specify <code>1</code> for <code>Quantity</code> and
         * <code>*</code> for <code>Name</code>).
         * </p>
         * 
         * @param minTTL
         *        The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront
         *        forwards another request to your origin to determine whether the object has been updated. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Specifying
         *        How Long Objects and Errors Stay in a CloudFront Edge Cache (Expiration)</a> in the <i>Amazon Amazon
         *        CloudFront Developer Guide</i>.</p>
         *        <p>
         *        You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all
         *        headers to your origin (under <code>Headers</code>, if you specify <code>1</code> for
         *        <code>Quantity</code> and <code>*</code> for <code>Name</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minTTL(Long minTTL);

        /**
         * Sets the value of the AllowedMethods property for this object.
         *
         * @param allowedMethods
         *        The new value for the AllowedMethods property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedMethods(AllowedMethods allowedMethods);

        /**
         * <p>
         * Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the
         * origin that is associated with this cache behavior. If so, specify <code>true</code>; if not, specify
         * <code>false</code>. If you specify <code>true</code> for <code>SmoothStreaming</code>, you can still
         * distribute other content using this cache behavior if the content matches the value of
         * <code>PathPattern</code>.
         * </p>
         * 
         * @param smoothStreaming
         *        Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using
         *        the origin that is associated with this cache behavior. If so, specify <code>true</code>; if not,
         *        specify <code>false</code>. If you specify <code>true</code> for <code>SmoothStreaming</code>, you can
         *        still distribute other content using this cache behavior if the content matches the value of
         *        <code>PathPattern</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smoothStreaming(Boolean smoothStreaming);

        /**
         * <p>
         * The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards
         * another request to your origin to determine whether the object has been updated. The value that you specify
         * applies only when your origin does not add HTTP headers such as <code>Cache-Control max-age</code>,
         * <code>Cache-Control s-maxage</code>, and <code>Expires</code> to objects. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Specifying How Long
         * Objects and Errors Stay in a CloudFront Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer
         * Guide</i>.
         * </p>
         * 
         * @param defaultTTL
         *        The default amount of time that you want objects to stay in CloudFront caches before CloudFront
         *        forwards another request to your origin to determine whether the object has been updated. The value
         *        that you specify applies only when your origin does not add HTTP headers such as
         *        <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and <code>Expires</code> to
         *        objects. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Specifying
         *        How Long Objects and Errors Stay in a CloudFront Edge Cache (Expiration)</a> in the <i>Amazon
         *        CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTTL(Long defaultTTL);

        /**
         * Sets the value of the MaxTTL property for this object.
         *
         * @param maxTTL
         *        The new value for the MaxTTL property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxTTL(Long maxTTL);

        /**
         * <p>
         * Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify
         * <code>true</code>; if not, specify <code>false</code>. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving
         * Compressed Files</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param compress
         *        Whether you want CloudFront to automatically compress certain files for this cache behavior. If so,
         *        specify <code>true</code>; if not, specify <code>false</code>. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html"
         *        >Serving Compressed Files</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compress(Boolean compress);

        /**
         * <p>
         * A complex type that contains zero or more Lambda function associations for a cache behavior.
         * </p>
         * 
         * @param lambdaFunctionAssociations
         *        A complex type that contains zero or more Lambda function associations for a cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionAssociations(LambdaFunctionAssociations lambdaFunctionAssociations);
    }

    private static final class BuilderImpl implements Builder {
        private String targetOriginId;

        private ForwardedValues forwardedValues;

        private TrustedSigners trustedSigners;

        private String viewerProtocolPolicy;

        private Long minTTL;

        private AllowedMethods allowedMethods;

        private Boolean smoothStreaming;

        private Long defaultTTL;

        private Long maxTTL;

        private Boolean compress;

        private LambdaFunctionAssociations lambdaFunctionAssociations;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultCacheBehavior model) {
            setTargetOriginId(model.targetOriginId);
            setForwardedValues(model.forwardedValues);
            setTrustedSigners(model.trustedSigners);
            setViewerProtocolPolicy(model.viewerProtocolPolicy);
            setMinTTL(model.minTTL);
            setAllowedMethods(model.allowedMethods);
            setSmoothStreaming(model.smoothStreaming);
            setDefaultTTL(model.defaultTTL);
            setMaxTTL(model.maxTTL);
            setCompress(model.compress);
            setLambdaFunctionAssociations(model.lambdaFunctionAssociations);
        }

        public final String getTargetOriginId() {
            return targetOriginId;
        }

        @Override
        public final Builder targetOriginId(String targetOriginId) {
            this.targetOriginId = targetOriginId;
            return this;
        }

        public final void setTargetOriginId(String targetOriginId) {
            this.targetOriginId = targetOriginId;
        }

        public final ForwardedValues getForwardedValues() {
            return forwardedValues;
        }

        @Override
        public final Builder forwardedValues(ForwardedValues forwardedValues) {
            this.forwardedValues = forwardedValues;
            return this;
        }

        public final void setForwardedValues(ForwardedValues forwardedValues) {
            this.forwardedValues = forwardedValues;
        }

        public final TrustedSigners getTrustedSigners() {
            return trustedSigners;
        }

        @Override
        public final Builder trustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        public final void setTrustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
        }

        public final String getViewerProtocolPolicy() {
            return viewerProtocolPolicy;
        }

        @Override
        public final Builder viewerProtocolPolicy(String viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
            return this;
        }

        @Override
        public final Builder viewerProtocolPolicy(ViewerProtocolPolicy viewerProtocolPolicy) {
            this.viewerProtocolPolicy(viewerProtocolPolicy.toString());
            return this;
        }

        public final void setViewerProtocolPolicy(String viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
        }

        public final void setViewerProtocolPolicy(ViewerProtocolPolicy viewerProtocolPolicy) {
            this.viewerProtocolPolicy(viewerProtocolPolicy.toString());
        }

        public final Long getMinTTL() {
            return minTTL;
        }

        @Override
        public final Builder minTTL(Long minTTL) {
            this.minTTL = minTTL;
            return this;
        }

        public final void setMinTTL(Long minTTL) {
            this.minTTL = minTTL;
        }

        public final AllowedMethods getAllowedMethods() {
            return allowedMethods;
        }

        @Override
        public final Builder allowedMethods(AllowedMethods allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        public final void setAllowedMethods(AllowedMethods allowedMethods) {
            this.allowedMethods = allowedMethods;
        }

        public final Boolean getSmoothStreaming() {
            return smoothStreaming;
        }

        @Override
        public final Builder smoothStreaming(Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
            return this;
        }

        public final void setSmoothStreaming(Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
        }

        public final Long getDefaultTTL() {
            return defaultTTL;
        }

        @Override
        public final Builder defaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
            return this;
        }

        public final void setDefaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
        }

        public final Long getMaxTTL() {
            return maxTTL;
        }

        @Override
        public final Builder maxTTL(Long maxTTL) {
            this.maxTTL = maxTTL;
            return this;
        }

        public final void setMaxTTL(Long maxTTL) {
            this.maxTTL = maxTTL;
        }

        public final Boolean getCompress() {
            return compress;
        }

        @Override
        public final Builder compress(Boolean compress) {
            this.compress = compress;
            return this;
        }

        public final void setCompress(Boolean compress) {
            this.compress = compress;
        }

        public final LambdaFunctionAssociations getLambdaFunctionAssociations() {
            return lambdaFunctionAssociations;
        }

        @Override
        public final Builder lambdaFunctionAssociations(LambdaFunctionAssociations lambdaFunctionAssociations) {
            this.lambdaFunctionAssociations = lambdaFunctionAssociations;
            return this;
        }

        public final void setLambdaFunctionAssociations(LambdaFunctionAssociations lambdaFunctionAssociations) {
            this.lambdaFunctionAssociations = lambdaFunctionAssociations;
        }

        @Override
        public DefaultCacheBehavior build() {
            return new DefaultCacheBehavior(this);
        }
    }
}
