/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the list of Custom Headers for each origin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CustomHeaders implements ToCopyableBuilder<CustomHeaders.Builder, CustomHeaders> {
    private final Integer quantity;

    private final List<OriginCustomHeader> items;

    private CustomHeaders(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The number of custom headers, if any, for this distribution.
     * </p>
     * 
     * @return The number of custom headers, if any, for this distribution.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * <b>Optional</b>: A list that contains one <code>OriginCustomHeader</code> element for each custom header that you
     * want CloudFront to forward to the origin. If Quantity is <code>0</code>, omit <code>Items</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return <b>Optional</b>: A list that contains one <code>OriginCustomHeader</code> element for each custom header
     *         that you want CloudFront to forward to the origin. If Quantity is <code>0</code>, omit <code>Items</code>
     *         .
     */
    public List<OriginCustomHeader> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((quantity() == null) ? 0 : quantity().hashCode());
        hashCode = 31 * hashCode + ((items() == null) ? 0 : items().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomHeaders)) {
            return false;
        }
        CustomHeaders other = (CustomHeaders) obj;
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        if (other.items() != null && !other.items().equals(this.items())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (quantity() != null) {
            sb.append("Quantity: ").append(quantity()).append(",");
        }
        if (items() != null) {
            sb.append("Items: ").append(items()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CustomHeaders> {
        /**
         * <p>
         * The number of custom headers, if any, for this distribution.
         * </p>
         * 
         * @param quantity
         *        The number of custom headers, if any, for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * <b>Optional</b>: A list that contains one <code>OriginCustomHeader</code> element for each custom header that
         * you want CloudFront to forward to the origin. If Quantity is <code>0</code>, omit <code>Items</code>.
         * </p>
         * 
         * @param items
         *        <b>Optional</b>: A list that contains one <code>OriginCustomHeader</code> element for each custom
         *        header that you want CloudFront to forward to the origin. If Quantity is <code>0</code>, omit
         *        <code>Items</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<OriginCustomHeader> items);

        /**
         * <p>
         * <b>Optional</b>: A list that contains one <code>OriginCustomHeader</code> element for each custom header that
         * you want CloudFront to forward to the origin. If Quantity is <code>0</code>, omit <code>Items</code>.
         * </p>
         * 
         * @param items
         *        <b>Optional</b>: A list that contains one <code>OriginCustomHeader</code> element for each custom
         *        header that you want CloudFront to forward to the origin. If Quantity is <code>0</code>, omit
         *        <code>Items</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(OriginCustomHeader... items);
    }

    private static final class BuilderImpl implements Builder {
        private Integer quantity;

        private List<OriginCustomHeader> items;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomHeaders model) {
            setQuantity(model.quantity);
            setItems(model.items);
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<OriginCustomHeader> getItems() {
            return items;
        }

        @Override
        public final Builder items(Collection<OriginCustomHeader> items) {
            this.items = OriginCustomHeadersListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(OriginCustomHeader... items) {
            items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<OriginCustomHeader> items) {
            this.items = OriginCustomHeadersListCopier.copy(items);
        }

        @SafeVarargs
        public final void setItems(OriginCustomHeader... items) {
            items(Arrays.asList(items));
        }

        @Override
        public CustomHeaders build() {
            return new CustomHeaders(this);
        }
    }
}
