/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to create a new streaming distribution with tags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateStreamingDistributionWithTagsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateStreamingDistributionWithTagsRequest.Builder, CreateStreamingDistributionWithTagsRequest> {
    private final StreamingDistributionConfigWithTags streamingDistributionConfigWithTags;

    private CreateStreamingDistributionWithTagsRequest(BuilderImpl builder) {
        this.streamingDistributionConfigWithTags = builder.streamingDistributionConfigWithTags;
    }

    /**
     * <p>
     * The streaming distribution's configuration information.
     * </p>
     * 
     * @return The streaming distribution's configuration information.
     */
    public StreamingDistributionConfigWithTags streamingDistributionConfigWithTags() {
        return streamingDistributionConfigWithTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + ((streamingDistributionConfigWithTags() == null) ? 0 : streamingDistributionConfigWithTags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingDistributionWithTagsRequest)) {
            return false;
        }
        CreateStreamingDistributionWithTagsRequest other = (CreateStreamingDistributionWithTagsRequest) obj;
        if (other.streamingDistributionConfigWithTags() == null ^ this.streamingDistributionConfigWithTags() == null) {
            return false;
        }
        if (other.streamingDistributionConfigWithTags() != null
                && !other.streamingDistributionConfigWithTags().equals(this.streamingDistributionConfigWithTags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamingDistributionConfigWithTags() != null) {
            sb.append("StreamingDistributionConfigWithTags: ").append(streamingDistributionConfigWithTags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateStreamingDistributionWithTagsRequest> {
        /**
         * <p>
         * The streaming distribution's configuration information.
         * </p>
         * 
         * @param streamingDistributionConfigWithTags
         *        The streaming distribution's configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistributionConfigWithTags(StreamingDistributionConfigWithTags streamingDistributionConfigWithTags);
    }

    private static final class BuilderImpl implements Builder {
        private StreamingDistributionConfigWithTags streamingDistributionConfigWithTags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingDistributionWithTagsRequest model) {
            setStreamingDistributionConfigWithTags(model.streamingDistributionConfigWithTags);
        }

        public final StreamingDistributionConfigWithTags getStreamingDistributionConfigWithTags() {
            return streamingDistributionConfigWithTags;
        }

        @Override
        public final Builder streamingDistributionConfigWithTags(
                StreamingDistributionConfigWithTags streamingDistributionConfigWithTags) {
            this.streamingDistributionConfigWithTags = streamingDistributionConfigWithTags;
            return this;
        }

        public final void setStreamingDistributionConfigWithTags(
                StreamingDistributionConfigWithTags streamingDistributionConfigWithTags) {
            this.streamingDistributionConfigWithTags = streamingDistributionConfigWithTags;
        }

        @Override
        public CreateStreamingDistributionWithTagsRequest build() {
            return new CreateStreamingDistributionWithTagsRequest(this);
        }
    }
}
