/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to create a new streaming distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateStreamingDistributionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateStreamingDistributionRequest.Builder, CreateStreamingDistributionRequest> {
    private final StreamingDistributionConfig streamingDistributionConfig;

    private CreateStreamingDistributionRequest(BuilderImpl builder) {
        this.streamingDistributionConfig = builder.streamingDistributionConfig;
    }

    /**
     * <p>
     * The streaming distribution's configuration information.
     * </p>
     * 
     * @return The streaming distribution's configuration information.
     */
    public StreamingDistributionConfig streamingDistributionConfig() {
        return streamingDistributionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamingDistributionConfig() == null) ? 0 : streamingDistributionConfig().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingDistributionRequest)) {
            return false;
        }
        CreateStreamingDistributionRequest other = (CreateStreamingDistributionRequest) obj;
        if (other.streamingDistributionConfig() == null ^ this.streamingDistributionConfig() == null) {
            return false;
        }
        if (other.streamingDistributionConfig() != null
                && !other.streamingDistributionConfig().equals(this.streamingDistributionConfig())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamingDistributionConfig() != null) {
            sb.append("StreamingDistributionConfig: ").append(streamingDistributionConfig()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateStreamingDistributionRequest> {
        /**
         * <p>
         * The streaming distribution's configuration information.
         * </p>
         * 
         * @param streamingDistributionConfig
         *        The streaming distribution's configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig);
    }

    private static final class BuilderImpl implements Builder {
        private StreamingDistributionConfig streamingDistributionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingDistributionRequest model) {
            setStreamingDistributionConfig(model.streamingDistributionConfig);
        }

        public final StreamingDistributionConfig getStreamingDistributionConfig() {
            return streamingDistributionConfig;
        }

        @Override
        public final Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
            return this;
        }

        public final void setStreamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
        }

        @Override
        public CreateStreamingDistributionRequest build() {
            return new CreateStreamingDistributionRequest(this);
        }
    }
}
