/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDistributionWithTagsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateDistributionWithTagsResponse.Builder, CreateDistributionWithTagsResponse> {
    private final Distribution distribution;

    private final String location;

    private final String eTag;

    private CreateDistributionWithTagsResponse(BuilderImpl builder) {
        this.distribution = builder.distribution;
        this.location = builder.location;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The distribution's information.
     * </p>
     * 
     * @return The distribution's information.
     */
    public Distribution distribution() {
        return distribution;
    }

    /**
     * <p>
     * The fully qualified URI of the new distribution resource just created. For example:
     * <code>https://cloudfront.amazonaws.com/2010-11-01/distribution/EDFDVBD632BHDS5</code>.
     * </p>
     * 
     * @return The fully qualified URI of the new distribution resource just created. For example:
     *         <code>https://cloudfront.amazonaws.com/2010-11-01/distribution/EDFDVBD632BHDS5</code>.
     */
    public String location() {
        return location;
    }

    /**
     * <p>
     * The current version of the distribution created.
     * </p>
     * 
     * @return The current version of the distribution created.
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((distribution() == null) ? 0 : distribution().hashCode());
        hashCode = 31 * hashCode + ((location() == null) ? 0 : location().hashCode());
        hashCode = 31 * hashCode + ((eTag() == null) ? 0 : eTag().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDistributionWithTagsResponse)) {
            return false;
        }
        CreateDistributionWithTagsResponse other = (CreateDistributionWithTagsResponse) obj;
        if (other.distribution() == null ^ this.distribution() == null) {
            return false;
        }
        if (other.distribution() != null && !other.distribution().equals(this.distribution())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.eTag() == null ^ this.eTag() == null) {
            return false;
        }
        if (other.eTag() != null && !other.eTag().equals(this.eTag())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (distribution() != null) {
            sb.append("Distribution: ").append(distribution()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        if (eTag() != null) {
            sb.append("ETag: ").append(eTag()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDistributionWithTagsResponse> {
        /**
         * <p>
         * The distribution's information.
         * </p>
         * 
         * @param distribution
         *        The distribution's information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distribution(Distribution distribution);

        /**
         * <p>
         * The fully qualified URI of the new distribution resource just created. For example:
         * <code>https://cloudfront.amazonaws.com/2010-11-01/distribution/EDFDVBD632BHDS5</code>.
         * </p>
         * 
         * @param location
         *        The fully qualified URI of the new distribution resource just created. For example:
         *        <code>https://cloudfront.amazonaws.com/2010-11-01/distribution/EDFDVBD632BHDS5</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The current version of the distribution created.
         * </p>
         * 
         * @param eTag
         *        The current version of the distribution created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    private static final class BuilderImpl implements Builder {
        private Distribution distribution;

        private String location;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDistributionWithTagsResponse model) {
            setDistribution(model.distribution);
            setLocation(model.location);
            setETag(model.eTag);
        }

        public final Distribution getDistribution() {
            return distribution;
        }

        @Override
        public final Builder distribution(Distribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public final void setDistribution(Distribution distribution) {
            this.distribution = distribution;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public CreateDistributionWithTagsResponse build() {
            return new CreateDistributionWithTagsResponse(this);
        }
    }
}
