/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones.
 * For more information about forwarding cookies to the origin, see <a
 * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront Forwards,
 * Caches, and Logs Cookies</a> in the <i>Amazon CloudFront Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CookiePreference implements ToCopyableBuilder<CookiePreference.Builder, CookiePreference> {
    private final String forward;

    private final CookieNames whitelistedNames;

    private CookiePreference(BuilderImpl builder) {
        this.forward = builder.forward;
        this.whitelistedNames = builder.whitelistedNames;
    }

    /**
     * <p>
     * Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of cookies
     * specified in the <code>WhitelistedNames</code> complex type.
     * </p>
     * <p>
     * Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin, specify
     * none for the <code>Forward</code> element.
     * </p>
     * 
     * @return Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of
     *         cookies specified in the <code>WhitelistedNames</code> complex type.</p>
     *         <p>
     *         Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin,
     *         specify none for the <code>Forward</code> element.
     * @see ItemSelection
     */
    public String forward() {
        return forward;
    }

    /**
     * <p>
     * Required if you specify <code>whitelist</code> for the value of <code>Forward:</code>. A complex type that
     * specifies how many different cookies you want CloudFront to forward to the origin for this cache behavior and, if
     * you want to forward selected cookies, the names of those cookies.
     * </p>
     * <p>
     * If you specify <code>all</code> or none for the value of <code>Forward</code>, omit <code>WhitelistedNames</code>
     * . If you change the value of <code>Forward</code> from <code>whitelist</code> to all or none and you don't delete
     * the <code>WhitelistedNames</code> element and its child elements, CloudFront deletes them automatically.
     * </p>
     * <p>
     * For the current limit on the number of cookie names that you can whitelist for each cache behavior, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_cloudfront">Amazon CloudFront
     * Limits</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return Required if you specify <code>whitelist</code> for the value of <code>Forward:</code>. A complex type
     *         that specifies how many different cookies you want CloudFront to forward to the origin for this cache
     *         behavior and, if you want to forward selected cookies, the names of those cookies.</p>
     *         <p>
     *         If you specify <code>all</code> or none for the value of <code>Forward</code>, omit
     *         <code>WhitelistedNames</code>. If you change the value of <code>Forward</code> from
     *         <code>whitelist</code> to all or none and you don't delete the <code>WhitelistedNames</code> element and
     *         its child elements, CloudFront deletes them automatically.
     *         </p>
     *         <p>
     *         For the current limit on the number of cookie names that you can whitelist for each cache behavior, see
     *         <a href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_cloudfront">Amazon
     *         CloudFront Limits</a> in the <i>AWS General Reference</i>.
     */
    public CookieNames whitelistedNames() {
        return whitelistedNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((forward() == null) ? 0 : forward().hashCode());
        hashCode = 31 * hashCode + ((whitelistedNames() == null) ? 0 : whitelistedNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CookiePreference)) {
            return false;
        }
        CookiePreference other = (CookiePreference) obj;
        if (other.forward() == null ^ this.forward() == null) {
            return false;
        }
        if (other.forward() != null && !other.forward().equals(this.forward())) {
            return false;
        }
        if (other.whitelistedNames() == null ^ this.whitelistedNames() == null) {
            return false;
        }
        if (other.whitelistedNames() != null && !other.whitelistedNames().equals(this.whitelistedNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (forward() != null) {
            sb.append("Forward: ").append(forward()).append(",");
        }
        if (whitelistedNames() != null) {
            sb.append("WhitelistedNames: ").append(whitelistedNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CookiePreference> {
        /**
         * <p>
         * Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of cookies
         * specified in the <code>WhitelistedNames</code> complex type.
         * </p>
         * <p>
         * Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin,
         * specify none for the <code>Forward</code> element.
         * </p>
         * 
         * @param forward
         *        Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of
         *        cookies specified in the <code>WhitelistedNames</code> complex type.</p>
         *        <p>
         *        Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3
         *        origin, specify none for the <code>Forward</code> element.
         * @see ItemSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ItemSelection
         */
        Builder forward(String forward);

        /**
         * <p>
         * Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of cookies
         * specified in the <code>WhitelistedNames</code> complex type.
         * </p>
         * <p>
         * Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin,
         * specify none for the <code>Forward</code> element.
         * </p>
         * 
         * @param forward
         *        Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of
         *        cookies specified in the <code>WhitelistedNames</code> complex type.</p>
         *        <p>
         *        Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3
         *        origin, specify none for the <code>Forward</code> element.
         * @see ItemSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ItemSelection
         */
        Builder forward(ItemSelection forward);

        /**
         * <p>
         * Required if you specify <code>whitelist</code> for the value of <code>Forward:</code>. A complex type that
         * specifies how many different cookies you want CloudFront to forward to the origin for this cache behavior
         * and, if you want to forward selected cookies, the names of those cookies.
         * </p>
         * <p>
         * If you specify <code>all</code> or none for the value of <code>Forward</code>, omit
         * <code>WhitelistedNames</code>. If you change the value of <code>Forward</code> from <code>whitelist</code> to
         * all or none and you don't delete the <code>WhitelistedNames</code> element and its child elements, CloudFront
         * deletes them automatically.
         * </p>
         * <p>
         * For the current limit on the number of cookie names that you can whitelist for each cache behavior, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_cloudfront">Amazon
         * CloudFront Limits</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param whitelistedNames
         *        Required if you specify <code>whitelist</code> for the value of <code>Forward:</code>. A complex type
         *        that specifies how many different cookies you want CloudFront to forward to the origin for this cache
         *        behavior and, if you want to forward selected cookies, the names of those cookies.</p>
         *        <p>
         *        If you specify <code>all</code> or none for the value of <code>Forward</code>, omit
         *        <code>WhitelistedNames</code>. If you change the value of <code>Forward</code> from
         *        <code>whitelist</code> to all or none and you don't delete the <code>WhitelistedNames</code> element
         *        and its child elements, CloudFront deletes them automatically.
         *        </p>
         *        <p>
         *        For the current limit on the number of cookie names that you can whitelist for each cache behavior,
         *        see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_cloudfront">Amazon
         *        CloudFront Limits</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whitelistedNames(CookieNames whitelistedNames);
    }

    private static final class BuilderImpl implements Builder {
        private String forward;

        private CookieNames whitelistedNames;

        private BuilderImpl() {
        }

        private BuilderImpl(CookiePreference model) {
            setForward(model.forward);
            setWhitelistedNames(model.whitelistedNames);
        }

        public final String getForward() {
            return forward;
        }

        @Override
        public final Builder forward(String forward) {
            this.forward = forward;
            return this;
        }

        @Override
        public final Builder forward(ItemSelection forward) {
            this.forward(forward.toString());
            return this;
        }

        public final void setForward(String forward) {
            this.forward = forward;
        }

        public final void setForward(ItemSelection forward) {
            this.forward(forward.toString());
        }

        public final CookieNames getWhitelistedNames() {
            return whitelistedNames;
        }

        @Override
        public final Builder whitelistedNames(CookieNames whitelistedNames) {
            this.whitelistedNames = whitelistedNames;
            return this;
        }

        public final void setWhitelistedNames(CookieNames whitelistedNames) {
            this.whitelistedNames = whitelistedNames;
        }

        @Override
        public CookiePreference build() {
            return new CookiePreference(this);
        }
    }
}
