/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains zero or more <code>CacheBehavior</code> elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CacheBehaviors implements ToCopyableBuilder<CacheBehaviors.Builder, CacheBehaviors> {
    private final Integer quantity;

    private final List<CacheBehavior> items;

    private CacheBehaviors(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The number of cache behaviors for this distribution.
     * </p>
     * 
     * @return The number of cache behaviors for this distribution.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * Optional: A complex type that contains cache behaviors for this distribution. If <code>Quantity</code> is
     * <code>0</code>, you can omit <code>Items</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Optional: A complex type that contains cache behaviors for this distribution. If <code>Quantity</code> is
     *         <code>0</code>, you can omit <code>Items</code>.
     */
    public List<CacheBehavior> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((quantity() == null) ? 0 : quantity().hashCode());
        hashCode = 31 * hashCode + ((items() == null) ? 0 : items().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheBehaviors)) {
            return false;
        }
        CacheBehaviors other = (CacheBehaviors) obj;
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        if (other.items() != null && !other.items().equals(this.items())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (quantity() != null) {
            sb.append("Quantity: ").append(quantity()).append(",");
        }
        if (items() != null) {
            sb.append("Items: ").append(items()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CacheBehaviors> {
        /**
         * <p>
         * The number of cache behaviors for this distribution.
         * </p>
         * 
         * @param quantity
         *        The number of cache behaviors for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * Optional: A complex type that contains cache behaviors for this distribution. If <code>Quantity</code> is
         * <code>0</code>, you can omit <code>Items</code>.
         * </p>
         * 
         * @param items
         *        Optional: A complex type that contains cache behaviors for this distribution. If <code>Quantity</code>
         *        is <code>0</code>, you can omit <code>Items</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<CacheBehavior> items);

        /**
         * <p>
         * Optional: A complex type that contains cache behaviors for this distribution. If <code>Quantity</code> is
         * <code>0</code>, you can omit <code>Items</code>.
         * </p>
         * 
         * @param items
         *        Optional: A complex type that contains cache behaviors for this distribution. If <code>Quantity</code>
         *        is <code>0</code>, you can omit <code>Items</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(CacheBehavior... items);
    }

    private static final class BuilderImpl implements Builder {
        private Integer quantity;

        private List<CacheBehavior> items;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheBehaviors model) {
            setQuantity(model.quantity);
            setItems(model.items);
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<CacheBehavior> getItems() {
            return items;
        }

        @Override
        public final Builder items(Collection<CacheBehavior> items) {
            this.items = CacheBehaviorListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(CacheBehavior... items) {
            items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<CacheBehavior> items) {
            this.items = CacheBehaviorListCopier.copy(items);
        }

        @SafeVarargs
        public final void setItems(CacheBehavior... items) {
            items(Arrays.asList(items));
        }

        @Override
        public CacheBehaviors build() {
            return new CacheBehaviors(this);
        }
    }
}
