/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudfront.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * DistributionSummary StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DistributionSummaryUnmarshaller implements Unmarshaller<DistributionSummary, StaxUnmarshallerContext> {

    public DistributionSummary unmarshall(StaxUnmarshallerContext context) throws Exception {
        DistributionSummary.Builder distributionSummary = DistributionSummary.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Id", targetDepth)) {
                    distributionSummary.id(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ARN", targetDepth)) {
                    distributionSummary.arn(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Status", targetDepth)) {
                    distributionSummary.status(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("LastModifiedTime", targetDepth)) {
                    distributionSummary.lastModifiedTime(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DomainName", targetDepth)) {
                    distributionSummary.domainName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Aliases", targetDepth)) {
                    distributionSummary.aliases(AliasesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Origins", targetDepth)) {
                    distributionSummary.origins(OriginsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DefaultCacheBehavior", targetDepth)) {
                    distributionSummary.defaultCacheBehavior(DefaultCacheBehaviorUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CacheBehaviors", targetDepth)) {
                    distributionSummary.cacheBehaviors(CacheBehaviorsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CustomErrorResponses", targetDepth)) {
                    distributionSummary.customErrorResponses(CustomErrorResponsesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Comment", targetDepth)) {
                    distributionSummary.comment(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("PriceClass", targetDepth)) {
                    distributionSummary.priceClass(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Enabled", targetDepth)) {
                    distributionSummary.enabled(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ViewerCertificate", targetDepth)) {
                    distributionSummary.viewerCertificate(ViewerCertificateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Restrictions", targetDepth)) {
                    distributionSummary.restrictions(RestrictionsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("WebACLId", targetDepth)) {
                    distributionSummary.webACLId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("HttpVersion", targetDepth)) {
                    distributionSummary.httpVersion(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IsIPV6Enabled", targetDepth)) {
                    distributionSummary.isIPV6Enabled(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return distributionSummary.build();
    }

    private static final DistributionSummaryUnmarshaller INSTANCE = new DistributionSummaryUnmarshaller();

    public static DistributionSummaryUnmarshaller getInstance() {
        return INSTANCE;
    }
}
