/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.transform;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudfront.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.utils.StringInputStream;

import software.amazon.awssdk.core.util.xml.XmlWriter;

/**
 * CreateStreamingDistributionWithTagsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateStreamingDistributionWithTagsRequestMarshaller implements
        Marshaller<Request<CreateStreamingDistributionWithTagsRequest>, CreateStreamingDistributionWithTagsRequest> {

    public Request<CreateStreamingDistributionWithTagsRequest> marshall(
            CreateStreamingDistributionWithTagsRequest createStreamingDistributionWithTagsRequest) {

        if (createStreamingDistributionWithTagsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<CreateStreamingDistributionWithTagsRequest> request = new DefaultRequest<CreateStreamingDistributionWithTagsRequest>(
                createStreamingDistributionWithTagsRequest, "CloudFrontClient");

        request.setHttpMethod(HttpMethodName.POST);

        String uriResourcePath = "/2017-03-25/streaming-distribution?WithTags";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = null;
            StreamingDistributionConfigWithTags streamingDistributionConfigWithTags = createStreamingDistributionWithTagsRequest
                    .streamingDistributionConfigWithTags();
            if (streamingDistributionConfigWithTags != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2017-03-25/");
                xmlWriter.startElement("StreamingDistributionConfigWithTags");

                StreamingDistributionConfig streamingDistributionConfig = streamingDistributionConfigWithTags
                        .streamingDistributionConfig();
                if (streamingDistributionConfig != null) {
                    xmlWriter.startElement("StreamingDistributionConfig");

                    if (streamingDistributionConfig.callerReference() != null) {
                        xmlWriter.startElement("CallerReference").value(streamingDistributionConfig.callerReference())
                                .endElement();
                    }

                    S3Origin s3Origin = streamingDistributionConfig.s3Origin();
                    if (s3Origin != null) {
                        xmlWriter.startElement("S3Origin");

                        if (s3Origin.domainName() != null) {
                            xmlWriter.startElement("DomainName").value(s3Origin.domainName()).endElement();
                        }

                        if (s3Origin.originAccessIdentity() != null) {
                            xmlWriter.startElement("OriginAccessIdentity").value(s3Origin.originAccessIdentity()).endElement();
                        }
                        xmlWriter.endElement();
                    }

                    Aliases aliases = streamingDistributionConfig.aliases();
                    if (aliases != null) {
                        xmlWriter.startElement("Aliases");

                        if (aliases.quantity() != null) {
                            xmlWriter.startElement("Quantity").value(aliases.quantity()).endElement();
                        }

                        java.util.List<String> aliasesItemsList = aliases.items();
                        if (!aliasesItemsList.isEmpty()
                                || !(aliasesItemsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                            xmlWriter.startElement("Items");

                            for (String aliasesItemsListValue : aliasesItemsList) {
                                xmlWriter.startElement("CNAME");
                                xmlWriter.value(aliasesItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }

                    if (streamingDistributionConfig.comment() != null) {
                        xmlWriter.startElement("Comment").value(streamingDistributionConfig.comment()).endElement();
                    }

                    StreamingLoggingConfig logging = streamingDistributionConfig.logging();
                    if (logging != null) {
                        xmlWriter.startElement("Logging");

                        if (logging.enabled() != null) {
                            xmlWriter.startElement("Enabled").value(logging.enabled()).endElement();
                        }

                        if (logging.bucket() != null) {
                            xmlWriter.startElement("Bucket").value(logging.bucket()).endElement();
                        }

                        if (logging.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(logging.prefix()).endElement();
                        }
                        xmlWriter.endElement();
                    }

                    TrustedSigners trustedSigners = streamingDistributionConfig.trustedSigners();
                    if (trustedSigners != null) {
                        xmlWriter.startElement("TrustedSigners");

                        if (trustedSigners.enabled() != null) {
                            xmlWriter.startElement("Enabled").value(trustedSigners.enabled()).endElement();
                        }

                        if (trustedSigners.quantity() != null) {
                            xmlWriter.startElement("Quantity").value(trustedSigners.quantity()).endElement();
                        }

                        java.util.List<String> trustedSignersItemsList = trustedSigners.items();
                        if (!trustedSignersItemsList.isEmpty()
                                || !(trustedSignersItemsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                            xmlWriter.startElement("Items");

                            for (String trustedSignersItemsListValue : trustedSignersItemsList) {
                                xmlWriter.startElement("AwsAccountNumber");
                                xmlWriter.value(trustedSignersItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }

                    if (streamingDistributionConfig.priceClassAsString() != null) {
                        xmlWriter.startElement("PriceClass").value(streamingDistributionConfig.priceClassAsString()).endElement();
                    }

                    if (streamingDistributionConfig.enabled() != null) {
                        xmlWriter.startElement("Enabled").value(streamingDistributionConfig.enabled()).endElement();
                    }
                    xmlWriter.endElement();
                }

                Tags tags = streamingDistributionConfigWithTags.tags();
                if (tags != null) {
                    xmlWriter.startElement("Tags");

                    java.util.List<Tag> tagsItemsList = tags.items();
                    if (!tagsItemsList.isEmpty()
                            || !(tagsItemsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                        xmlWriter.startElement("Items");

                        for (Tag tagsItemsListValue : tagsItemsList) {
                            xmlWriter.startElement("Tag");

                            if (tagsItemsListValue.key() != null) {
                                xmlWriter.startElement("Key").value(tagsItemsListValue.key()).endElement();
                            }

                            if (tagsItemsListValue.value() != null) {
                                xmlWriter.startElement("Value").value(tagsItemsListValue.value()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }

        return request;
    }

}