/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudfront.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * CloudFrontOriginAccessIdentityList StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CloudFrontOriginAccessIdentityListUnmarshaller implements
        Unmarshaller<CloudFrontOriginAccessIdentityList, StaxUnmarshallerContext> {

    public CloudFrontOriginAccessIdentityList unmarshall(StaxUnmarshallerContext context) throws Exception {
        CloudFrontOriginAccessIdentityList.Builder cloudFrontOriginAccessIdentityList = CloudFrontOriginAccessIdentityList
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<CloudFrontOriginAccessIdentitySummary> items = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                cloudFrontOriginAccessIdentityList.items(items);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Marker", targetDepth)) {
                    cloudFrontOriginAccessIdentityList.marker(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextMarker", targetDepth)) {
                    cloudFrontOriginAccessIdentityList.nextMarker(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxItems", targetDepth)) {
                    cloudFrontOriginAccessIdentityList.maxItems(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IsTruncated", targetDepth)) {
                    cloudFrontOriginAccessIdentityList.isTruncated(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Quantity", targetDepth)) {
                    cloudFrontOriginAccessIdentityList.quantity(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Items", targetDepth)) {
                    items = new ArrayList<CloudFrontOriginAccessIdentitySummary>();
                    continue;
                }

                if (context.testExpression("Items/CloudFrontOriginAccessIdentitySummary", targetDepth)) {
                    items.add(CloudFrontOriginAccessIdentitySummaryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    cloudFrontOriginAccessIdentityList.items(items);
                    break;
                }
            }
        }
        return cloudFrontOriginAccessIdentityList.build();
    }

    private static final CloudFrontOriginAccessIdentityListUnmarshaller INSTANCE = new CloudFrontOriginAccessIdentityListUnmarshaller();

    public static CloudFrontOriginAccessIdentityListUnmarshaller getInstance() {
        return INSTANCE;
    }
}
